/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rake.workspace.sync.RakeTasksManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.tasks.rake.RakeActionsUtil;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtil;

public class ReloadRakeTasksAction
extends AnAction
implements DumbAware {
    private static AnAction myInstance;

    public static AnAction getInstance() {
        if (myInstance == null) {
            myInstance = ActionManager.getInstance().getAction("org.jetbrains.plugins.ruby.rails.actions.rake.ReloadRakeTasksAction");
        }
        return myInstance;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            ReloadRakeTasksAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)ObjectUtils.coalesce((Object)event.getProject(), (Object)((Project)event.getData(CommonDataKeys.PROJECT)))) == null || project.isDisposed()) {
            return;
        }
        Module module = RakeActionsUtil.getContextModule(event.getDataContext());
        assert (module != null);
        assert (!module.isDisposed());
        FileDocumentManager.getInstance().saveAllDocuments();
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            String msg = RBundle.message((String)"rails.facet.action.regenerate.rakeTasks.error.wrong.sdk");
            String title = RBundle.message((String)"action.registered.shortcut.execute.disabled.title");
            Messages.showErrorDialog((Project)module.getProject(), (String)msg, (String)title);
            return;
        }
        RakeTasksManager.getInstance(project).refresh(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ReloadRakeTasksAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent event) {
        Module module;
        if (event == null) {
            ReloadRakeTasksAction.$$$reportNull$$$0(2);
        }
        boolean isEnabled = (module = RakeActionsUtil.getContextModule(event.getDataContext())) != null && RakeUtil.rakeFileExists(RakeUtil.getRakeHomeDir(module));
        event.getPresentation().setEnabled(isEnabled);
        RakeActionsUtil.setRakeActionVisibility(event);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/ReloadRakeTasksAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/ReloadRakeTasksAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

