/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtilBase;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfiguration;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfigurationFactory;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfigurationType;
import org.jetbrains.plugins.ruby.tasks.rake.task.RakeActionPanel;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;

public final class RakeUtil
extends RakeUtilBase {
    @NonNls
    public static final String RAKE_GEM_NAME = "rake";
    @NonNls
    public static final String OPTIONS_DRYRUN = "--dry-run";
    @NonNls
    public static final String OPTIONS_PREREQS = "--prereqs";
    @NonNls
    public static final String TASK_MIGRATE_FULLCMD = "db:migrate";
    private static final Logger LOG = Logger.getInstance(RakeUtil.class);
    @NonNls
    public static final String RAKE_GEM_EXECUTABLE = "rake";
    @NonNls
    private static final Set<String> TEST_UNIT_TEST_TASKS = Set.of("test", "tests", "test:functionals", "test:integration", "test:plugins", "test:recent", "test:uncommited", "test:units");
    @NonNls
    private static final String TEST_UNIT_TEST_TASKS_PREFIX = "test:";
    @NonNls
    private static final String TEST_UNIT_TEST_PREPARE_FULLCMD = "test:prepare";
    @NonNls
    private static final String RSPEC_TEST_TASKS_PREFIX = "spec:";
    @NonNls
    private static final Set<String> CUCUMBER_TEST_TASKS = Set.of("features", "cucumber", "cucumber:ok", "cucumber:all", "cucumber:wip");
    @NonNls
    private static final String CUCUMBER_TEST_TASKS_PREFIX = "cucumber:";
    @NonNls
    private static final String CUCUMBER_RERUN = "rerun";

    private RakeUtil() {
    }

    public static boolean rakeFileExists(@Nullable VirtualFile homeDir) {
        if (homeDir == null) {
            return false;
        }
        return RakeUtil.findRakeFile(homeDir) != null;
    }

    @Nullable
    public static RunnerAndConfigurationSettings findExistingRakeRunConfFor(@NotNull Module module, @NotNull String fullCommand) {
        if (module == null) {
            RakeUtil.$$$reportNull$$$0(0);
        }
        if (fullCommand == null) {
            RakeUtil.$$$reportNull$$$0(1);
        }
        return RakeUtil.findExistingRakeRunConfFor(module, RakeRunConfigurationFactory.getDefaultTaskConfigurationNameProducer(module, fullCommand));
    }

    @Nullable
    public static RunnerAndConfigurationSettings findExistingRakeRunConfFor(@NotNull Module module, @NotNull Supplier<String> nameProducer) {
        if (module == null) {
            RakeUtil.$$$reportNull$$$0(2);
        }
        if (nameProducer == null) {
            RakeUtil.$$$reportNull$$$0(3);
        }
        String expectedConfName = nameProducer.get();
        for (RunnerAndConfigurationSettings confSettings : RunManager.getInstance((Project)module.getProject()).getConfigurationSettingsList((ConfigurationType)RakeRunConfigurationType.getInstance())) {
            RakeRunConfiguration configuration = (RakeRunConfiguration)confSettings.getConfiguration();
            String configurationName = configuration.getName();
            if (!expectedConfName.equals(configurationName) || !module.equals(configuration.getModule())) continue;
            return confSettings;
        }
        return null;
    }

    public static void runRakeTask(@NotNull String fullCommand, @NotNull Module module, @Nullable RakeActionPanel rakeActionPanel) {
        if (fullCommand == null) {
            RakeUtil.$$$reportNull$$$0(4);
        }
        if (module == null) {
            RakeUtil.$$$reportNull$$$0(5);
        }
        RakeUtil.runRakeTask(fullCommand, module, rakeActionPanel, null, null, RakeRunConfigurationFactory.getDefaultTaskConfigurationNameProducer(module, fullCommand));
    }

    public static void runRakeTask(@NotNull String fullCommand, @NotNull Module module, @Nullable RakeActionPanel rakeActionPanel, @Nullable Consumer<? super RunnerAndConfigurationSettings> settingsMutator, @Nullable ProgramRunner.Callback executionCallback, @NotNull Supplier<String> runConfigurationNameProducer) {
        if (fullCommand == null) {
            RakeUtil.$$$reportNull$$$0(6);
        }
        if (module == null) {
            RakeUtil.$$$reportNull$$$0(7);
        }
        if (runConfigurationNameProducer == null) {
            RakeUtil.$$$reportNull$$$0(8);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        RunManager runManager = RunManager.getInstance((Project)module.getProject());
        RunnerAndConfigurationSettings confSettings = RakeUtil.findExistingRakeRunConfFor(module, runConfigurationNameProducer);
        if (confSettings != null) {
            RakeUtil.applyChangesFromRakePanel(rakeActionPanel, confSettings);
            if (settingsMutator != null) {
                settingsMutator.consume((Object)confSettings);
            }
            ApplicationManager.getApplication().runReadAction(() -> RunConfigurationUtil.executeConfiguration(runManager, confSettings, executionCallback));
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            RunnerAndConfigurationSettings settings = RakeRunConfigurationType.getInstance().getRakeFactory().createConfigurationSettings(module, fullCommand, ArrayUtilRt.EMPTY_STRING_ARRAY, Collections.emptyMap(), runConfigurationNameProducer);
            RakeUtil.applyChangesFromRakePanel(rakeActionPanel, settings);
            if (settingsMutator != null) {
                settingsMutator.consume((Object)settings);
            }
            runManager.setTemporaryConfiguration(settings);
            RunConfigurationUtil.executeConfiguration(runManager, settings, executionCallback);
        });
    }

    public static void applyChangesFromRakePanel(@Nullable RakeActionPanel rakeActionPanel, @NotNull RunnerAndConfigurationSettings confSettings) {
        if (confSettings == null) {
            RakeUtil.$$$reportNull$$$0(9);
        }
        if (rakeActionPanel != null) {
            rakeActionPanel.applyToConfiguration((AbstractRubyRunConfiguration)confSettings.getConfiguration());
        }
    }

    @Nullable
    public static VirtualFile getRakeHomeDir(@NotNull Module module) {
        if (module == null) {
            RakeUtil.$$$reportNull$$$0(10);
        }
        LOG.debug("Detecting rake home directory for ", new Object[]{module});
        if (RailsFacetUtil.hasRailsSupport(module)) {
            VirtualFile railsAppHome = RailsFacetUtil.getRailsAppHomeDir(module);
            LOG.debug("Using rails application home: ", new Object[]{railsAppHome});
            return railsAppHome;
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length == 0) {
            LOG.debug("No content roots");
            return null;
        }
        LOG.debug("Using first root: ", new Object[]{roots[0]});
        return roots[0];
    }

    @Nullable
    public static String getRakeGemExecutableScriptPath(@Nullable Module module, Sdk sdk) {
        String executable = RakeUtil.getRakeExecutable(module);
        return RubyGemExecutionContext.getScriptPath(sdk, module, "rake", executable);
    }

    @NotNull
    public static String getRakeExecutable(@Nullable Module module) {
        RailsApp app = RailsApp.fromModule(module);
        return app != null && app.isRails5App() ? "rails" : "rake";
    }

    @Nullable
    public static SupportedTestFramework taskRequiresTest(@NotNull String taskFullName) {
        if (taskFullName == null) {
            RakeUtil.$$$reportNull$$$0(11);
        }
        if (TEST_UNIT_TEST_TASKS.contains(taskFullName) || taskFullName.startsWith(TEST_UNIT_TEST_TASKS_PREFIX) && !TEST_UNIT_TEST_PREPARE_FULLCMD.equals(taskFullName)) {
            return SupportedTestFramework.TEST_UNIT;
        }
        if ("spec".equals(taskFullName) || taskFullName.startsWith(RSPEC_TEST_TASKS_PREFIX)) {
            return SupportedTestFramework.RSPEC;
        }
        if (CUCUMBER_TEST_TASKS.contains(taskFullName) || taskFullName.startsWith(CUCUMBER_TEST_TASKS_PREFIX) && !taskFullName.contains(CUCUMBER_RERUN)) {
            return SupportedTestFramework.CUCUMBER;
        }
        if (taskFullName.endsWith(":test") || taskFullName.endsWith(":tests")) {
            return SupportedTestFramework.TEST_UNIT;
        }
        return null;
    }

    public static boolean isRakeTaskCall(@NotNull RPossibleCall call) {
        if (call == null) {
            RakeUtil.$$$reportNull$$$0(12);
        }
        String name = call.getCommand();
        return "task".equals(name);
    }

    public static boolean isRakeNamespaceCall(@NotNull RPossibleCall call) {
        if (call == null) {
            RakeUtil.$$$reportNull$$$0(13);
        }
        String name = call.getCommand();
        return "namespace".equals(name);
    }

    public static boolean isRakeTaskName(@NotNull PsiElement element) {
        String taskName;
        if (element == null) {
            RakeUtil.$$$reportNull$$$0(14);
        }
        if (!(element instanceof LeafPsiElement)) {
            return false;
        }
        RCall rCall = RubyPsiUtil.getCoveringRCall(element);
        if (rCall == null || !RakeUtil.isRakeTaskCall((RPossibleCall)rCall)) {
            return false;
        }
        List args = rCall.getArguments();
        if (args.isEmpty()) {
            return false;
        }
        PsiElement firstArg = (PsiElement)args.get(0);
        PsiElement taskNameHolder = firstArg;
        if (taskNameHolder instanceof RAssoc) {
            if ((taskNameHolder = ((RAssoc)taskNameHolder).getKey()) == null) {
                return false;
            }
            if (((RAssoc)firstArg).isRuby19Assoc() && (taskNameHolder = taskNameHolder.getFirstChild()) == null) {
                return false;
            }
            taskName = RubyInterpretUtil.evaluateStringOrSymbolElement(taskNameHolder);
            if (taskName == null) {
                taskName = taskNameHolder.getText();
            }
        } else {
            taskName = RubyInterpretUtil.evaluateStringOrSymbolElement(taskNameHolder);
            if (taskName == null) {
                return false;
            }
        }
        return taskName.equals(element.getText()) && PsiTreeUtil.isAncestor((PsiElement)taskNameHolder, (PsiElement)element, (boolean)false);
    }

    @Nullable
    public static String getRakeTaskFullName(@NotNull PsiElement element) {
        if (element == null) {
            RakeUtil.$$$reportNull$$$0(15);
        }
        if (!RakeUtil.isRakeFileByNamingConventions(PsiUtilCore.getVirtualFile((PsiElement)element)) || !RakeUtil.isRakeTaskName(element)) {
            return null;
        }
        StringBuilder taskFullName = new StringBuilder(element.getText());
        RBlockCall rBlockCall = RubyPsiUtil.getContainingRBlockCall(element);
        while (rBlockCall != null) {
            RPossibleCall rCall = rBlockCall.getCall();
            if (!RakeUtil.isRakeNamespaceCall(rCall)) {
                return null;
            }
            List args = rCall.getArguments();
            if (args.isEmpty()) {
                return null;
            }
            String namespace = RubyInterpretUtil.evaluateStringOrSymbolElement((PsiElement)args.get(0));
            if (StringUtil.isEmpty((String)namespace)) {
                return null;
            }
            taskFullName.insert(0, ":").insert(0, namespace);
            rBlockCall = RubyPsiUtil.getContainingRBlockCall((PsiElement)rBlockCall);
        }
        return taskFullName.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullCommand";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameProducer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigurationNameProducer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confSettings";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskFullName";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/RakeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingRakeRunConfFor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "runRakeTask";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "applyChangesFromRakePanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getRakeHomeDir";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "taskRequiresTest";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isRakeTaskCall";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isRakeNamespaceCall";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "isRakeTaskName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getRakeTaskFullName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

