/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.rake;

import com.intellij.execution.ExecutionHelper;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;

public final class RakeNotificationService {
    private static final String NOTIFICATION_GROUP_ID = "Rake.ReloadTasks.Notification";

    private RakeNotificationService() {
    }

    public static void notify(@NotNull Project project, @NotNull List<? extends Exception> errors, @NotNull List<? extends Exception> warnings, @Nullable VirtualFile file) {
        if (project == null) {
            RakeNotificationService.$$$reportNull$$$0(0);
        }
        if (errors == null) {
            RakeNotificationService.$$$reportNull$$$0(1);
        }
        if (warnings == null) {
            RakeNotificationService.$$$reportNull$$$0(2);
        }
        if (project.isDisposed() || errors.isEmpty() && warnings.isEmpty()) {
            return;
        }
        RakeNotificationService.getNotifications(project).forEach(Notification::expire);
        new MyNotification(project, errors, warnings, file).notify(project);
    }

    @NotNull
    private static List<MyNotification> getNotifications(@NotNull Project project) {
        if (project == null) {
            RakeNotificationService.$$$reportNull$$$0(3);
        }
        List<MyNotification> list = List.of((MyNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(MyNotification.class, project));
        if (list == null) {
            RakeNotificationService.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warnings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/RakeNotificationService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/RakeNotificationService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNotifications";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static final class MyNotification
    extends Notification {
        private MyNotification(final @NotNull Project project, final @NotNull List<? extends Exception> errors, final @NotNull List<? extends Exception> warnings, final @Nullable VirtualFile file) {
            if (project == null) {
                MyNotification.$$$reportNull$$$0(0);
            }
            if (errors == null) {
                MyNotification.$$$reportNull$$$0(1);
            }
            if (warnings == null) {
                MyNotification.$$$reportNull$$$0(2);
            }
            super(RakeNotificationService.NOTIFICATION_GROUP_ID, "", MyNotification.buildContent(errors, warnings), NotificationType.WARNING);
            this.addAction((AnAction)new DumbAwareAction(MyNotification.buildActionTitle(errors, warnings)){

                public void actionPerformed(@NotNull AnActionEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ExecutionHelper.showExceptions((Project)project, (List)errors, (List)warnings, (String)RBundle.message((String)"execution.error.title.rake.tasks"), (VirtualFile)file);
                    this.hideBalloon();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/tasks/rake/RakeNotificationService$MyNotification$1", "actionPerformed"));
                }
            });
            if (AdvancedSettings.getBoolean((String)"rake.tasks.loading.enabled")) {
                this.addAction((AnAction)new DumbAwareAction(RBundle.message((String)"rake.reloadTasks.notification.action.disable.title")){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        AdvancedSettings.setBoolean((String)"rake.tasks.loading.enabled", (boolean)false);
                        this.expire();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/tasks/rake/RakeNotificationService$MyNotification$2", "actionPerformed"));
                    }
                });
            }
        }

        @NotNull
        @NlsActions.ActionText
        private static String buildActionTitle(@NotNull List<? extends Exception> errors, @NotNull List<? extends Exception> warnings) {
            if (errors == null) {
                MyNotification.$$$reportNull$$$0(3);
            }
            if (warnings == null) {
                MyNotification.$$$reportNull$$$0(4);
            }
            if (!errors.isEmpty() && !warnings.isEmpty()) {
                String string = RBundle.message((String)"rake.reloadTasks.notification.action.show.title.errors.and.warnings", (Object[])new Object[]{errors.size(), warnings.size()});
                if (string == null) {
                    MyNotification.$$$reportNull$$$0(5);
                }
                return string;
            }
            if (!errors.isEmpty()) {
                String string = RBundle.message((String)"rake.reloadTasks.notification.action.show.title.errors", (Object[])new Object[]{errors.size()});
                if (string == null) {
                    MyNotification.$$$reportNull$$$0(6);
                }
                return string;
            }
            if (!warnings.isEmpty()) {
                String string = RBundle.message((String)"rake.reloadTasks.notification.action.show.title.warnings", (Object[])new Object[]{warnings.size()});
                if (string == null) {
                    MyNotification.$$$reportNull$$$0(7);
                }
                return string;
            }
            throw new UnsupportedOperationException();
        }

        @NlsContexts.NotificationContent
        @NotNull
        private static String buildContent(@NotNull List<? extends Exception> errors, @NotNull List<? extends Exception> warnings) {
            if (errors == null) {
                MyNotification.$$$reportNull$$$0(8);
            }
            if (warnings == null) {
                MyNotification.$$$reportNull$$$0(9);
            }
            if (!errors.isEmpty() && !warnings.isEmpty()) {
                String string = RBundle.message((String)"rake.reloadTasks.notification.content.errors.and.warnings", (Object[])new Object[]{errors.size(), warnings.size()});
                if (string == null) {
                    MyNotification.$$$reportNull$$$0(10);
                }
                return string;
            }
            if (!errors.isEmpty()) {
                String string = RBundle.message((String)"rake.reloadTasks.notification.content.errors", (Object[])new Object[]{errors.size()});
                if (string == null) {
                    MyNotification.$$$reportNull$$$0(11);
                }
                return string;
            }
            if (!warnings.isEmpty()) {
                String string = RBundle.message((String)"rake.reloadTasks.notification.content.warnings", (Object[])new Object[]{warnings.size()});
                if (string == null) {
                    MyNotification.$$$reportNull$$$0(12);
                }
                return string;
            }
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 10, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errors";
                    break;
                }
                case 2: 
                case 4: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "warnings";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/rake/RakeNotificationService$MyNotification";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/rake/RakeNotificationService$MyNotification";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildActionTitle";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "buildActionTitle";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "buildContent";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7, 10, 11, 12 -> new IllegalStateException(string);
            };
        }
    }
}

