/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.capistrano.run.configuration;

import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.settings.SettingsExternalizer;
import org.jetbrains.plugins.ruby.tasks.capistrano.run.configuration.CapistranoRunConfiguration;

public class CapistranoRunConfigurationExternalizer
extends SettingsExternalizer {
    private static final CapistranoRunConfigurationExternalizer myInstance = new CapistranoRunConfigurationExternalizer();
    @NonNls
    public static final String ID = "CAPISTRANO_RUN_CONFIG_SETTINGS_ID";
    @NonNls
    public static final String TASK_NAME = "CAPISTRANO_TASK_NAME";
    @NonNls
    public static final String TASK_ARGS = "CAPISTRANO_TASK_ARGS";
    @NonNls
    public static final String TASK_STAGE = "CAPISTRANO_STAGE";

    @Override
    @NotNull
    public String getID() {
        return ID;
    }

    public static CapistranoRunConfigurationExternalizer getInstance() {
        return myInstance;
    }

    public void writeExternal(CapistranoRunConfiguration config, Element elem) {
        this.writeOption(TASK_NAME, config.getTaskName(), elem);
        this.writeOption(TASK_ARGS, config.getTaskArgs(), elem);
        this.writeOption(TASK_STAGE, config.getStage(), elem);
    }

    public void readExternal(CapistranoRunConfiguration config, Element elem) {
        Map<String, String> optionsByName = this.buildOptionsByElement(elem);
        config.setTaskName(optionsByName.get(TASK_NAME));
        config.setTaskArgs(optionsByName.get(TASK_ARGS));
        config.setStage(optionsByName.get(TASK_STAGE));
    }
}

