/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.capistrano.run.configuration;

import com.intellij.DynamicBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import icons.RubyIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommonRunParamsEditor;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUIUtil;
import org.jetbrains.plugins.ruby.tasks.capistrano.CapistranoTaskModuleCache;
import org.jetbrains.plugins.ruby.tasks.capistrano.run.configuration.CapistranoRunConfiguration;
import org.jetbrains.plugins.ruby.tasks.capistrano.run.configuration.CapistranoRunConfigurationParams;
import org.jetbrains.plugins.ruby.tasks.capistrano.task.CapistranoTask;
import org.jetbrains.plugins.ruby.tasks.rake.task.special.TaskUIUtil;

public class CapistranoRunConfigurationEditor
extends SettingsEditor<CapistranoRunConfiguration>
implements CapistranoRunConfigurationParams,
PanelWithAnchor {
    private JComponent myContentPane;
    private LabeledComponent<TextFieldWithAutoCompletion> myCapTaskNameComponent;
    private LabeledComponent<RawCommandLineEditor> myTaskArgumentsComponent;
    private TextFieldWithAutoCompletionListProvider<CapistranoTask> myCompletionProvider;
    private TextFieldWithAutoCompletion myCapTaskNameTextField;
    private JComboBox myCapistranoStagesCombobox;
    private RawCommandLineEditor myTaskArgumentsEditor;
    private JPanel myCommonOptionsPanel;
    private final RubyCommonRunParamsEditor myCommonEditor;
    private JComponent anchor;
    private JCheckBox myOptionTraceCB;
    private LabeledComponent myCapistranoStages;
    private final Project myProject;

    public CapistranoRunConfigurationEditor(Project project, CapistranoRunConfiguration runConfiguration) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCommonEditor = RunConfigurationUIUtil.createRubyCommonRunParamsEditor(runConfiguration, "capistrano", this.myCommonOptionsPanel);
        this.myCommonEditor.addModuleChangedListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CapistranoRunConfigurationEditor.this.onModuleChanged(CapistranoRunConfigurationEditor.this.myCommonEditor.getModule());
            }
        });
        this.myCapistranoStagesCombobox.setModel(new DefaultComboBoxModel<Object>(this.getStageItems()));
        this.setAnchor(this.myCommonEditor.getAnchor());
    }

    private Object[] getStageItems() {
        Module module = this.myCommonEditor.getModule();
        List<Object> stages = new ArrayList();
        if (module != null) {
            stages = TaskUIUtil.getStagesWithDefault(module);
        }
        return stages.toArray();
    }

    protected void resetEditorFrom(@NotNull CapistranoRunConfiguration config) {
        if (config == null) {
            CapistranoRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        CapistranoRunConfiguration.copyParams(config, this);
        this.myCommonEditor.resetEditorFrom(config);
    }

    protected void applyEditorTo(@NotNull CapistranoRunConfiguration config) throws ConfigurationException {
        if (config == null) {
            CapistranoRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        CapistranoRunConfiguration.copyParams(this, config);
        this.myCommonEditor.applyEditorTo(config);
    }

    @NotNull
    protected JComponent createEditor() {
        JComponent jComponent = this.myContentPane;
        if (jComponent == null) {
            CapistranoRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    private void createUIComponents() {
        Ref textFieldWithAutoCompletionRef = new Ref();
        Ref completionProviderRef = new Ref();
        this.myCapTaskNameComponent = CapistranoRunConfigurationEditor.createCapistranoTaskNamesComponent(this.myProject, (Ref<? super TextFieldWithAutoCompletion>)textFieldWithAutoCompletionRef, (Ref<? super TextFieldWithAutoCompletionListProvider<CapistranoTask>>)completionProviderRef);
        this.myCapTaskNameTextField = (TextFieldWithAutoCompletion)textFieldWithAutoCompletionRef.get();
        this.myTaskArgumentsComponent = this.createCapistranoTaskArgumentsComponent();
        this.myCapistranoStages = this.createCapistranoStagesComponent();
        this.myCompletionProvider = (TextFieldWithAutoCompletionListProvider)completionProviderRef.get();
    }

    public static LabeledComponent<TextFieldWithAutoCompletion> createCapistranoTaskNamesComponent(@NotNull Project project, @NotNull Ref<? super TextFieldWithAutoCompletion> textFieldRef, @NotNull Ref<? super TextFieldWithAutoCompletionListProvider<CapistranoTask>> completionProviderRef) {
        if (project == null) {
            CapistranoRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        if (textFieldRef == null) {
            CapistranoRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        if (completionProviderRef == null) {
            CapistranoRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        String text = RBundle.message((String)"run.configuration.capistrano.task.name");
        TextFieldWithAutoCompletionListProvider<CapistranoTask> provider = new TextFieldWithAutoCompletionListProvider<CapistranoTask>(null){

            protected Icon getIcon(@NotNull CapistranoTask item) {
                if (item == null) {
                    2.$$$reportNull$$$0(0);
                }
                return RubyIcons.Ruby.Ruby;
            }

            @NotNull
            protected String getLookupString(@NotNull CapistranoTask item) {
                if (item == null) {
                    2.$$$reportNull$$$0(1);
                }
                String string = item.getName();
                if (string == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string;
            }

            protected String getTypeText(@NotNull CapistranoTask item) {
                if (item == null) {
                    2.$$$reportNull$$$0(3);
                }
                return null;
            }

            public int compare(CapistranoTask item1, CapistranoTask item2) {
                return StringUtil.compare((String)item1.getName(), (String)item2.getName(), (boolean)false);
            }

            protected String getTailText(@NotNull CapistranoTask item) {
                if (item == null) {
                    2.$$$reportNull$$$0(4);
                }
                return " " + item.getDescription();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/capistrano/run/configuration/CapistranoRunConfigurationEditor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/capistrano/run/configuration/CapistranoRunConfigurationEditor$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLookupString";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getIcon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getLookupString";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getTypeText";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getTailText";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        completionProviderRef.set((Object)provider);
        TextFieldWithAutoCompletion textField = new TextFieldWithAutoCompletion(project, (TextFieldWithAutoCompletionListProvider)provider, true, null);
        textFieldRef.set((Object)textField);
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)textField);
        myComponent.setText(text);
        return myComponent;
    }

    private LabeledComponent<RawCommandLineEditor> createCapistranoTaskArgumentsComponent() {
        String text = RBundle.message((String)"run.configuration.capistrano.task.arguments");
        Ref argsEditorWrapper = new Ref();
        LabeledComponent<RawCommandLineEditor> myComponent = RunConfigurationUIUtil.createRawEditorComponent((Ref<? super RawCommandLineEditor>)argsEditorWrapper, text);
        this.myTaskArgumentsEditor = (RawCommandLineEditor)argsEditorWrapper.get();
        return myComponent;
    }

    private LabeledComponent createCapistranoStagesComponent() {
        this.myCapistranoStagesCombobox = new ComboBox();
        LabeledComponent myComponent = new LabeledComponent();
        myComponent.setComponent((JComponent)this.myCapistranoStagesCombobox);
        myComponent.setText(RBundle.message((String)"capistrano.configuration.stage"));
        return myComponent;
    }

    @Override
    public String getTaskName() {
        return this.myCapTaskNameTextField.getText().trim();
    }

    @Override
    public String getTaskArgs() {
        return this.myTaskArgumentsEditor.getText().trim();
    }

    @Override
    public String getStage() {
        return (String)this.myCapistranoStagesCombobox.getSelectedItem();
    }

    @Override
    public void setTaskName(@Nullable String name) {
        this.myCapTaskNameTextField.setText(StringUtil.notNullize((String)name));
    }

    @Override
    public void setTaskArgs(@Nullable String args) {
        this.myTaskArgumentsEditor.setText(StringUtil.notNullize((String)args));
    }

    @Override
    public void setStage(@Nullable String stage) {
        this.myCapistranoStagesCombobox.setSelectedItem(stage);
    }

    @Override
    public boolean isOptionTraceEnabled() {
        return this.myOptionTraceCB.isSelected();
    }

    @Override
    public void setOptionTrace(boolean enabled) {
        this.myOptionTraceCB.setSelected(enabled);
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myCapTaskNameComponent.setAnchor(anchor);
        this.myTaskArgumentsComponent.setAnchor(anchor);
        this.myCapistranoStages.setAnchor(anchor);
        this.myCommonEditor.setAnchor(anchor);
    }

    private void onModuleChanged(@Nullable Module module) {
        CapistranoRunConfigurationEditor.refreshTasks(module, this.myCompletionProvider);
    }

    public static void refreshTasks(Module module, TextFieldWithAutoCompletionListProvider<CapistranoTask> completionListProvider) {
        if (module != null) {
            Set<CapistranoTask> tasks;
            CapistranoTaskModuleCache capTaskModuleCache = CapistranoTaskModuleCache.getInstance(module);
            Set<CapistranoTask> set = tasks = capTaskModuleCache != null ? capTaskModuleCache.getTasks() : null;
            if (tasks != null) {
                completionListProvider.setItems(tasks);
                return;
            }
        }
        completionListProvider.setItems(null);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        JPanel jPanel2 = new JPanel();
        this.myContentPane = jPanel2;
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCommonOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        LabeledComponent<TextFieldWithAutoCompletion> labeledComponent = this.myCapTaskNameComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/RBundle", CapistranoRunConfigurationEditor.class).getString("run.configuration.rake.task.name"));
        jPanel2.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        LabeledComponent<RawCommandLineEditor> labeledComponent2 = this.myTaskArgumentsComponent;
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/RBundle", CapistranoRunConfigurationEditor.class).getString("run.configuration.rake.task.arguments"));
        jPanel2.add((Component)labeledComponent2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myOptionTraceCB = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", CapistranoRunConfigurationEditor.class).getString("run.configuration.rake.task.options.trace"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        LabeledComponent labeledComponent3 = this.myCapistranoStages;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/RBundle", CapistranoRunConfigurationEditor.class).getString("capistrano.run.configuration.editor.stages.field.text"));
        jPanel2.add((Component)labeledComponent3, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/capistrano/run/configuration/CapistranoRunConfigurationEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFieldRef";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionProviderRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/capistrano/run/configuration/CapistranoRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCapistranoTaskNamesComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

