/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.tasks.capistrano.actions;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsSafe;
import icons.RubyIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.statistic.RubyCapistranoCountCollector;
import org.jetbrains.plugins.ruby.tasks.capistrano.CapistranoTaskModuleCache;
import org.jetbrains.plugins.ruby.tasks.capistrano.CapistranoUtil;
import org.jetbrains.plugins.ruby.tasks.capistrano.actions.CapistranoSimpleActionPanel;
import org.jetbrains.plugins.ruby.tasks.capistrano.actions.CapistranoStagedActionPanel;
import org.jetbrains.plugins.ruby.tasks.capistrano.task.CapistranoTask;
import org.jetbrains.plugins.ruby.tasks.rake.task.RakeActionPanel;
import org.jetbrains.plugins.ruby.tasks.rake.task.RakeDialogs;

public class CapistranoAction
extends AnAction
implements DumbAware {
    @NlsSafe
    private final String myTaskName;
    private final CapistranoTask myTask;

    public CapistranoAction(@NotNull CapistranoTask task) {
        if (task == null) {
            CapistranoAction.$$$reportNull$$$0(0);
        }
        super(task.getName(), null, RubyIcons.Ruby.Ruby);
        this.myTaskName = task.getName();
        this.myTask = task;
    }

    public CapistranoTask getTask() {
        return this.myTask;
    }

    @NlsSafe
    public String getCommand() {
        return this.myTaskName;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Module module;
        if (e == null) {
            CapistranoAction.$$$reportNull$$$0(1);
        }
        if ((module = RModuleUtil.getInstance().getModule(e.getDataContext())) == null) {
            return;
        }
        this.runCapistranoTask(module);
    }

    public void runCapistranoTask(@NotNull Module module) {
        RunnerAndConfigurationSettings settings;
        if (module == null) {
            CapistranoAction.$$$reportNull$$$0(2);
        }
        RakeActionPanel panel2 = CapistranoUtil.getStages(module).isEmpty() ? new CapistranoSimpleActionPanel(this.myTask) : new CapistranoStagedActionPanel(this.myTask, module);
        String title = RModuleUtil.getInstance().isInMultiProject(module) ? RBundle.message((String)"capistrano.action.execute.task.dialog.title.ex", (Object[])new Object[]{this.myTaskName, module.getName()}) : RBundle.message((String)"capistrano.action.execute.task.dialog.title", (Object[])new Object[]{this.myTaskName});
        if (RakeDialogs.showDialog(module, title, panel2, settings = CapistranoUtil.findRunConfiguration(module, this.myTaskName)) == 0) {
            RubyCapistranoCountCollector.logRunTaskFromToolPopup(this.myTaskName);
            CapistranoUtil.runCapistranoTask(this.myTaskName, module, panel2);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CapistranoAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        boolean isEnabled;
        if (e == null) {
            CapistranoAction.$$$reportNull$$$0(4);
        }
        DataContext dataContext = e.getDataContext();
        Module module = RModuleUtil.getInstance().getModule(dataContext);
        boolean bl = isEnabled = CapistranoUtil.isCapistranoEnabled(module) && CapistranoUtil.getCapFile(module) == null;
        if (isEnabled) {
            CapistranoTaskModuleCache.getInstance(module);
        }
        e.getPresentation().setEnabled(isEnabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/tasks/capistrano/actions/CapistranoAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/tasks/capistrano/actions/CapistranoAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runCapistranoTask";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

