/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.statistic;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.impl.DebugUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyTrackedCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.PsiReferenceWithCompletion;

public final class RubyTrackedCompletionProviderStatCollector
extends CounterUsagesCollector {
    private static final Logger LOG = Logger.getInstance(RubyTrackedCompletionProviderStatCollector.class);
    private static final EventLogGroup RUBY_COMPLETION_PROVIDER_GROUP = new EventLogGroup("ruby.completion.provider", 1);
    private static final EnumEventField<CompletionProviderType> PROVIDER_TYPE = EventFields.Enum((String)"type", CompletionProviderType.class);
    private static final PrimitiveEventField<Language> LANGUAGE = EventFields.Language;
    private static final ClassEventField PROVIDER_CLASS = EventFields.Class((String)"class");
    private static final LongEventField COMPLETION_DURATION_MS = EventFields.DurationMs;
    private static final VarargEventId PROVIDER_FINISHED = RUBY_COMPLETION_PROVIDER_GROUP.registerVarargEvent("finished", new EventField[]{LANGUAGE, PROVIDER_TYPE, PROVIDER_CLASS, COMPLETION_DURATION_MS});

    public EventLogGroup getGroup() {
        return RUBY_COMPLETION_PROVIDER_GROUP;
    }

    public static void logProviderFinished(@NotNull Language lang, @NotNull RubyTrackedCompletionProvider provider, long startTimeMs) {
        if (lang == null) {
            RubyTrackedCompletionProviderStatCollector.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            RubyTrackedCompletionProviderStatCollector.$$$reportNull$$$0(1);
        }
        RubyTrackedCompletionProviderStatCollector.logFinished(lang, CompletionProviderType.COMPLETION_PROVIDER, ((Object)((Object)provider)).getClass(), System.currentTimeMillis() - startTimeMs);
    }

    public static void logReferenceWithCompletionFinished(@NotNull Language lang, @NotNull PsiReferenceWithCompletion reference, long startTimeMs) {
        if (lang == null) {
            RubyTrackedCompletionProviderStatCollector.$$$reportNull$$$0(2);
        }
        if (reference == null) {
            RubyTrackedCompletionProviderStatCollector.$$$reportNull$$$0(3);
        }
        RubyTrackedCompletionProviderStatCollector.logFinished(lang, CompletionProviderType.REFERENCE_WITH_COMPLETION, reference.getClass(), System.currentTimeMillis() - startTimeMs);
    }

    private static void logFinished(@NotNull Language lang, @NotNull CompletionProviderType providerType, @NotNull Class<?> providerClass, long completionDuration) {
        if (lang == null) {
            RubyTrackedCompletionProviderStatCollector.$$$reportNull$$$0(4);
        }
        if (providerType == null) {
            RubyTrackedCompletionProviderStatCollector.$$$reportNull$$$0(5);
        }
        if (providerClass == null) {
            RubyTrackedCompletionProviderStatCollector.$$$reportNull$$$0(6);
        }
        if (providerClass.isAnonymousClass()) {
            LOG.error("Cannot track completion provider/reference instantiated from an anonymous class. Please de-anonymize its class or remove it from tracking. Current stack trace: " + DebugUtil.currentStackTrace());
        } else {
            PROVIDER_FINISHED.log(List.of(LANGUAGE.with((Object)lang), PROVIDER_TYPE.with((Object)providerType), PROVIDER_CLASS.with(providerClass), COMPLETION_DURATION_MS.with((Object)completionDuration)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerClass";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/statistic/RubyTrackedCompletionProviderStatCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "logProviderFinished";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "logReferenceWithCompletionFinished";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "logFinished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static enum CompletionProviderType {
        COMPLETION_PROVIDER,
        REFERENCE_WITH_COMPLETION;

    }
}

