/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.statistic;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.remote.CredentialsType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurator;
import org.jetbrains.plugins.ruby.statistic.HostOS;
import org.jetbrains.plugins.ruby.statistic.MemoryInfo;
import org.jetbrains.plugins.ruby.statistic.RubySdkUsageCollector;
import org.jetbrains.plugins.ruby.statistic.RubySdkUsageCollectorKt;
import org.jetbrains.plugins.ruby.statistic.TriState;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0016\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\"\u0010\u001e\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015H\u0002\u001a\u001f\u0010$\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010%\u001a\u0018\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "VERSION_MANAGER", "Lcom/intellij/internal/statistic/eventLog/events/ClassEventField;", "RUBY_TYPE", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "HOST_OS", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lorg/jetbrains/plugins/ruby/statistic/HostOS;", "REMOTE_TYPE", "IS_LOCALHOST", "Lorg/jetbrains/plugins/ruby/statistic/TriState;", "REMOTE_AVAILABLE_RAM", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "REMOTE_TOTAL_RAM", "REMOTE_CPU_COUNT", "RUBY_SDK", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "KIBIBYTES_IN_GIBIBYTE", "", "computeVersionString", "", "rbConfig", "Lorg/jetbrains/plugins/ruby/ruby/sdk/RbConfig;", "computeHostOs", "computeRemoteCredentialsType", "Lcom/intellij/remote/CredentialsType;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "computeIsLocalhost", "readFileInRemote", "project", "Lcom/intellij/openapi/project/Project;", "runner", "Lorg/jetbrains/plugins/ruby/ruby/run/RubyRunner;", "filePath", "getCPUCoreCount", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/ruby/ruby/run/RubyRunner;)Ljava/lang/Integer;", "getMemoryInfo", "Lorg/jetbrains/plugins/ruby/statistic/MemoryInfo;", "intellij.ruby.backend"})
@SourceDebugExtension(value={"SMAP\nRubySdkUsageCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubySdkUsageCollector.kt\norg/jetbrains/plugins/ruby/statistic/RubySdkUsageCollectorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,225:1\n1#2:226\n14#3:227\n14#3:228\n1788#4,4:229\n1563#4:233\n1634#4,3:234\n*S KotlinDebug\n*F\n+ 1 RubySdkUsageCollector.kt\norg/jetbrains/plugins/ruby/statistic/RubySdkUsageCollectorKt\n*L\n131#1:227\n139#1:228\n151#1:229,4\n163#1:233\n163#1:234,3\n*E\n"})
public final class RubySdkUsageCollectorKt {
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("ruby.sdk.version", 9, null, 4, null);
    @NotNull
    private static final ClassEventField VERSION_MANAGER = EventFields.Class((String)"version_manager");
    @NotNull
    private static final StringEventField RUBY_TYPE;
    @NotNull
    private static final EnumEventField<HostOS> HOST_OS;
    @NotNull
    private static final ClassEventField REMOTE_TYPE;
    @NotNull
    private static final EnumEventField<TriState> IS_LOCALHOST;
    @NotNull
    private static final IntEventField REMOTE_AVAILABLE_RAM;
    @NotNull
    private static final IntEventField REMOTE_TOTAL_RAM;
    @NotNull
    private static final IntEventField REMOTE_CPU_COUNT;
    @NotNull
    private static final VarargEventId RUBY_SDK;
    private static final int KIBIBYTES_IN_GIBIBYTE = 0x100000;

    private static final String computeVersionString(RbConfig rbConfig) {
        String string = rbConfig.get("MAJOR");
        if (string == null) {
            return null;
        }
        Object version = string;
        String string2 = rbConfig.get("MINOR");
        if (string2 == null) {
            return version;
        }
        String minor = string2;
        version = (String)version + "." + minor;
        String string3 = rbConfig.get("TEENY");
        if (string3 == null) {
            return version;
        }
        String teeny = string3;
        return (String)version + "." + teeny;
    }

    private static final HostOS computeHostOs(RbConfig rbConfig) {
        HostOS hostOS;
        Object v1;
        block3: {
            String string = rbConfig.get("host_os");
            if (string == null) {
                return HostOS.UNKNOWN;
            }
            String hostOs = string;
            Iterable iterable = (Iterable)HostOS.getEntries();
            for (Object t : iterable) {
                HostOS it = (HostOS)((Object)t);
                boolean bl = false;
                if (!it.getPattern().containsMatchIn((CharSequence)hostOs)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        if ((hostOS = (HostOS)v1) == null) {
            hostOS = HostOS.UNKNOWN;
        }
        return hostOS;
    }

    private static final CredentialsType<?> computeRemoteCredentialsType(Sdk sdk) {
        RubySdkAdditionalData sdkAdditionalData = RubySdkAdditionalData.from(sdk);
        if (sdkAdditionalData instanceof RubyRemoteSdkAdditionalData) {
            return ((RubyRemoteSdkAdditionalData)sdkAdditionalData).getRemoteConnectionType();
        }
        return null;
    }

    private static final TriState computeIsLocalhost(Sdk sdk) {
        TriState triState;
        RubySdkAdditionalData rubySdkAdditionalData = RubySdkAdditionalData.notNullFrom(sdk);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)rubySdkAdditionalData), (String)"notNullFrom(...)");
        RubySdkAdditionalData sdkAdditionalData = rubySdkAdditionalData;
        String string = RubySdkConfigurator.from(sdkAdditionalData).getHost((SdkAdditionalData)sdkAdditionalData);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        String host = string;
        try {
            triState = TriState.Companion.fromBoolean(InetAddress.getByName(host).isLoopbackAddress());
        }
        catch (UnknownHostException unknownHostException) {
            triState = TriState.MISSING;
        }
        return triState;
    }

    private static final String readFileInRemote(Project project, RubyRunner runner, String filePath) {
        ProcessOutput output2;
        ProcessOutput processOutput;
        try {
            processOutput = (ProcessOutput)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ProcessOutput>, Object>(project, runner, filePath, null){
                int label;
                final /* synthetic */ Project $project;
                final /* synthetic */ RubyRunner $runner;
                final /* synthetic */ String $filePath;
                {
                    this.$project = $project;
                    this.$runner = $runner;
                    this.$filePath = $filePath;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            String string = RBundle.message((String)"progress.title.reading.file.from.remote.host");
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            this.label = 1;
                            Object object2 = TasksKt.withBackgroundProgress((Project)this.$project, (String)string, (TaskCancellation)((TaskCancellation)TaskCancellation.Companion.cancellable()), null, (boolean)false, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ProcessOutput>, Object>(this.$runner, this.$filePath, null){
                                int label;
                                final /* synthetic */ RubyRunner $runner;
                                final /* synthetic */ String $filePath;
                                {
                                    this.$runner = $runner;
                                    this.$filePath = $filePath;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ProcessOutput>, Object>(this.$runner, this.$filePath, null){
                                                int label;
                                                final /* synthetic */ RubyRunner $runner;
                                                final /* synthetic */ String $filePath;
                                                {
                                                    this.$runner = $runner;
                                                    this.$filePath = $filePath;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * Enabled force condition propagation
                                                 * Lifted jumps to return sites
                                                 */
                                                public final Object invokeSuspend(Object $result) {
                                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            this.label = 1;
                                                            Object object2 = CoroutinesKt.coroutineToIndicator(arg_0 -> readFileInRemote.output.1.invokeSuspend$lambda$0(this.$runner, this.$filePath, arg_0), (Continuation)((Continuation)this));
                                                            if (object2 != object) return object2;
                                                            return object;
                                                        }
                                                        case 1: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            Object object2 = $result;
                                                            return object2;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super ProcessOutput> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }

                                                private static final ProcessOutput invokeSuspend$lambda$0(RubyRunner $runner, String $filePath, ProgressIndicator it) {
                                                    String[] stringArray = new String[]{"cat", $filePath};
                                                    return $runner.execute(RubyRunnerExecutionContext.create(stringArray));
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super ProcessOutput> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super ProcessOutput> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        catch (ExecutionException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RubySdkUsageCollector.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error reading file " + filePath + " in remote: " + e);
            return null;
        }
        catch (ProcessCanceledException processCanceledException) {
            return null;
        }
        ProcessOutput processOutput2 = output2 = processOutput;
        if (!(processOutput2 != null ? processOutput2.getExitCode() == 0 : false)) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RubySdkUsageCollector.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error reading file " + filePath + " in remote: " + output2);
            return null;
        }
        return output2.getStdout();
    }

    private static final Integer getCPUCoreCount(Project project, RubyRunner runner) {
        int n;
        String string = RubySdkUsageCollectorKt.readFileInRemote(project, runner, "/proc/cpuinfo");
        if (string == null) {
            return null;
        }
        String cpuInfo = string;
        Iterable $this$count$iv = StringsKt.lines((CharSequence)cpuInfo);
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)"processor", (boolean)false, (int)2, null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static final MemoryInfo getMemoryInfo(Project project, RubyRunner runner) {
        void $this$mapTo$iv$iv;
        String string = RubySdkUsageCollectorKt.readFileInRemote(project, runner, "/proc/meminfo");
        if (string == null) {
            return MemoryInfo.Companion.getEMPTY();
        }
        String stdout = string;
        Integer total = null;
        Integer available = null;
        Iterable $this$map$iv = StringsKt.lines((CharSequence)stdout);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trimStart((CharSequence)((CharSequence)it))).toString());
        }
        List lines = (List)destination$iv$iv;
        for (String line : lines) {
            String value;
            String[] stringArray;
            if (StringsKt.startsWith$default((String)line, (String)"MemTotal:", (boolean)false, (int)2, null)) {
                stringArray = new String[]{":"};
                value = ((Object)StringsKt.trimStart((CharSequence)((String)StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1)))).toString();
                stringArray = new String[]{" "};
                total = StringsKt.toIntOrNull((String)((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null))));
                continue;
            }
            if (!StringsKt.startsWith$default((String)line, (String)"MemAvailable:", (boolean)false, (int)2, null)) continue;
            stringArray = new String[]{":"};
            value = ((Object)StringsKt.trimStart((CharSequence)((String)StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1)))).toString();
            stringArray = new String[]{" "};
            available = StringsKt.toIntOrNull((String)((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null))));
        }
        return new MemoryInfo(total, available);
    }

    public static final /* synthetic */ EventLogGroup access$getGROUP$p() {
        return GROUP;
    }

    public static final /* synthetic */ CredentialsType access$computeRemoteCredentialsType(Sdk sdk) {
        return RubySdkUsageCollectorKt.computeRemoteCredentialsType(sdk);
    }

    public static final /* synthetic */ String access$computeVersionString(RbConfig rbConfig) {
        return RubySdkUsageCollectorKt.computeVersionString(rbConfig);
    }

    public static final /* synthetic */ StringEventField access$getRUBY_TYPE$p() {
        return RUBY_TYPE;
    }

    public static final /* synthetic */ EnumEventField access$getHOST_OS$p() {
        return HOST_OS;
    }

    public static final /* synthetic */ HostOS access$computeHostOs(RbConfig rbConfig) {
        return RubySdkUsageCollectorKt.computeHostOs(rbConfig);
    }

    public static final /* synthetic */ ClassEventField access$getVERSION_MANAGER$p() {
        return VERSION_MANAGER;
    }

    public static final /* synthetic */ ClassEventField access$getREMOTE_TYPE$p() {
        return REMOTE_TYPE;
    }

    public static final /* synthetic */ EnumEventField access$getIS_LOCALHOST$p() {
        return IS_LOCALHOST;
    }

    public static final /* synthetic */ TriState access$computeIsLocalhost(Sdk sdk) {
        return RubySdkUsageCollectorKt.computeIsLocalhost(sdk);
    }

    public static final /* synthetic */ MemoryInfo access$getMemoryInfo(Project project, RubyRunner runner) {
        return RubySdkUsageCollectorKt.getMemoryInfo(project, runner);
    }

    public static final /* synthetic */ Integer access$getCPUCoreCount(Project project, RubyRunner runner) {
        return RubySdkUsageCollectorKt.getCPUCoreCount(project, runner);
    }

    public static final /* synthetic */ VarargEventId access$getRUBY_SDK$p() {
        return RUBY_SDK;
    }

    public static final /* synthetic */ IntEventField access$getREMOTE_AVAILABLE_RAM$p() {
        return REMOTE_AVAILABLE_RAM;
    }

    public static final /* synthetic */ IntEventField access$getREMOTE_TOTAL_RAM$p() {
        return REMOTE_TOTAL_RAM;
    }

    public static final /* synthetic */ IntEventField access$getREMOTE_CPU_COUNT$p() {
        return REMOTE_CPU_COUNT;
    }

    static {
        Object[] objectArray = new String[]{"jruby", "ruby", "rbx", "truffleruby", "Missing"};
        RUBY_TYPE = EventFields.String((String)"ruby_type", (List)CollectionsKt.listOf((Object[])objectArray));
        HOST_OS = EventFields.Enum$default((String)"host_os", HostOS.class, null, (int)4, null);
        REMOTE_TYPE = EventFields.Class((String)"remote_type");
        IS_LOCALHOST = EventFields.Enum$default((String)"is_localhost", TriState.class, null, (int)4, null);
        REMOTE_AVAILABLE_RAM = EventFields.Int((String)"remote_available_ram", (String)"Amount of available RAM in gibibytes");
        REMOTE_TOTAL_RAM = EventFields.Int((String)"remote_total_ram", (String)"Amount of total RAM in gibibytes");
        REMOTE_CPU_COUNT = EventFields.Int((String)"remote_cpu_count", (String)"Amount of CPU cores");
        objectArray = new EventField[]{EventFields.Version, VERSION_MANAGER, RUBY_TYPE, HOST_OS, REMOTE_TYPE, IS_LOCALHOST, REMOTE_AVAILABLE_RAM, REMOTE_TOTAL_RAM, REMOTE_CPU_COUNT};
        RUBY_SDK = GROUP.registerVarargEvent("ruby_sdk", (EventField[])objectArray);
    }
}

