/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.statistic;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.openapi.module.Module;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.statistic.ModuleUsagesCollector;

public final class RubyProjectTypeUsageCollector
extends ModuleUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("ruby.project.type", 4);
    private static final StringEventField TYPE = EventFields.String((String)"type", List.of("rails", "plain_ruby", "gem", "motion"));
    private static final VarargEventId RUBY_SDK = GROUP.registerVarargEvent("project.type", new EventField[]{TYPE, EventFields.Version});

    @Override
    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Module module) {
        RailsApp app;
        if (module == null) {
            RubyProjectTypeUsageCollector.$$$reportNull$$$0(0);
        }
        if ((app = RailsApp.fromModule(module)) != null) {
            GemInfo gem = RubyProjectGemSearchService.Companion.findGem(module, "rails");
            String railsVersion = gem != null ? RubyProjectTypeUsageCollector.getShortRailsVersion(gem.getNullableVersion()) : null;
            Set<MetricEvent> set = Collections.singleton(RUBY_SDK.metric(new EventPair[]{TYPE.with((Object)"rails"), EventFields.Version.with((Object)railsVersion)}));
            if (set == null) {
                RubyProjectTypeUsageCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        Set<MetricEvent> set = Collections.singleton(RUBY_SDK.metric(new EventPair[]{TYPE.with((Object)(RubyProjectTypeUsageCollector.isGemModule(module) ? "gem" : "plain ruby"))}));
        if (set == null) {
            RubyProjectTypeUsageCollector.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static boolean isGemModule(Module module) {
        return GemUtil.isGemModule(module);
    }

    private static String getShortRailsVersion(String realVersion) {
        if (realVersion == null) {
            return "edge";
        }
        String[] split = realVersion.split("\\.");
        return split.length > 2 ? split[0] + "." + split[1] : realVersion;
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/statistic/RubyProjectTypeUsageCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/statistic/RubyProjectTypeUsageCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

