/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.statistic;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupResultDescriptor;
import com.intellij.codeInsight.lookup.impl.LookupUsageDescriptor;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsageCollectorExtension;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.statistic.RubyLookupUsageLocation;

public final class RubyLookupUsageLocationDescriptor
implements LookupUsageDescriptor {
    @NonNls
    static final String DESCRIPTOR_NAME = "ruby_lookup_usage_location";
    private static final Key<RubyLookupUsageLocation> DESCRIPTOR_KEY = new Key("ruby_lookup_usage_location");

    @NotNull
    public String getExtensionKey() {
        return DESCRIPTOR_NAME;
    }

    public List<EventPair<?>> getAdditionalUsageData(@NotNull LookupResultDescriptor lookupResultDescriptor) {
        Lookup lookup;
        RubyLookupUsageLocation location;
        if (lookupResultDescriptor == null) {
            RubyLookupUsageLocationDescriptor.$$$reportNull$$$0(0);
        }
        if ((location = RubyLookupUsageLocationDescriptor.getLocationFromFile((PsiFile)ObjectUtils.doIfCast((Object)(lookup = lookupResultDescriptor.getLookup()), LookupImpl.class, Lookup::getPsiFile))) != null) {
            return Collections.singletonList(RubyCompletionCollectorExtension.LOOKUP_USAGE_LOCATION.with((Object)location));
        }
        return Collections.emptyList();
    }

    public static void markFile(@NotNull PsiFile psiFile, @NotNull RubyLookupUsageLocation location) {
        if (psiFile == null) {
            RubyLookupUsageLocationDescriptor.$$$reportNull$$$0(1);
        }
        if (location == null) {
            RubyLookupUsageLocationDescriptor.$$$reportNull$$$0(2);
        }
        psiFile.putUserData(DESCRIPTOR_KEY, (Object)location);
    }

    @Nullable
    public static RubyLookupUsageLocation getLocationFromFile(@Nullable PsiFile psiFile) {
        if (psiFile == null || psiFile.getLanguage() != RubyLanguage.INSTANCE) {
            return null;
        }
        RubyLookupUsageLocation result = (RubyLookupUsageLocation)((Object)psiFile.getUserData(DESCRIPTOR_KEY));
        return result == null ? RubyLookupUsageLocation.COMMON : result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupResultDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/statistic/RubyLookupUsageLocationDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAdditionalUsageData";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "markFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class RubyCompletionCollectorExtension
    implements FeatureUsageCollectorExtension {
        static final EnumEventField<RubyLookupUsageLocation> LOOKUP_USAGE_LOCATION = EventFields.Enum((String)"ruby_lookup_usage_location", RubyLookupUsageLocation.class);

        RubyCompletionCollectorExtension() {
        }

        public String getGroupId() {
            return "completion";
        }

        public String getEventId() {
            return "finished";
        }

        public List<EventField> getExtensionFields() {
            return Collections.singletonList(LOOKUP_USAGE_LOCATION);
        }
    }
}

