/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.statistic;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.debugger.renderers.RubyNodeTypeRendererData;
import org.jetbrains.plugins.ruby.ruby.debugger.renderers.RubyTypeRenderersSettings;

public final class RubyDebuggerTypeRenderersProjectCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("ruby.settings.debugger.type.renderers", 1);
    private static final EventId1<Integer> EXISTING_TYPE_RENDERERS = GROUP.registerEvent("existing.type.renderers", (EventField)EventFields.Int((String)"numberExistingTypeRenderers"));
    private static final EventId1<Integer> ENABLED_TYPE_RENDERERS = GROUP.registerEvent("enabled.type.renderers", (EventField)EventFields.Int((String)"numberEnabledTypeRenderers"));
    private static final EventId1<Integer> DISABLED_TYPE_RENDERERS = GROUP.registerEvent("disabled.type.renderers", (EventField)EventFields.Int((String)"numberDisabledTypeRenderers"));

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            RubyDebuggerTypeRenderersProjectCollector.$$$reportNull$$$0(0);
        }
        List<RubyNodeTypeRendererData> typeRenderers = RubyTypeRenderersSettings.getInstance().getRenderers();
        int numberOfExistingTypeRenderers = typeRenderers.size();
        int numberOfEnabledTypeRenderers = typeRenderers.stream().filter(renderer -> renderer.isEnabled()).toList().size();
        int numberOfDisabledTypeRenderers = typeRenderers.stream().filter(renderer -> !renderer.isEnabled()).toList().size();
        Set<MetricEvent> set = Set.of(EXISTING_TYPE_RENDERERS.metric((Object)numberOfExistingTypeRenderers), ENABLED_TYPE_RENDERERS.metric((Object)numberOfEnabledTypeRenderers), DISABLED_TYPE_RENDERERS.metric((Object)numberOfDisabledTypeRenderers));
        if (set == null) {
            RubyDebuggerTypeRenderersProjectCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    protected boolean requiresReadAccess() {
        return true;
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/statistic/RubyDebuggerTypeRenderersProjectCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/statistic/RubyDebuggerTypeRenderersProjectCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

