/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.spellchecker;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.spellchecker.inspections.WordSplitter;
import com.intellij.util.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class StringWithEscapingSplitter
extends TextSplitter {
    private static final NotNullLazyValue<StringWithEscapingSplitter> ourInstance = NotNullLazyValue.lazy(() -> new StringWithEscapingSplitter());
    private static final Pattern EXTENDED_WORD_AND_SPECIAL = Pattern.compile("([&#]|0x[0-9]*)?\\p{L}+'?\\p{L}(_*\\p{L})*");

    protected void doSplit(@NotNull String text, @NotNull TextRange range, Consumer<TextRange> consumer) {
        if (text == null) {
            StringWithEscapingSplitter.$$$reportNull$$$0(0);
        }
        if (range == null) {
            StringWithEscapingSplitter.$$$reportNull$$$0(1);
        }
        WordSplitter ws = WordSplitter.getInstance();
        Matcher matcher = EXTENDED_WORD_AND_SPECIAL.matcher(range.substring(text));
        while (matcher.find()) {
            int start = matcher.start();
            if (start > 0 && text.charAt(start - 1) == '\\' && (start == 1 || text.charAt(start - 2) != '\\')) {
                ++start;
            }
            TextRange found = BaseSplitter.subRange((TextRange)range, (int)start, (int)matcher.end());
            ws.split(text, found, consumer);
        }
    }

    public static StringWithEscapingSplitter getInstance() {
        return (StringWithEscapingSplitter)((Object)ourInstance.getValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "range";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/spellchecker/StringWithEscapingSplitter";
        objectArray[2] = "doSplit";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

