/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.spellchecker;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.spellchecker.RubySpellCheckerDictionaryGenerator;

public class RubySpellCheckerGenerateDictionariesAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RubySpellCheckerGenerateDictionariesAction.$$$reportNull$$$0(0);
        }
        Module module = RModuleUtil.getInstance().getModule(e.getDataContext());
        assert (module != null);
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        assert (sdk != null);
        RubySpellCheckerDictionaryGenerator generator = new RubySpellCheckerDictionaryGenerator(module.getProject(), RModuleUtil.getInstance().getFirstContentRoot(module).getPath() + "/dicts");
        for (VirtualFile file : RubySdkUtil.getSdkRoots(sdk)) {
            generator.addFolder("ruby", file);
        }
        for (GemInfo gemInfo : RubyProjectGemSearchService.Companion.getAllGems(module)) {
            generator.addFolder(gemInfo.getName(), gemInfo.getLibFolder());
        }
        generator.generate();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RubySpellCheckerGenerateDictionariesAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RubySpellCheckerGenerateDictionariesAction.$$$reportNull$$$0(2);
        }
        Module module = RModuleUtil.getInstance().getModule(e.getDataContext());
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        Presentation presentation = e.getPresentation();
        boolean isEnabled = module != null && sdk != null;
        presentation.setEnabled(isEnabled);
        presentation.setVisible(isEnabled || PlatformUtils.isRubyMine());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/spellchecker/RubySpellCheckerGenerateDictionariesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/spellchecker/RubySpellCheckerGenerateDictionariesAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

