/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.spellchecker;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RubyIdentifierSplitter
extends IdentifierSplitter {
    private static final NotNullLazyValue<RubyIdentifierSplitter> ourInstance = NotNullLazyValue.lazy(() -> new RubyIdentifierSplitter());

    public void split(@Nullable String text, @NotNull TextRange range, @NotNull Consumer<TextRange> consumer) {
        if (range == null) {
            RubyIdentifierSplitter.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            RubyIdentifierSplitter.$$$reportNull$$$0(1);
        }
        if (text == null) {
            return;
        }
        String textInRange = range.substring(text);
        int start = 0;
        int end = textInRange.length();
        if (textInRange.startsWith("@@")) {
            start = "@@".length();
        } else if (textInRange.startsWith("@")) {
            start = "@".length();
        }
        if (textInRange.endsWith("?") || textInRange.endsWith("!") || textInRange.endsWith("=")) {
            --end;
        }
        super.split(text, new TextRange(start + range.getStartOffset(), end + range.getStartOffset()), consumer);
    }

    public static RubyIdentifierSplitter getInstance() {
        return (RubyIdentifierSplitter)((Object)ourInstance.getValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "range";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/spellchecker/RubyIdentifierSplitter";
        objectArray[2] = "split";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

