/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.settings;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SettingsExternalizer {
    @NonNls
    public static final String NAME = "NAME";
    @NonNls
    public static final String VALUE = "VALUE";
    @NonNls
    public static final String SETTINGS_VERSION_KEY = "SETTINGS_VERSION";

    @NotNull
    public abstract String getID();

    protected void writeCurrentVersion(@NotNull Element elem, @NotNull String currentSettingsVersion) {
        if (elem == null) {
            SettingsExternalizer.$$$reportNull$$$0(0);
        }
        if (currentSettingsVersion == null) {
            SettingsExternalizer.$$$reportNull$$$0(1);
        }
        this.writeOption(SETTINGS_VERSION_KEY, currentSettingsVersion, elem);
    }

    protected static Map<String, String> buildOptionsByElement(@NotNull Element elem, @NotNull String serializationId) {
        if (elem == null) {
            SettingsExternalizer.$$$reportNull$$$0(2);
        }
        if (serializationId == null) {
            SettingsExternalizer.$$$reportNull$$$0(3);
        }
        return SettingsExternalizer.buildOptionsByName(elem.getChildren(serializationId));
    }

    protected Map<String, String> buildOptionsByElement(@NotNull Element elem) {
        if (elem == null) {
            SettingsExternalizer.$$$reportNull$$$0(4);
        }
        return SettingsExternalizer.buildOptionsByElement(elem, this.getID());
    }

    protected static Map<String, String> buildOptionsByName(List<? extends Element> children) {
        HashMap<String, String> options = new HashMap<String, String>();
        for (Element element : children) {
            options.put(element.getAttribute(NAME).getValue(), element.getAttribute(VALUE).getValue());
        }
        return options;
    }

    @NotNull
    protected String getAttributeFromElement(@NotNull String key, @NotNull Element element) {
        Attribute attr;
        if (key == null) {
            SettingsExternalizer.$$$reportNull$$$0(5);
        }
        if (element == null) {
            SettingsExternalizer.$$$reportNull$$$0(6);
        }
        return (attr = element.getAttribute(key)) != null ? attr.getValue() : "";
    }

    protected void storeAttributeInElement(@NotNull String key, @Nullable String value, @NotNull Element element) {
        if (key == null) {
            SettingsExternalizer.$$$reportNull$$$0(7);
        }
        if (element == null) {
            SettingsExternalizer.$$$reportNull$$$0(8);
        }
        element.setAttribute(key, value != null ? value : "");
    }

    public void writeOption(@Nullable String name, @Nullable String value, @NotNull Element elem) {
        if (elem == null) {
            SettingsExternalizer.$$$reportNull$$$0(9);
        }
        SettingsExternalizer.writeOption(name, value, elem, this.getID());
    }

    public static void writeOption(@Nullable String name, @Nullable String value, @NotNull Element elem, @NotNull String serializationId) {
        if (elem == null) {
            SettingsExternalizer.$$$reportNull$$$0(10);
        }
        if (serializationId == null) {
            SettingsExternalizer.$$$reportNull$$$0(11);
        }
        Element option = new Element(serializationId);
        option.setAttribute(NAME, name == null ? "" : name);
        option.setAttribute(VALUE, value == null ? "" : value);
        elem.addContent(option);
    }

    public static void getState(@NotNull Element element, List<String> list) {
        if (element == null) {
            SettingsExternalizer.$$$reportNull$$$0(12);
        }
        int size = list.size();
        element.setAttribute("number", String.valueOf(size));
        for (int i = 0; i < size; ++i) {
            element.setAttribute("string" + i, list.get(i));
        }
    }

    public static void loadState(@Nullable Element element, List<? super String> list) {
        list.clear();
        if (element == null) {
            return;
        }
        try {
            int number = Integer.parseInt(element.getAttributeValue("number"));
            for (int i = 0; i < number; ++i) {
                list.add(element.getAttributeValue("string" + i));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSettingsVersion";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializationId";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/settings/SettingsExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeCurrentVersion";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "buildOptionsByElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAttributeFromElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "storeAttributeInElement";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "writeOption";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

