/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.settings;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.impl.projectlevelman.PersistentVcsShowConfirmationOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorOptions;

public final class RProjectUtil {
    private RProjectUtil() {
    }

    public static boolean isVcsAddSilently(@NotNull Project project) {
        PersistentVcsShowConfirmationOption opt;
        if (project == null) {
            RProjectUtil.$$$reportNull$$$0(0);
        }
        return (opt = ProjectLevelVcsManagerEx.getInstanceEx((Project)project).getConfirmation(VcsConfiguration.StandardConfirmation.ADD)).getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY;
    }

    public static boolean isVcsAddShowConfirmation(@NotNull Project project) {
        PersistentVcsShowConfirmationOption opt;
        if (project == null) {
            RProjectUtil.$$$reportNull$$$0(1);
        }
        return (opt = ProjectLevelVcsManagerEx.getInstanceEx((Project)project).getConfirmation(VcsConfiguration.StandardConfirmation.ADD)).getValue() == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
    }

    public static boolean isSvnVcsActive(@NotNull Project project) {
        if (project == null) {
            RProjectUtil.$$$reportNull$$$0(2);
        }
        return RProjectUtil.checkIfVcsIsActive(project, "svn");
    }

    public static boolean isGitVcsActive(@NotNull Project project) {
        if (project == null) {
            RProjectUtil.$$$reportNull$$$0(3);
        }
        return RProjectUtil.checkIfVcsIsActive(project, "git");
    }

    public static GeneratorOptions getGeneratorsOptions(@NotNull Project project) {
        boolean showConfirmation;
        if (project == null) {
            RProjectUtil.$$$reportNull$$$0(4);
        }
        GeneratorOptions options = GeneratorOptions.getInstance(project);
        options.VCS_SHOW_CONFIRMATION = showConfirmation = RProjectUtil.isVcsAddShowConfirmation(project);
        if (!showConfirmation) {
            if (RProjectUtil.isVcsAddSilently(project)) {
                if (RProjectUtil.isGitVcsActive(project)) {
                    options.GIT = true;
                    options.SVN = false;
                } else if (RProjectUtil.isSvnVcsActive(project)) {
                    options.GIT = false;
                    options.SVN = true;
                } else {
                    options.GIT = false;
                    options.SVN = false;
                }
            } else {
                options.GIT = false;
                options.SVN = false;
            }
        }
        return options;
    }

    private static boolean checkIfVcsIsActive(Project project, String vcsName) {
        AbstractVcs[] vcses;
        for (AbstractVcs vcs : vcses = ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss()) {
            if (!vcsName.equals(vcs.getName())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "org/jetbrains/plugins/ruby/settings/RProjectUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isVcsAddSilently";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isVcsAddShowConfirmation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSvnVcsActive";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isGitVcsActive";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getGeneratorsOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

