/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePanel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.indexing.FindSymbolParameters;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.ExceptionCachingFilter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyClassModuleNameIndex;

public final class TreeRClassChooserDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GlobalSearchScope mySearchScope;
    private Tree myTree;
    @Nullable
    private RClass myInitialClass;
    private ChooseByNamePanel myGotoByNamePanel;
    private TabbedPaneWrapper myTabbedPane;
    private RClass mySelectedClass;
    private boolean myResult;

    public TreeRClassChooserDialog(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            TreeRClassChooserDialog.$$$reportNull$$$0(0);
        }
        if (title == null) {
            TreeRClassChooserDialog.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            TreeRClassChooserDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.myInitialClass = null;
        this.myProject = project;
        this.mySearchScope = scope;
        this.setTitle(title);
        this.init();
        this.handleSelectionChanged();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGotoByNamePanel.getPreferredFocusedComponent();
    }

    public RClass getSelectedClass() {
        return this.mySelectedClass;
    }

    public boolean showDialog() {
        this.myResult = false;
        this.show();
        return this.myResult;
    }

    @Nullable
    private RClass calcSelectedClass() {
        PsiFile file;
        if (this.myTabbedPane.getSelectedIndex() == 0) {
            return (RClass)this.myGotoByNamePanel.getChosenElement();
        }
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        Object userObject = node.getUserObject();
        if (userObject instanceof PsiFileNode && (file = (PsiFile)((PsiFileNode)userObject).getValue()) instanceof RFile) {
            List<RClass> classes = RContainerUtil.getTopLevelClasses((RContainer)((RFile)file));
            for (RClass rClass : classes) {
                if (rClass == null || !ExceptionCachingFilter.isAcceptedClass((PsiElement)rClass)) continue;
                return rClass;
            }
        }
        return null;
    }

    private RClass getContext() {
        return this.myInitialClass;
    }

    private ModalityState getModalityState() {
        return ModalityState.stateForComponent((Component)this.getRootPane());
    }

    private void handleSelectionChanged() {
        RClass selection = this.calcSelectedClass();
        this.setOKActionEnabled(selection != null);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        AbstractProjectTreeStructure treeStructure = new AbstractProjectTreeStructure(this.myProject){

            public boolean isHideEmptyMiddlePackages() {
                return true;
            }

            public boolean isShowLibraryContents() {
                return true;
            }

            public boolean isShowModules() {
                return false;
            }
        };
        StructureTreeModel model = new StructureTreeModel((AbstractTreeStructure)treeStructure, this.getDisposable());
        model.setComparator((Comparator)AlphaComparator.getInstance());
        this.myTree = new Tree((TreeModel)new AsyncTreeModel((TreeModel)model, this.getDisposable()));
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.expandRow(0);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setPreferredSize(new Dimension(500, 300));
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    TreeRClassChooserDialog.this.doOKAction();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                TreePath path;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((path = TreeRClassChooserDialog.this.myTree.getPathForLocation(e.getX(), e.getY())) != null && TreeRClassChooserDialog.this.myTree.isPathSelected(path)) {
                    TreeRClassChooserDialog.this.doOKAction();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/ui/TreeRClassChooserDialog$3", "onDoubleClick"));
            }
        }.installOn((Component)this.myTree);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreeRClassChooserDialog.this.handleSelectionChanged();
            }
        });
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)this.myTree);
        JPanel dummyPanel = new JPanel(new BorderLayout());
        this.myGotoByNamePanel = new MyChooseByNamePanel(null, dummyPanel);
        this.myTabbedPane = new TabbedPaneWrapper(this.getDisposable());
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.search.by.name", (Object[])new Object[0]), (JComponent)dummyPanel);
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.project", (Object[])new Object[0]), (JComponent)scrollPane);
        this.myGotoByNamePanel.invoke((ChooseByNamePopupComponent.Callback)new MyCallback(), this.getModalityState(), false);
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TreeRClassChooserDialog.this.handleSelectionChanged();
            }
        });
        return this.myTabbedPane.getComponent();
    }

    private ChooseByNameModel createChooseByNameModel() {
        return new MyGotoClassModel(this.myProject);
    }

    protected void doOKAction() {
        this.myResult = true;
        this.mySelectedClass = this.calcSelectedClass();
        if (this.mySelectedClass == null) {
            return;
        }
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.util.TreeClassChooserDialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "scope";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/ruby/ui/TreeRClassChooserDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyChooseByNamePanel
    extends ChooseByNamePanel {
        private final JPanel dummyPanel;

        MyChooseByNamePanel(String name, JPanel dummyPanel) {
            super(TreeRClassChooserDialog.this.myProject, TreeRClassChooserDialog.this.createChooseByNameModel(), name, TreeRClassChooserDialog.this.mySearchScope.isSearchInLibraries(), (PsiElement)TreeRClassChooserDialog.this.getContext());
            this.dummyPanel = dummyPanel;
        }

        protected void showTextFieldPanel() {
        }

        protected void close(boolean isOk) {
            super.close(isOk);
            if (isOk) {
                TreeRClassChooserDialog.this.doOKAction();
            } else {
                TreeRClassChooserDialog.this.doCancelAction();
            }
        }

        protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
            super.initUI(callback, modalityState, allowMultipleSelection);
            this.dummyPanel.add((Component)TreeRClassChooserDialog.this.myGotoByNamePanel.getPanel(), "Center");
            IdeFocusManager fm = IdeFocusManager.getGlobalInstance();
            fm.doWhenFocusSettlesDown(() -> fm.requestFocus((Component)IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)TreeRClassChooserDialog.this.myGotoByNamePanel.getPanel()), true));
        }

        protected void showList() {
            super.showList();
            if (TreeRClassChooserDialog.this.myInitialClass != null && this.myList.getModel().getSize() > 0) {
                this.myList.setSelectedValue(TreeRClassChooserDialog.this.myInitialClass, true);
                TreeRClassChooserDialog.this.myInitialClass = null;
            }
        }

        protected void chosenElementMightChange() {
            TreeRClassChooserDialog.this.handleSelectionChanged();
        }
    }

    private class MyCallback
    extends ChooseByNamePopupComponent.Callback {
        private MyCallback() {
        }

        public void elementChosen(Object element) {
            TreeRClassChooserDialog.this.mySelectedClass = (RClass)element;
            TreeRClassChooserDialog.this.close(0);
        }
    }

    private class MyGotoClassModel
    extends GotoClassModel2 {
        private final ProjectFileIndex myIndex;

        MyGotoClassModel(Project project) {
            if (project == null) {
                MyGotoClassModel.$$$reportNull$$$0(0);
            }
            super(project);
            this.myIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        }

        public Object @NotNull [] getElementsByName(@NotNull String name, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator canceled) {
            if (name == null) {
                MyGotoClassModel.$$$reportNull$$$0(1);
            }
            if (parameters == null) {
                MyGotoClassModel.$$$reportNull$$$0(2);
            }
            if (canceled == null) {
                MyGotoClassModel.$$$reportNull$$$0(3);
            }
            Collection classes = (Collection)ReadAction.compute(() -> RubyClassModuleNameIndex.getInstance().getElements(this.myProject, (SearchScope)TreeRClassChooserDialog.this.mySearchScope, name));
            boolean searchInLibraries = parameters.isSearchInLibraries();
            ArrayList<RPsiElement> list = new ArrayList<RPsiElement>();
            for (RPsiElement rClass : classes) {
                VirtualFile file = rClass.getContainingFile().getVirtualFile();
                if (!searchInLibraries && (file == null || this.myIndex.isInLibrarySource(file)) || !ExceptionCachingFilter.isAcceptedClass((PsiElement)rClass)) continue;
                list.add(rClass);
            }
            Object[] objectArray = list.toArray(RPsiElement.EMPTY_ARRAY);
            if (objectArray == null) {
                MyGotoClassModel.$$$reportNull$$$0(4);
            }
            return objectArray;
        }

        @Nullable
        public String getPromptText() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "canceled";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/ui/TreeRClassChooserDialog$MyGotoClassModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/ui/TreeRClassChooserDialog$MyGotoClassModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsByName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementsByName";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

