/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.templates;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.ide.actions.newclass.CreateWithTemplatesDialogPanel;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RubyCreateFileFromTemplateDialog {
    private RubyCreateFileFromTemplateDialog() {
    }

    @NotNull
    public static Builder builder(@NotNull Project project) {
        if (project == null) {
            RubyCreateFileFromTemplateDialog.$$$reportNull$$$0(0);
        }
        return new Builder(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ruby/ruby/templates/RubyCreateFileFromTemplateDialog", "builder"));
    }

    public static final class Builder {
        private final Project myProject;
        private final List<CreateWithTemplatesDialogPanel.TemplatePresentation> myTemplates;
        private @NlsContexts.PopupTitle String myTitle;
        private InputSuggester myInputSuggester;
        private InputValidator myInputValidator;

        private Builder(@NotNull Project project) {
            if (project == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myTemplates = new ArrayList<CreateWithTemplatesDialogPanel.TemplatePresentation>();
            this.myTitle = "";
            this.myInputSuggester = unused -> "";
            this.myInputValidator = new InputValidator(){

                @Override
                public boolean isInputValid(@NotNull String input, @NotNull String templateName) {
                    if (input == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (templateName == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return true;
                }

                @Override
                @Nullable
                public String getErrorText(@NotNull String input, @NotNull String templateName) {
                    if (input == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (templateName == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "input";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "templateName";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/templates/RubyCreateFileFromTemplateDialog$Builder$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isInputValid";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getErrorText";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myProject = project;
        }

        @NotNull
        public Builder setTitle(@NlsContexts.PopupTitle @NotNull String title) {
            if (title == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myTitle = title;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder2;
        }

        @NotNull
        public Builder addKind(@NotNull CreateWithTemplatesDialogPanel.TemplatePresentation template) {
            if (template == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myTemplates.add(template);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder2;
        }

        @NotNull
        public Builder addKind(@Nls @NotNull String kind, @Nullable Icon icon, @NotNull String templateName) {
            if (kind == null) {
                Builder.$$$reportNull$$$0(5);
            }
            if (templateName == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myTemplates.add(new CreateWithTemplatesDialogPanel.TemplatePresentation(kind, icon, templateName));
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder2;
        }

        @NotNull
        public Builder setInputSuggester(@NotNull InputSuggester inputSuggester) {
            if (inputSuggester == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myInputSuggester = inputSuggester;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder2;
        }

        @NotNull
        public Builder setInputValidator(@NotNull InputValidator inputValidator) {
            if (inputValidator == null) {
                Builder.$$$reportNull$$$0(10);
            }
            this.myInputValidator = inputValidator;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return builder2;
        }

        public <T extends PsiElement> void show(@Nullable String selectedItem, final @NotNull CreateFileFromTemplateDialog.FileCreator<T> fileCreator, @NotNull Consumer<? super T> elementConsumer) {
            if (fileCreator == null) {
                Builder.$$$reportNull$$$0(12);
            }
            if (elementConsumer == null) {
                Builder.$$$reportNull$$$0(13);
            }
            final CreateWithTemplatesDialogPanel contentPanel = new CreateWithTemplatesDialogPanel(selectedItem, this.myTemplates){
                {
                    super(arg0, arg1);
                    final JTextField nameField = this.getNameField();
                    this.myTemplatesList.addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            CreateWithTemplatesDialogPanel.TemplatePresentation previousValue = (CreateWithTemplatesDialogPanel.TemplatePresentation)myTemplatesList.getModel().getElementAt(myTemplatesList.getSelectedIndex() == e.getFirstIndex() ? e.getLastIndex() : e.getFirstIndex());
                            String suggestion = myInputSuggester.getSuggestion(this.getSelectedTemplate());
                            if (previousValue == null || this.getEnteredName().isEmpty() || this.getEnteredName().equals(myInputSuggester.getSuggestion(previousValue.templateName()))) {
                                nameField.setText(suggestion);
                                nameField.selectAll();
                            } else if (!this.getEnteredName().equals(suggestion)) {
                                myTemplatesList.removeListSelectionListener(this);
                            }
                        }
                    });
                    nameField.setText(myInputSuggester.getSuggestion(this.getSelectedTemplate()));
                    nameField.selectAll();
                }
            };
            ElementCreator elementCreator = new ElementCreator(this.myProject, CommonBundle.getErrorTitle()){

                protected PsiElement @NotNull [] create(@NotNull String newName) {
                    PsiElement[] psiElementArray;
                    PsiElement element;
                    if (newName == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if ((element = (PsiElement)fileCreator.createFile(contentPanel.getEnteredName(), contentPanel.getSelectedTemplate())) != null) {
                        PsiElement[] psiElementArray2 = new PsiElement[1];
                        psiElementArray = psiElementArray2;
                        psiElementArray2[0] = element;
                    } else {
                        psiElementArray = PsiElement.EMPTY_ARRAY;
                    }
                    if (psiElementArray == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return psiElementArray;
                }

                public boolean startInWriteAction() {
                    return fileCreator.startInWriteAction();
                }

                @NotNull
                protected String getActionName(@NotNull String newName) {
                    if (newName == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    String string = fileCreator.getActionName(newName, contentPanel.getSelectedTemplate());
                    if (string == null) {
                        3.$$$reportNull$$$0(3);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 3 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newName";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/templates/RubyCreateFileFromTemplateDialog$Builder$3";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/templates/RubyCreateFileFromTemplateDialog$Builder$3";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "create";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "create";
                            break;
                        }
                        case 1: 
                        case 3: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "getActionName";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 3 -> new IllegalStateException(string);
                    };
                }
            };
            if (StringUtil.isEmpty((String)this.myTitle)) {
                throw new IllegalStateException();
            }
            JBPopup popup = NewItemPopupUtil.createNewItemPopup((String)this.myTitle, (JComponent)contentPanel, (JComponent)contentPanel.getNameField());
            contentPanel.setApplyAction(e -> {
                String input = contentPanel.getEnteredName();
                String templateName = contentPanel.getSelectedTemplate();
                if (StringUtil.isEmptyOrSpaces((String)input)) {
                    return;
                }
                if (this.myInputValidator.isInputValid(input, templateName)) {
                    popup.closeOk(e);
                    PsiElement createdElement = (PsiElement)ArrayUtil.getFirstElement((Object[])elementCreator.tryCreate(input));
                    if (createdElement != null) {
                        elementConsumer.consume((Object)createdElement);
                    }
                } else {
                    String errorMessage = Optional.ofNullable(this.myInputValidator).map(validator -> validator.getErrorText(input, templateName)).orElse(LangBundle.message((String)"incorrect.name", (Object[])new Object[0]));
                    contentPanel.setError(errorMessage);
                }
            });
            Disposer.register((Disposable)popup, (Disposable)contentPanel);
            popup.showCenteredInCurrentWindow(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 7, 9, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/templates/RubyCreateFileFromTemplateDialog$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateName";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputSuggester";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputValidator";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileCreator";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/templates/RubyCreateFileFromTemplateDialog$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTitle";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addKind";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setInputSuggester";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setInputValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setTitle";
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 9: 
                case 11: {
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addKind";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setInputSuggester";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "setInputValidator";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "show";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 7, 9, 11 -> new IllegalStateException(string);
            };
        }
    }

    public static interface InputValidator {
        public boolean isInputValid(@NotNull String var1, @NotNull String var2);

        @Nullable
        public String getErrorText(@NotNull String var1, @NotNull String var2);
    }

    public static interface InputSuggester {
        @NotNull
        public String getSuggestion(@NotNull String var1);
    }
}

