/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.templates;

import com.google.common.collect.ImmutableMap;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.actions.NewFileActionWithCategory;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.templates.RubyTemplateNames;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public abstract class RubyCreateFileFromTemplateAction
extends CreateFileFromTemplateAction
implements NewFileActionWithCategory {
    public RubyCreateFileFromTemplateAction() {
    }

    public RubyCreateFileFromTemplateAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, @NotNull Icon icon) {
        if (dynamicText == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(0);
        }
        if (dynamicDescription == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(1);
        }
        if (icon == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(2);
        }
        super(dynamicText, dynamicDescription, icon);
    }

    @NotNull
    public String getCategory() {
        return "Ruby";
    }

    protected boolean isAvailable(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(3);
        }
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Module module = (Module)dataContext.getData(PlatformCoreDataKeys.MODULE);
        if (module != null) {
            return RModuleUtil.getInstance().hasRubySupport(module);
        }
        Project project = Objects.requireNonNull((Project)CommonDataKeys.PROJECT.getData(dataContext));
        return RubySdkUtil.findRubySdk(project) != null;
    }

    protected void postProcess(@NotNull PsiFile file, String templateName, Map<String, String> customProperties) {
        if (file == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(4);
        }
        RubyCreateFileFromTemplateAction.moveCaretAfterNameIdentifier(file);
    }

    @Nullable
    public static PsiFile createFileFromTemplate(@NotNull FileTemplate template, @NotNull String name, @NotNull PsiDirectory dir, @Nullable String defaultTemplateProperty) {
        if (template == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(5);
        }
        if (name == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(6);
        }
        if (dir == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(7);
        }
        if (RubyTemplateNames.SPEC_TEMPLATES.contains(template.getName())) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)dir);
            String fileName = NamingConventions.toUnderscoreCase((String)FQN.of((String)name).getShortName(), (Module)module) + "_spec";
            return RubyCreateFileFromTemplateAction.createFileFromTemplate(template, fileName, (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)name), dir, defaultTemplateProperty);
        }
        if (RubyTemplateNames.TEST_TEMPLATES.contains(template.getName())) {
            return RubyCreateFileFromTemplateAction.createFileFromClassOrModuleTemplate(template, StringUtil.trimEnd((String)name, (String)"Test") + "Test", dir, defaultTemplateProperty);
        }
        return RubyCreateFileFromTemplateAction.createFileFromTemplate(template, name, Collections.emptyMap(), dir, defaultTemplateProperty);
    }

    public static void moveCaretAfterNameIdentifier(@NotNull PsiFile file) {
        if (file == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(8);
        }
        PsiNameIdentifierOwner container = null;
        PsiFile next = file;
        while (next != null) {
            if (next instanceof PsiNameIdentifierOwner) {
                container = (PsiNameIdentifierOwner)next;
            }
            next = PsiTreeUtil.findChildOfAnyType((PsiElement)next, (Class[])new Class[]{RClass.class, RModule.class});
        }
        if (container != null) {
            RubyCreateFileFromTemplateAction.moveCaretAfterNameIdentifier(container);
        }
    }

    @Nullable
    protected static PsiFile createFileFromTemplate(@NotNull FileTemplate template, @NotNull String name, @NotNull Map<String, String> extraProperties, @NotNull PsiDirectory dir, @Nullable String defaultTemplateProperty) {
        if (template == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(9);
        }
        if (name == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(10);
        }
        if (extraProperties == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(11);
        }
        if (dir == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(12);
        }
        Properties properties = FileTemplateManager.getInstance((Project)dir.getProject()).getDefaultProperties();
        extraProperties.forEach(properties::setProperty);
        try {
            PsiFile file = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)name, (Properties)properties, (PsiDirectory)dir).getContainingFile();
            if (file != null && defaultTemplateProperty != null) {
                PropertiesComponent.getInstance((Project)dir.getProject()).setValue(defaultTemplateProperty, template.getName());
            }
            return file;
        }
        catch (IncorrectOperationException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(RubyCreateFileFromTemplateAction.class).error((Throwable)e);
            return null;
        }
    }

    @Nullable
    protected static PsiFile createFileFromClassOrModuleTemplate(@NotNull FileTemplate template, @NotNull String name, @NotNull PsiDirectory dir) {
        if (template == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(13);
        }
        if (name == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(14);
        }
        if (dir == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(15);
        }
        return RubyCreateFileFromTemplateAction.createFileFromClassOrModuleTemplate(template, name, dir, null);
    }

    @Nullable
    protected static PsiFile createFileFromClassOrModuleTemplate(@NotNull FileTemplate template, @NotNull String name, @NotNull PsiDirectory dir, @Nullable String defaultTemplateProperty) {
        if (template == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(16);
        }
        if (name == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(17);
        }
        if (dir == null) {
            RubyCreateFileFromTemplateAction.$$$reportNull$$$0(18);
        }
        if (!TextUtil.isCIDOrColonQualifiedReference((String)name)) {
            throw new IncorrectOperationException(RBundle.message((String)"ruby.action.create.new.class.file.dialog.invalid.name"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)dir);
        FQN fqn = FQN.of((String)name);
        String fileName = NamingConventions.toUnderscoreCase((String)fqn.getShortName(), (Module)module);
        PsiFile file = RubyCreateFileFromTemplateAction.createFileFromTemplate(template, fileName, (Map<String, String>)ImmutableMap.of((Object)"NAME", (Object)fqn.getShortName()), dir, defaultTemplateProperty);
        RContainer container = (RContainer)PsiTreeUtil.findChildOfAnyType((PsiElement)file, (Class[])new Class[]{RClass.class, RModule.class});
        if (container == null) {
            return file;
        }
        FQN callerFqn = fqn.getCallerFQN();
        if (callerFqn != FQN.INVALID) {
            container.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)container, (String)(callerFqn.asStream().map(parent -> "module " + parent + "\n").collect(Collectors.joining()) + container.getText() + StringUtil.repeat((String)"\nend", (int)callerFqn.asList().size()))));
        }
        if (template.isLiveTemplateEnabled()) {
            CreateFromTemplateActionBase.startLiveTemplate((PsiFile)file, Collections.emptyMap());
        } else {
            FileEditorManager.getInstance((Project)file.getProject()).openFile(file.getVirtualFile(), true);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraProperties";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/templates/RubyCreateFileFromTemplateAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcess";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileFromTemplate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "moveCaretAfterNameIdentifier";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "createFileFromClassOrModuleTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

