/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.templates;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.ide.actions.newclass.CreateWithTemplatesDialogPanel;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.templates.CreateFileFromTemplateInDirectoryDialogPanel;

public final class CreateFileFromTemplateInDirectoryDialog {
    private static final InputValidatorEx DIRECTORY_INPUT_VALIDATOR = new InputValidatorEx(){

        @Nullable
        public String getErrorText(@NotNull String input) {
            if (input == null) {
                1.$$$reportNull$$$0(0);
            }
            if (OSAgnosticPathUtil.isAbsolute((String)input) || input.equals("~") || input.startsWith("~" + File.separator)) {
                return RBundle.message((String)"ruby.dialog.create.file.from.template.in.directory.invalid.directory.absolute");
            }
            return null;
        }

        public boolean canClose(@NotNull String input) {
            if (input == null) {
                1.$$$reportNull$$$0(1);
            }
            return StringUtil.isNotEmpty((String)input) && this.getErrorText(input) == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "input";
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialog$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getErrorText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canClose";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private CreateFileFromTemplateInDirectoryDialog() {
    }

    @NotNull
    public static Builder builder(@NotNull Project project) {
        if (project == null) {
            CreateFileFromTemplateInDirectoryDialog.$$$reportNull$$$0(0);
        }
        return new Builder(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialog", "builder"));
    }

    public static final class Builder {
        private final Project myProject;
        @Nullable
        private VirtualFile myRoot;
        private @NlsContexts.PopupTitle @Nullable String myTitle;
        @Nullable
        private CreateWithTemplatesDialogPanel.TemplatePresentation myTemplate;
        @Nullable
        private InputValidatorEx myInputValidator;
        @Nullable
        private String myDefaultDirectory;
        @Nullable
        private String myDefaultName;

        private Builder(@NotNull Project project) {
            if (project == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @NotNull
        public Builder setDefaultDirectory(@NotNull String directory) {
            if (directory == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myDefaultDirectory = directory;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder2;
        }

        @NotNull
        public Builder setDefaultName(@NotNull String name) {
            if (name == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myDefaultName = name;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder2;
        }

        @NotNull
        public Builder setKind(@Nls @NotNull String kind, @Nullable Icon icon, @NotNull String templateName) {
            if (kind == null) {
                Builder.$$$reportNull$$$0(5);
            }
            if (templateName == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myTemplate = new CreateWithTemplatesDialogPanel.TemplatePresentation(kind, icon, templateName);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder2;
        }

        @NotNull
        public Builder setRoot(@NotNull VirtualFile root) {
            if (root == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myRoot = root;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder2;
        }

        @NotNull
        public Builder setTitle(@NlsContexts.PopupTitle String title) {
            this.myTitle = title;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder2;
        }

        @NotNull
        public Builder setValidator(@NotNull InputValidatorEx validator) {
            if (validator == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.myInputValidator = validator;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder2;
        }

        public <T extends PsiFile> void show(final @NotNull FileCreator<? extends T> fileCreator, @NotNull Consumer<T> callback) {
            if (fileCreator == null) {
                Builder.$$$reportNull$$$0(13);
            }
            if (callback == null) {
                Builder.$$$reportNull$$$0(14);
            }
            CreateFileFromTemplateInDirectoryDialogPanel panel2 = new CreateFileFromTemplateInDirectoryDialogPanel(this.myProject, Objects.requireNonNull(this.myRoot), Objects.requireNonNull(this.myTemplate));
            if (this.myDefaultName != null) {
                JTextField nameField = panel2.getNameField();
                nameField.setText(this.myDefaultName);
                nameField.select(0, this.myDefaultName.contains(".") ? this.myDefaultName.lastIndexOf(".") : this.myDefaultName.length());
            }
            if (this.myDefaultDirectory != null) {
                panel2.getDirectoryField().setText(StringUtil.trimEnd((String)this.myDefaultDirectory, (String)File.separator) + File.separator);
            }
            JBPopup popup = NewItemPopupUtil.createNewItemPopup((String)Objects.requireNonNull(this.myTitle), (JComponent)((Object)panel2), (JComponent)panel2.getNameField());
            Disposer.register((Disposable)popup, (Disposable)panel2);
            panel2.setApplyAction(event -> {
                String name = panel2.getEnteredName();
                final String directory = panel2.getEnteredDirectory();
                if (name.isBlank() || directory.isBlank()) {
                    return;
                }
                if (this.myInputValidator != null && !this.myInputValidator.canClose(name)) {
                    panel2.setError((String)ObjectUtils.coalesce((Object)this.myInputValidator.getErrorText(name), (Object)LangBundle.message((String)"incorrect.name", (Object[])new Object[0])));
                    return;
                }
                if (!DIRECTORY_INPUT_VALIDATOR.canClose(directory)) {
                    panel2.setDirectoryError((String)ObjectUtils.coalesce((Object)DIRECTORY_INPUT_VALIDATOR.getErrorText(directory), (Object)RBundle.message((String)"ruby.dialog.create.file.from.template.in.directory.invalid.directory.fallback")));
                    return;
                }
                popup.closeOk(event);
                PsiFile file = (PsiFile)ContainerUtil.getOnlyItem(List.of(new ElementCreator(this.myProject, CommonBundle.getErrorTitle()){

                    public boolean startInWriteAction() {
                        return fileCreator.startInWriteAction();
                    }

                    protected PsiElement @NotNull [] create(@NotNull String name) throws Exception {
                        PsiDirectory dir;
                        if (name == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((dir = (PsiDirectory)ObjectUtils.doIfNotNull((Object)VfsUtil.createDirectoryIfMissing((VirtualFile)myRoot, (String)FileUtil.toCanonicalPath((String)directory)), it -> PsiManager.getInstance((Project)myProject).findDirectory(it))) == null) {
                            if (PsiFile.EMPTY_ARRAY == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return PsiFile.EMPTY_ARRAY;
                        }
                        Object file = fileCreator.createFile(dir, name);
                        Object[] objectArray = file != null ? (PsiElement[])ContainerUtil.ar((Object[])new PsiFile[]{file}) : PsiFile.EMPTY_ARRAY;
                        if (objectArray == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return objectArray;
                    }

                    @NotNull
                    protected String getActionName(@NotNull String name) {
                        if (name == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        String string = fileCreator.getActionName(name);
                        if (string == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 1, 2, 4 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "name";
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 4: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialog$Builder$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialog$Builder$1";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "create";
                                break;
                            }
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getActionName";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "create";
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 4: {
                                break;
                            }
                            case 3: {
                                objectArray = objectArray;
                                objectArray[2] = "getActionName";
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 1, 2, 4 -> new IllegalStateException(string);
                        };
                    }
                }.tryCreate(name)));
                if (file != null) {
                    callback.accept(file);
                }
            });
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                panel2.getApplyAction().consume(null);
                return;
            }
            popup.showCenteredInCurrentWindow(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 7, 9, 10, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 9: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialog$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateName";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "validator";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileCreator";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/templates/CreateFileFromTemplateInDirectoryDialog$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDefaultDirectory";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDefaultName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setKind";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRoot";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTitle";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setDefaultDirectory";
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 9: 
                case 10: 
                case 12: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setDefaultName";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setKind";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setRoot";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setValidator";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "show";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 7, 9, 10, 12 -> new IllegalStateException(string);
            };
        }
    }

    public static interface FileCreator<T extends PsiFile> {
        @Nullable
        public T createFile(@NotNull PsiDirectory var1, @NonNls @NotNull String var2) throws Exception;

        @NlsContexts.Command
        @NotNull
        public String getActionName(@NonNls @NotNull String var1);

        default public boolean startInWriteAction() {
            return true;
        }
    }
}

