/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.FormBuilder;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;

public class RubySdkCustomConfiguratorDialog
extends DialogWrapper {
    @NotNull
    private final TextFieldWithBrowseButton myInterpreterPathField = new TextFieldWithBrowseButton();
    @NotNull
    private final RawCommandLineEditor myConfiguratorAndArgumentsEditor = new RawCommandLineEditor();
    @NotNull
    private final JPanel myPanel;
    private final boolean myIsReopened;

    public RubySdkCustomConfiguratorDialog(@Nullable Project project, boolean isReopened) {
        super(project, false);
        this.myIsReopened = isReopened;
        RubySdkType rubySdkType = RubySdkType.getInstance();
        this.myInterpreterPathField.addBrowseFolderListener(project, rubySdkType.getHomeChooserDescriptor().withTitle(RBundle.message((String)"ruby.ide.sdk.type.home.chooser.descriptor.title")));
        this.myPanel = FormBuilder.createFormBuilder().addLabeledComponent(rubySdkType.getHomeFieldLabel(), (JComponent)this.myInterpreterPathField).addLabeledComponent(RBundle.message((String)"ruby.ide.sdk.configurable.custom.configurator.dialog.editor.label"), (JComponent)this.myConfiguratorAndArgumentsEditor).getPanel();
        this.init();
        this.setTitle(RBundle.message((String)"ruby.ide.sdk.configurable.custom.configurator.dialog.title"));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myPanel.setMinimumSize(new Dimension(600, -1));
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myIsReopened ? this.myConfiguratorAndArgumentsEditor.getEditorField() : this.myInterpreterPathField;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String interpreterPath = this.getInterpreterPath();
        if (StringUtilRt.isEmpty((CharSequence)interpreterPath)) {
            return new ValidationInfo(RBundle.message((String)"ruby.ide.sdk.configurable.custom.configurator.dialog.no.path.specified"), (JComponent)this.myInterpreterPathField);
        }
        if (!RubySdkType.getInstance().isValidSdkHome(interpreterPath)) {
            return new ValidationInfo(RBundle.message((String)"ruby.ide.sdk.configurable.custom.configurator.dialog.no.valid.interpreter"), (JComponent)this.myInterpreterPathField);
        }
        if (this.getConfiguratorAndArguments().isEmpty()) {
            return new ValidationInfo(RBundle.message((String)"ruby.ide.sdk.configurable.custom.configurator.dialog.no.script.specified"), (JComponent)this.myConfiguratorAndArgumentsEditor);
        }
        return null;
    }

    @NotNull
    @NlsSafe
    public String getInterpreterPath() {
        String string = this.myInterpreterPathField.getText();
        if (string == null) {
            RubySdkCustomConfiguratorDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    public @NotNull List<@NlsSafe String> getConfiguratorAndArguments() {
        List list = (List)ParametersListUtil.DEFAULT_LINE_PARSER.fun((Object)this.myConfiguratorAndArgumentsEditor.getText());
        if (list == null) {
            RubySdkCustomConfiguratorDialog.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void show(@NotNull @NlsSafe String homePath, @NotNull List<@NlsSafe String> configuratorAndArguments) {
        if (homePath == null) {
            RubySdkCustomConfiguratorDialog.$$$reportNull$$$0(2);
        }
        if (configuratorAndArguments == null) {
            RubySdkCustomConfiguratorDialog.$$$reportNull$$$0(3);
        }
        this.myInterpreterPathField.setText(homePath);
        this.myConfiguratorAndArgumentsEditor.setText((String)ParametersListUtil.DEFAULT_LINE_JOINER.fun(configuratorAndArguments));
        this.show();
    }

    @NonNls
    protected String getHelpId() {
        return "ruby.sdk.custom.configurator";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/ui/RubySdkCustomConfiguratorDialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuratorAndArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguratorAndArguments";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/ui/RubySdkCustomConfiguratorDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

