/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk.jruby;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.ui.SdkComparator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkType;
import org.jetbrains.plugins.ruby.utils.OSUtil;

public final class JRubySdkUtil {
    @NonNls
    private static final String JRUBY_20_PARAM = "--2.0";
    @NonNls
    private static final String JRUBY_19_PARAM = "--1.9";
    @NonNls
    private static final String JRUBY_18_PARAM = "--1.8";
    @NonNls
    public static final String JRUBY_CLASSPATH_ENV = "CLASSPATH";
    @NonNls
    private static final String JRUBY_EXTRA_CLASSPATH = "JRUBY_EXTRA_CLASSPATH";
    @NonNls
    public static final String JRUBY_OPTS = "JRUBY_OPTS";
    @NonNls
    public static final String JRUBY_JAVA_HOME = "rubymine.jruby.java.home";
    @NonNls
    private static final String JRUBY_JAR_NAME = "jruby.jar";
    private static final Pattern JRUBY_VERSION_PATTERN = Pattern.compile("ver.(.*?)\\s*\\(([^)]*)\\).*(?:VM).*");

    private JRubySdkUtil() {
    }

    public static Sdk[] getValidSdks() {
        List<Object> foundSdks = new ArrayList<Object>();
        foundSdks.add(null);
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (!JRubySdkUtil.isJRubySDK(sdk)) continue;
            foundSdks.add(sdk);
        }
        foundSdks = SdkComparator.sortSdks(foundSdks);
        return foundSdks.toArray(new Sdk[0]);
    }

    @Deprecated
    @ApiStatus.Internal
    public static boolean isJRubySDK(@Nullable Sdk sdk) {
        return sdk != null && sdk.getSdkType() instanceof JRubySdkType;
    }

    public static void specifyLanguageLevel(@NotNull GeneralCommandLine cmdLine, @Nullable Sdk sdk) {
        if (cmdLine == null) {
            JRubySdkUtil.$$$reportNull$$$0(0);
        }
        assert (JRubySdkUtil.isJRubySDK(sdk));
        switch (RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk)) {
            case RUBY19: {
                JRubySdkUtil.appendJrubyOpt(cmdLine, JRUBY_19_PARAM);
                break;
            }
            case RUBY20: {
                JRubySdkUtil.appendJrubyOpt(cmdLine, JRUBY_20_PARAM);
                break;
            }
            case RUBY18: {
                JRubySdkUtil.appendJrubyOpt(cmdLine, JRUBY_18_PARAM);
                break;
            }
        }
    }

    private static void appendJrubyOpt(@NotNull GeneralCommandLine commandLine, @NotNull String option) {
        if (commandLine == null) {
            JRubySdkUtil.$$$reportNull$$$0(1);
        }
        if (option == null) {
            JRubySdkUtil.$$$reportNull$$$0(2);
        }
        OSUtil.appendToEnvVariable(JRUBY_OPTS, option, commandLine.getEnvironment(), " ");
    }

    public static boolean isJRubyGreaterThan17(@Nullable Sdk sdk) {
        return JRubySdkUtil.isJRubySDK(sdk) && VersionComparatorUtil.compare((String)JRubySdkUtil.getJRubyShortVersion(sdk.getVersionString()), (String)"1.7.0.preview1") >= 0;
    }

    public static boolean isJRubyGreaterEqual19(@Nullable Sdk sdk) {
        return JRubySdkUtil.isJRubySDK(sdk) && VersionComparatorUtil.compare((String)JRubySdkUtil.getJRubyShortVersion(sdk.getVersionString()), (String)"9.0.0.0.pre1") >= 0;
    }

    public static LanguageLevel @NotNull [] getSupportedLanguageLevels(@Nullable Sdk sdk) {
        if (sdk != null && JRubySdkUtil.isJRubySDK(sdk) && VersionComparatorUtil.compare((String)JRubySdkUtil.getJRubyShortVersion(sdk.getVersionString()), (String)"1.7.4") >= 0) {
            LanguageLevel[] languageLevelArray = new LanguageLevel[]{LanguageLevel.RUBY18, LanguageLevel.RUBY19, LanguageLevel.RUBY20};
            if (languageLevelArray == null) {
                JRubySdkUtil.$$$reportNull$$$0(3);
            }
            return languageLevelArray;
        }
        LanguageLevel[] languageLevelArray = new LanguageLevel[]{LanguageLevel.RUBY18, LanguageLevel.RUBY19};
        if (languageLevelArray == null) {
            JRubySdkUtil.$$$reportNull$$$0(4);
        }
        return languageLevelArray;
    }

    @Nullable
    public static String getJRubyShortVersion(@Nullable String version) {
        if (version == null) {
            return null;
        }
        Matcher matcher = JRUBY_VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    @Nullable
    public static String getJRubyMRILikeShortVersion(@Nullable String version) {
        if (version == null) {
            return null;
        }
        Matcher matcher = JRUBY_VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    public static void addJRubyClassPathParams(@NotNull GeneralCommandLine cmdLine, @NotNull String classPath, boolean isForJavaExecutable) {
        if (cmdLine == null) {
            JRubySdkUtil.$$$reportNull$$$0(5);
        }
        if (classPath == null) {
            JRubySdkUtil.$$$reportNull$$$0(6);
        }
        cmdLine.addParameter(isForJavaExecutable ? "-cp" : "-J-cp");
        cmdLine.addParameter(classPath);
        cmdLine.getEnvironment().remove(JRUBY_CLASSPATH_ENV);
    }

    public static void addJRubyClassPath(@NotNull GeneralCommandLine cmdLine, @Nullable String additionalClassPath) {
        if (cmdLine == null) {
            JRubySdkUtil.$$$reportNull$$$0(7);
        }
        StringBuilder classPath = new StringBuilder();
        String extraCp = EnvironmentUtil.getValue((String)JRUBY_EXTRA_CLASSPATH);
        if (extraCp != null) {
            classPath.append(extraCp);
        }
        String cp = classPath.toString();
        if (additionalClassPath != null) {
            cp = OSUtil.appendToPATHenvVariable(cp, additionalClassPath);
        }
        if (StringUtil.isEmpty((String)cp)) {
            return;
        }
        JRubySdkUtil.addJRubyClassPathParams(cmdLine, cp, false);
    }

    public static void enableObjectSpaceIfNotOverriddenByUser(@NotNull AbstractRubyRunConfigurationParams conf) {
        Map<String, String> envs;
        if (conf == null) {
            JRubySdkUtil.$$$reportNull$$$0(8);
        }
        if (!(envs = conf.getEnvs()).containsKey(JRUBY_OPTS)) {
            envs.put(JRUBY_OPTS, "-X+O");
        }
    }

    public static String getLibPath(@NotNull Sdk sdk) {
        String homePath;
        if (sdk == null) {
            JRubySdkUtil.$$$reportNull$$$0(9);
        }
        if ((homePath = sdk.getHomePath()) == null) {
            return null;
        }
        String sdkPath = PathUtil.getParentPath((String)PathUtil.getParentPath((String)homePath));
        return FileUtil.join((String[])new String[]{sdkPath, "lib"});
    }

    @NotNull
    public static String getJRubyJarPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            JRubySdkUtil.$$$reportNull$$$0(10);
        }
        String string = FileUtil.join((String[])new String[]{JRubySdkUtil.getLibPath(sdk), JRUBY_JAR_NAME});
        if (string == null) {
            JRubySdkUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static String getSourcesPathInJRubyJarFile(@NotNull Sdk sdk, @Nullable PathMappingSettings pathMappingSettings) {
        if (sdk == null) {
            JRubySdkUtil.$$$reportNull$$$0(12);
        }
        String jarPath = JRubySdkUtil.getJRubyJarPath(sdk);
        if (pathMappingSettings != null) {
            jarPath = pathMappingSettings.convertToLocal(jarPath);
        }
        String insidePath = JRubySdkUtil.isJRubyGreaterThan17(sdk) ? "jruby" : "builtin/javasupport";
        return "jar://" + jarPath + "!/" + insidePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/jruby/JRubySdkUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/jruby/JRubySdkUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLanguageLevels";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getJRubyJarPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "specifyLanguageLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendJrubyOpt";
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addJRubyClassPathParams";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addJRubyClassPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "enableObjectSpaceIfNotOverriddenByUser";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLibPath";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getJRubyJarPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSourcesPathInJRubyJarFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 11 -> new IllegalStateException(string);
        };
    }
}

