/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalDataBase;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.SdkRefresher;

public final class RubyVersionUtil {
    @NonNls
    public static final String RUBY_VERSION_FILE_NAME = ".ruby-version";
    @NonNls
    public static final String RUBY_GEMSET_FILE_NAME = ".ruby-gemset";
    private static final Logger LOG = Logger.getInstance(RubyVersionUtil.class);
    private static final List<String> RUBY_SDK_VERSION_SCRIPT = Arrays.asList("-e", "puts RUBY_DESCRIPTION.strip; puts RUBY_PATCHLEVEL.to_s");
    @NonNls
    public static final String GET_PATCHLEVEL_SCRIPT = "print(defined?(RUBY_PATCHLEVEL) ? RUBY_PATCHLEVEL : 0)";
    @NonNls
    private static final String IRONRUBY_VERSION_SIGNATURE = "ir";
    @NonNls
    private static final String MACRUBY_VERSION_SIGNATURE = "macruby";
    @NonNls
    private static final String MAGLEV_VERSION_SIGNATURE = "maglev";
    @NonNls
    private static final String TRUFFLE_VERSION_SIGNATURE = "truffleruby";
    @NonNls
    private static final String RUBINIUS_VERSION_SIGNATURE = "rubinius";
    private static final Pattern RUBINIUS_VERSION_PATTERN = Pattern.compile("rubinius\\s*([0-9]+(\\.[0-9A-z]+)*)\\s*.*");
    private static final Pattern TRUFFLE_VERSION_PATTERN = Pattern.compile("truffleruby\\s+([0-9]+(\\.[0-9A-z]+)*).*");
    public static final String JRUBY_9000 = "9.0.0.0.snapshot";
    public static final String GEMSET_SEPARATOR = "@";
    private static final TreeMap<String, String> FAKE_JRUBY_VERSIONS_LADDER = new TreeMap<String, String>(Map.of("0", "1.8.0", "1.6", "1.9.0", "1.7", "1.9.3", "9.0.0.0", "2.2.0", "9.1.0.0", "2.3.0", "9.2.0.0", "2.5.0"));
    private static final List<Pair<String, LanguageLevel>> RUBINIUS_VERSION_AND_LEVEL_DESC = List.of(Pair.pair((Object)"2.0.0pre", (Object)LanguageLevel.RUBY21));
    private static final List<Pair<String, LanguageLevel>> TRUFFLE_VERSION_AND_LEVEL_DESC = List.of(Pair.pair((Object)"23.0.0", (Object)LanguageLevel.RUBY31), Pair.pair((Object)"22.0.0", (Object)LanguageLevel.RUBY30), Pair.pair((Object)"21.0.0", (Object)LanguageLevel.RUBY27), Pair.pair((Object)"20.0.0", (Object)LanguageLevel.RUBY26), Pair.pair((Object)"19.0.0", (Object)LanguageLevel.RUBY26));
    private static final List<Pair<String, LanguageLevel>> JRUBY_VERSION_AND_LEVEL_DESC = List.of(Pair.pair((Object)"9.4.0.0", (Object)LanguageLevel.RUBY31), Pair.pair((Object)"9.3.0.0", (Object)LanguageLevel.RUBY26), Pair.pair((Object)"9.2.0.0", (Object)LanguageLevel.RUBY25), Pair.pair((Object)"9.1.0.0", (Object)LanguageLevel.RUBY23), Pair.pair((Object)"9.0.0.0.snapshot", (Object)LanguageLevel.RUBY22));
    private static final List<Pair<String, LanguageLevel>> MRI_VERSION_AND_LEVEL_DESC = List.of(Pair.pair((Object)"3.4.0", (Object)LanguageLevel.RUBY34), Pair.pair((Object)"3.3.0", (Object)LanguageLevel.RUBY33), Pair.pair((Object)"3.2.0", (Object)LanguageLevel.RUBY32), Pair.pair((Object)"3.1.0", (Object)LanguageLevel.RUBY31), Pair.pair((Object)"3.0.0", (Object)LanguageLevel.RUBY30), Pair.pair((Object)"2.7.0", (Object)LanguageLevel.RUBY27), Pair.pair((Object)"2.6.0", (Object)LanguageLevel.RUBY26), Pair.pair((Object)"2.5.0", (Object)LanguageLevel.RUBY25), Pair.pair((Object)"2.4.0", (Object)LanguageLevel.RUBY24), Pair.pair((Object)"2.3.0", (Object)LanguageLevel.RUBY23), Pair.pair((Object)"2.2.0", (Object)LanguageLevel.RUBY22), Pair.pair((Object)"2.1.0", (Object)LanguageLevel.RUBY21));
    public static final String RUBY_MRI_PREFIX = "ruby-";

    private RubyVersionUtil() {
    }

    @Nullable
    public static String extractPlatformFromVersion(@Nullable String version) {
        if (version == null) {
            return null;
        }
        int os_info_start = version.indexOf(91);
        int os_info_end = version.indexOf(93);
        if (os_info_start != -1 && os_info_end != -1) {
            return version.substring(os_info_start + 1, os_info_end);
        }
        return null;
    }

    @Nullable
    static String getFullVersion(@Nullable Sdk sdk, @NotNull NullableConsumer<? super String> validationCallback) {
        RubyRunner runner;
        String sdkHome;
        if (validationCallback == null) {
            RubyVersionUtil.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            return null;
        }
        SdkAdditionalData data = sdk.getSdkAdditionalData();
        if (data instanceof RubySdkAdditionalData) {
            RubySdkAdditionalData rubyData = (RubySdkAdditionalData)data;
            String normalizedVersionString = rubyData.getNormalizedVersionString(sdk);
            if (normalizedVersionString != null) {
                return normalizedVersionString;
            }
            sdkHome = rubyData.getInterpreterPath(sdk);
            runner = rubyData.getRunner(null);
        } else {
            sdkHome = sdk.getHomePath();
            assert (sdkHome != null);
            runner = RubyLocalRunner.getRunner(null);
        }
        String fullVersion = null;
        try {
            fullVersion = RubyVersionUtil.getFullVersion(runner, sdkHome, true, validationCallback);
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        if (data instanceof RubySdkAdditionalData && SdkRefresher.isAutoRefreshable(sdk)) {
            String finalVersion = fullVersion;
            RubySdkAdditionalDataBase.modify((Sdk)sdk, rubySdkAdditionalData -> rubySdkAdditionalData.setNormalizedVersionString(finalVersion));
        }
        return fullVersion;
    }

    @Nullable
    public static String getFullVersion(@NotNull RubyRunner runner, @NotNull String sdkHome, boolean doNormalize) throws ExecutionException {
        if (runner == null) {
            RubyVersionUtil.$$$reportNull$$$0(1);
        }
        if (sdkHome == null) {
            RubyVersionUtil.$$$reportNull$$$0(2);
        }
        return RubyVersionUtil.getFullVersion(runner, sdkHome, doNormalize, RubySdkType.DEFAULT_SDK_VALIDATION_CALLBACK);
    }

    @Nullable
    static String getFullVersion(@NotNull RubyRunner runner, @NotNull String sdkHome, boolean doNormalize, @NotNull NullableConsumer<? super String> validationCallback) throws ExecutionException {
        ProcessOutput output2;
        if (runner == null) {
            RubyVersionUtil.$$$reportNull$$$0(3);
        }
        if (sdkHome == null) {
            RubyVersionUtil.$$$reportNull$$$0(4);
        }
        if (validationCallback == null) {
            RubyVersionUtil.$$$reportNull$$$0(5);
        }
        if ((output2 = runner.execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(sdkHome, RUBY_SDK_VERSION_SCRIPT).inSameThreadCancelableUnderProgressIndicator(RubyRunner.DEFAULT_EXECUTION_TIMEOUT, RBundle.message((String)"ruby.fetching.version")))) == null) {
            return null;
        }
        String version = RubyVersionUtil.getSDKVersionByOutput(output2, doNormalize, validationCallback);
        String sdkAttributesText = output2.getStdout();
        String[] versionAndPatchLevel = sdkAttributesText.split("\n");
        if (doNormalize && versionAndPatchLevel.length > 1) {
            String patchLevel = RubyVersionUtil.getPatchLevelFromText(versionAndPatchLevel[1]);
            return !StringUtil.isEmpty((String)patchLevel) ? version + " p" + patchLevel : version;
        }
        return version;
    }

    private static boolean validateSDKVersionOutput(@NotNull ProcessOutput output2, @NotNull NullableConsumer<? super String> validationCallback) {
        String versionText;
        if (output2 == null) {
            RubyVersionUtil.$$$reportNull$$$0(6);
        }
        if (validationCallback == null) {
            RubyVersionUtil.$$$reportNull$$$0(7);
        }
        if ((versionText = output2.getStdout()).contains("JAVA_HOME")) {
            validationCallback.consume((Object)versionText);
            return false;
        }
        if (!StringUtil.isEmpty((String)output2.getStderr())) {
            Object message = output2.getStderr();
            if (((String)message).contains("jdb was unexpected at this time.")) {
                message = (String)message + RBundle.message((String)"sdk.error.old.x64");
            }
            if (output2.getExitCode() != 0 || output2.isTimeout()) {
                validationCallback.consume(message);
                return false;
            }
            LOG.warn("Unexpected output in stderr: " + (String)message);
        }
        return true;
    }

    @Nullable
    static String getSDKVersionByOutput(@NotNull ProcessOutput output2, boolean doNormalize, @NotNull NullableConsumer<? super String> validationCallback) {
        String[] lines;
        if (output2 == null) {
            RubyVersionUtil.$$$reportNull$$$0(8);
        }
        if (validationCallback == null) {
            RubyVersionUtil.$$$reportNull$$$0(9);
        }
        if ((lines = output2.getStdout().split("\n")).length == 0) {
            return null;
        }
        if (!RubyVersionUtil.validateSDKVersionOutput(output2, validationCallback)) {
            return null;
        }
        String versionText = lines[0];
        return doNormalize ? RubyVersionUtil.normalizeSdkVersionText(versionText) : versionText;
    }

    @Nullable
    public static String getPatchLevel(@NotNull RubyRunner runner, @NotNull String sdkHome) throws ExecutionException {
        if (runner == null) {
            RubyVersionUtil.$$$reportNull$$$0(10);
        }
        if (sdkHome == null) {
            RubyVersionUtil.$$$reportNull$$$0(11);
        }
        ProcessOutput output2 = runner.executeInSameThread(RubyRunnerExecutionContext.create(RunnerUtil.collectCommands(sdkHome, GET_PATCHLEVEL_SCRIPT)));
        String patchLevelText = output2.getStdout();
        if (!RubyVersionUtil.validateSDKVersionOutput(output2, RubySdkType.DEFAULT_SDK_VALIDATION_CALLBACK)) {
            return null;
        }
        return RubyVersionUtil.getPatchLevelFromText(patchLevelText);
    }

    @Nullable
    public static String getPatchLevelFromText(String patchLevelText) {
        return TextUtil.isInteger((String)patchLevelText) ? patchLevelText : null;
    }

    public static String getPatchLevel(@NotNull String normalizedVersion) {
        int lastP;
        if (normalizedVersion == null) {
            RubyVersionUtil.$$$reportNull$$$0(12);
        }
        if ((lastP = normalizedVersion.lastIndexOf(112)) > 0) {
            StringBuilder result = new StringBuilder();
            for (int i = lastP + 1; i < normalizedVersion.length() && StringUtil.isDecimalDigit((char)normalizedVersion.charAt(i)); ++i) {
                result.append(normalizedVersion.charAt(i));
            }
            return result.toString();
        }
        return null;
    }

    @ApiStatus.Internal
    @NotNull
    public static LanguageLevel extractLanguageLevelFromVersion(@Nullable String version) {
        String truffleShortVersion;
        LanguageLevel truffleLevel;
        String rubiniusShortVersion;
        LanguageLevel rubiniusLevel;
        if (version == null) {
            LanguageLevel languageLevel = LanguageLevel.latest();
            if (languageLevel == null) {
                RubyVersionUtil.$$$reportNull$$$0(13);
            }
            return languageLevel;
        }
        if (RubyVersionUtil.isRubinius(version) && (rubiniusLevel = RubyVersionUtil.matchVersionToLanguageLevel(rubiniusShortVersion = RubyVersionUtil.getRubiniusShortVersion(version), RUBINIUS_VERSION_AND_LEVEL_DESC)) != null) {
            LanguageLevel languageLevel = rubiniusLevel;
            if (languageLevel == null) {
                RubyVersionUtil.$$$reportNull$$$0(14);
            }
            return languageLevel;
        }
        if (RubyVersionUtil.isTruffle(version) && (truffleLevel = RubyVersionUtil.matchVersionToLanguageLevel(truffleShortVersion = RubyVersionUtil.getTruffleShortVersion(version), TRUFFLE_VERSION_AND_LEVEL_DESC)) != null) {
            LanguageLevel languageLevel = truffleLevel;
            if (languageLevel == null) {
                RubyVersionUtil.$$$reportNull$$$0(15);
            }
            return languageLevel;
        }
        String jRubyShortVersion = JRubySdkUtil.getJRubyShortVersion(version);
        LanguageLevel jRubyLevel = RubyVersionUtil.matchVersionToLanguageLevel(jRubyShortVersion, JRUBY_VERSION_AND_LEVEL_DESC);
        if (jRubyLevel != null) {
            LanguageLevel languageLevel = jRubyLevel;
            if (languageLevel == null) {
                RubyVersionUtil.$$$reportNull$$$0(16);
            }
            return languageLevel;
        }
        String mriShortVersion = RubyVersionUtil.getMriShortVersion(version);
        LanguageLevel mriLevel = RubyVersionUtil.matchVersionToLanguageLevel(mriShortVersion, MRI_VERSION_AND_LEVEL_DESC);
        if (mriLevel != null) {
            LanguageLevel languageLevel = mriLevel;
            if (languageLevel == null) {
                RubyVersionUtil.$$$reportNull$$$0(17);
            }
            return languageLevel;
        }
        if (version.contains("2.0.")) {
            LanguageLevel languageLevel = LanguageLevel.RUBY20;
            if (languageLevel == null) {
                RubyVersionUtil.$$$reportNull$$$0(18);
            }
            return languageLevel;
        }
        if (version.contains("1.9.")) {
            LanguageLevel languageLevel = LanguageLevel.RUBY19;
            if (languageLevel == null) {
                RubyVersionUtil.$$$reportNull$$$0(19);
            }
            return languageLevel;
        }
        if (version.contains("1.8.")) {
            LanguageLevel languageLevel = LanguageLevel.RUBY18;
            if (languageLevel == null) {
                RubyVersionUtil.$$$reportNull$$$0(20);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = LanguageLevel.latest();
        if (languageLevel == null) {
            RubyVersionUtil.$$$reportNull$$$0(21);
        }
        return languageLevel;
    }

    @Nullable
    private static LanguageLevel matchVersionToLanguageLevel(@Nullable String version, @NotNull List<Pair<String, LanguageLevel>> versionAndLevelDesc) {
        if (versionAndLevelDesc == null) {
            RubyVersionUtil.$$$reportNull$$$0(22);
        }
        if (version != null) {
            for (Pair<String, LanguageLevel> versionAndLevel : versionAndLevelDesc) {
                if (VersionComparatorUtil.compare((String)version, (String)((String)versionAndLevel.getFirst())) < 0) continue;
                return (LanguageLevel)versionAndLevel.getSecond();
            }
        }
        return null;
    }

    @ApiStatus.Internal
    @NotNull
    public static LanguageLevel extractLanguageLevelFromRbConfigVersion(@Nullable String version) {
        if (version != null) {
            for (Pair<String, LanguageLevel> versionAndLevel : MRI_VERSION_AND_LEVEL_DESC) {
                String baseVersion = (String)versionAndLevel.getFirst();
                if (!version.startsWith(baseVersion) || VersionComparatorUtil.compare((String)version, (String)baseVersion) < 0) continue;
                LanguageLevel languageLevel = (LanguageLevel)versionAndLevel.getSecond();
                if (languageLevel == null) {
                    RubyVersionUtil.$$$reportNull$$$0(23);
                }
                return languageLevel;
            }
            LOG.debug("Failed to extract language level from RbConfig version: ", new Object[]{version});
        }
        LanguageLevel languageLevel = LanguageLevel.latest();
        if (languageLevel == null) {
            RubyVersionUtil.$$$reportNull$$$0(24);
        }
        return languageLevel;
    }

    @ApiStatus.Internal
    @NotNull
    public static String createFakeVersionStringFromSdkName(@NotNull String sdkName) {
        if (sdkName == null) {
            RubyVersionUtil.$$$reportNull$$$0(25);
        }
        sdkName = StringUtil.trimStart((String)sdkName, (String)"RVM:").trim();
        sdkName = StringUtil.trimStart((String)sdkName, (String)"rbenv:").trim();
        sdkName = StringUtil.trimStart((String)sdkName, (String)"chruby:").trim();
        int spaceAfter = (sdkName = StringUtil.trimStart((String)sdkName, (String)"asdf:").trim()).indexOf(32);
        if (spaceAfter != -1) {
            sdkName = sdkName.substring(0, spaceAfter);
        }
        Object suffix = "";
        int i = sdkName.indexOf("jruby-");
        if (i != -1) {
            Map.Entry<String, String> appropriateMRIVersionEntry = FAKE_JRUBY_VERSIONS_LADDER.floorEntry(sdkName = sdkName.substring(i + 6));
            String mriVersion = appropriateMRIVersionEntry != null ? appropriateMRIVersionEntry.getValue() : "1.1.1";
            suffix = " (" + mriVersion + ") VM";
        } else {
            i = sdkName.indexOf(RUBY_MRI_PREFIX);
            if (i != -1) {
                sdkName = sdkName.substring(i + 5);
            } else {
                i = sdkName.indexOf("rbx-");
                if (i != -1) {
                    String string = "rubinius " + sdkName.substring(i + 4) + " p0";
                    if (string == null) {
                        RubyVersionUtil.$$$reportNull$$$0(26);
                    }
                    return string;
                }
            }
        }
        i = sdkName.indexOf(45);
        if (i > 0) {
            sdkName = sdkName.substring(0, i);
        }
        String string = "ver." + sdkName + "p0" + (String)suffix;
        if (string == null) {
            RubyVersionUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @ApiStatus.Internal
    public static String normalizeSdkVersionText(String rawVersionText) {
        String presentableVersion = rawVersionText.replaceFirst(" patchlevel \\d+\\s*\\)", ")");
        int os_info_start = (presentableVersion = presentableVersion.replace(") (", ", ")).indexOf(91);
        if (os_info_start != -1) {
            presentableVersion = presentableVersion.substring(0, os_info_start);
        }
        presentableVersion = presentableVersion.replaceFirst("\\d{4}-\\d{2}-\\d{2}", "");
        presentableVersion = presentableVersion.replaceAll("\\(\\)", "");
        presentableVersion = presentableVersion.replaceAll("\\s\\s+", " ");
        presentableVersion = presentableVersion.replaceFirst("^j?ruby ", "ver.");
        presentableVersion = presentableVersion.replaceFirst("^IronRuby", "IR");
        presentableVersion = presentableVersion.replaceFirst("\\sversion\\s+", " ver.");
        presentableVersion = presentableVersion.trim();
        return presentableVersion;
    }

    public static boolean isVersionGreaterOrEqual(@NotNull Sdk sdk, @NotNull String requiredVersionString) {
        String versionString;
        if (sdk == null) {
            RubyVersionUtil.$$$reportNull$$$0(28);
        }
        if (requiredVersionString == null) {
            RubyVersionUtil.$$$reportNull$$$0(29);
        }
        if ((versionString = sdk.getVersionString()) == null) {
            return false;
        }
        return VersionComparatorUtil.compare((String)RubyVersionUtil.getShortVersion(versionString), (String)requiredVersionString) >= 0;
    }

    @NotNull
    public static String getShortVersion(@NotNull String version) {
        String mriVersion;
        if (version == null) {
            RubyVersionUtil.$$$reportNull$$$0(30);
        }
        if ((mriVersion = RubyVersionUtil.getMriShortVersion(version)) != null) {
            String string = mriVersion;
            if (string == null) {
                RubyVersionUtil.$$$reportNull$$$0(31);
            }
            return string;
        }
        String jrubyVersion = JRubySdkUtil.getJRubyMRILikeShortVersion(version);
        if (jrubyVersion != null) {
            String string = jrubyVersion;
            if (string == null) {
                RubyVersionUtil.$$$reportNull$$$0(32);
            }
            return string;
        }
        String string = RubyVersionUtil.getRubiniusShortVersion(version);
        if (string == null) {
            RubyVersionUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Contract(value="null->null")
    @Nullable
    public static String getMriShortVersion(@Nullable String version) {
        if (version == null) {
            return null;
        }
        if (!version.startsWith("ver.") || version.contains("VM") || !version.contains("p")) {
            return null;
        }
        return version.substring(4, StringUtil.indexOfAny((String)version, (String)"pr(", (int)4, (int)version.length())).trim();
    }

    @Contract(value="!null->!null")
    @Nullable
    public static String getRubiniusShortVersion(@Nullable String version) {
        if (version == null) {
            return null;
        }
        Matcher matcher = RUBINIUS_VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return version;
    }

    @Contract(value="!null->!null")
    @Nullable
    public static String getTruffleShortVersion(@Nullable String version) {
        if (version == null) {
            return null;
        }
        Matcher matcher = TRUFFLE_VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return version;
    }

    @NotNull
    public static String normalizeVersionForVms(@NotNull String name) {
        if (name == null) {
            RubyVersionUtil.$$$reportNull$$$0(34);
        }
        String string = StringUtil.trimStart((String)name, (String)RUBY_MRI_PREFIX);
        if (string == null) {
            RubyVersionUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    static boolean isIronRuby(@Nullable String version) {
        return version != null && StringUtil.toLowerCase((String)version).contains(IRONRUBY_VERSION_SIGNATURE);
    }

    static boolean isMacRuby(@Nullable String version) {
        return version != null && StringUtil.toLowerCase((String)version).contains(MACRUBY_VERSION_SIGNATURE);
    }

    static boolean isRubinius(@Nullable String version) {
        return version != null && StringUtil.toLowerCase((String)version).contains(RUBINIUS_VERSION_SIGNATURE);
    }

    static boolean isMaglev(@Nullable String version) {
        return version != null && StringUtil.toLowerCase((String)version).contains(MAGLEV_VERSION_SIGNATURE);
    }

    static boolean isTruffle(@Nullable String version) {
        return version != null && StringUtil.toLowerCase((String)version).contains(TRUFFLE_VERSION_SIGNATURE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 26, 27, 31, 32, 33, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validationCallback";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 2: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedVersion";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubyVersionUtil";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionAndLevelDesc";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredVersionString";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubyVersionUtil";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLanguageLevelFromVersion";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLanguageLevelFromRbConfigVersion";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createFakeVersionStringFromSdkName";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortVersion";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeVersionForVms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFullVersion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validateSDKVersionOutput";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSDKVersionByOutput";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPatchLevel";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 35: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "matchVersionToLanguageLevel";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createFakeVersionStringFromSdkName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isVersionGreaterOrEqual";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getShortVersion";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "normalizeVersionForVms";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 26, 27, 31, 32, 33, 35 -> new IllegalStateException(string);
        };
    }
}

