/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurator;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;

public interface RubySdkTransfer {
    public static final Logger LOG = Logger.getInstance(RubySdkTransfer.class);
    public static final String[] SYNC_EXCLUDE_EXTENSIONS = new String[]{"a", "bin", "bundle", "c", "cc", "darwin", "dat", "dll", "dylib", "h", "hh", "inc", "m4", "m4v", "make", "md", "o", "obj", "pdf", "ruby", "so", "ttf", "tt", "txt"};
    public static final String[] SYNC_EXCLUDE_FILENAMES = new String[]{"configure", "rbspy"};

    default public void uploadHelpers() throws ExecutionException {
    }

    public void updateLocalGemsCopy(@NotNull Sdk var1, @NotNull List<PathMappingSettings.PathMapping> var2, @NotNull ProgressIndicator var3) throws RemoteSdkException, InterruptedException;

    @Contract(value="null -> fail")
    @Nullable
    public static RubySdkTransfer from(@Nullable Sdk sdk) {
        RubySdkAdditionalData data = RubySdkAdditionalData.from(sdk);
        if (data == null) {
            throw new IllegalArgumentException("Sdk additional data must not be null. Sdk: " + (sdk != null ? sdk.getVersionString() : "null") + ", data: " + String.valueOf(sdk != null ? sdk.getSdkAdditionalData() : "sdk is null"));
        }
        RubySdkConfigurator<RubySdkAdditionalData> configurator = RubySdkConfigurator.from(data);
        try {
            return configurator.buildSdkTransfer(null, sdk);
        }
        catch (ExecutionException | InterruptedException e) {
            LOG.debug(e);
            return null;
        }
    }

    @NotNull
    default public String getTmpPath() {
        String string = this.getSystemAccessor().getTmpPath();
        if (string == null) {
            RubySdkTransfer.$$$reportNull$$$0(0);
        }
        return string;
    }

    default public char getFileSeparator() {
        return this.getSystemAccessor().getFileSeparator();
    }

    @NotNull
    public RubySdkSystemAccessor getSystemAccessor();

    public void moveFileToLocalPath(@NotNull String var1, String var2, boolean var3, @NotNull ProgressIndicator var4) throws IOException;

    default public void beforeRemoteSdkRemoved(@NotNull Sdk sdk) throws RemoteSdkException {
        if (sdk == null) {
            RubySdkTransfer.$$$reportNull$$$0(1);
        }
    }

    @NotNull
    public static List<String> getSyncExcludeGlobs() {
        List list = ContainerUtil.append((List)ContainerUtil.map((Object[])SYNC_EXCLUDE_EXTENSIONS, ext -> "*." + ext), (Object[])SYNC_EXCLUDE_FILENAMES);
        if (list == null) {
            RubySdkTransfer.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkTransfer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTmpPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkTransfer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncExcludeGlobs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "beforeRemoteSdkRemoved";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

