/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsChangeWatcher;
import org.jetbrains.plugins.ruby.gem.workspace.sync.RubySdkGemLibraryManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySupportProvider;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public final class RubySdkPatcher
implements StartupActivity {
    private static final Map<String, Pair<LanguageLevel, Boolean>> ourPatchedSdks = new HashMap<String, Pair<LanguageLevel, Boolean>>();

    private static void doRefresh(Sdk sdk, Set<String> gemUrls, @Nullable Set<String> loadpath) {
        if (gemUrls == null) {
            return;
        }
        SdkModificator modificator = sdk.getSdkModificator();
        RubySdkPatcher.revalidateRubyStubs(sdk, loadpath, modificator);
        VirtualFile[] roots = modificator.getRoots(OrderRootType.CLASSES);
        WriteAction.run(() -> ((SdkModificator)modificator).commitChanges());
        RubySdkGemLibraryManager.getInstance().refresh();
        for (RubySupportProvider provider : RubySupportProvider.EP_NAME.getExtensionList()) {
            provider.sdkRootsChanged(sdk.getName(), roots);
        }
    }

    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            RubySdkPatcher.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        new Task.Backgroundable(project, RBundle.message((String)"ruby.ide.sdk.patcher.refresh.gem.paths.title"), false){

            public void run(@NotNull ProgressIndicator indicator) {
                Collection<Sdk> firstOrder;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(firstOrder = RubySdkPatcher.prepareFirstOrderSdks(project)).isEmpty()) {
                    RubySdkPatcher.prepareGemRootsAndRefresh(this.myProject, firstOrder, null);
                }
                assert (this.myProject != null) : "Project must not be null here";
                if (this.myProject.isDisposed()) {
                    return;
                }
                HashSet modulesWithMissingGems = new HashSet();
                for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                    if (!RModuleUtil.getInstance().hasRubySupport(module) || module.isDisposed()) continue;
                    GemRequirementsChangeWatcher.getInstance(module).start();
                }
                MessageBusConnection connection = this.myProject.getMessageBus().connect(RubyPluginUtil.getUnloadAwareDisposable(this.myProject));
                connection.subscribe(ModuleListener.TOPIC, (Object)new ModuleListener(){

                    public void modulesAdded(@NotNull Project project, @NotNull List<? extends Module> modules) {
                        if (project == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (modules == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        for (Module module : modules) {
                            if (!RModuleUtil.getInstance().hasRubySupport(module)) continue;
                            GemRequirementsChangeWatcher.getInstance(module).start();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "project";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "modules";
                                break;
                            }
                        }
                        objectArray[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkPatcher$1$1";
                        objectArray[2] = "modulesAdded";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                connection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerListener(){

                    public void facetRemoved(@NotNull Facet facet) {
                        if (facet == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        2.enableRequirementsWatcherIfNeeded(facet);
                    }

                    public void facetAdded(@NotNull Facet facet) {
                        if (facet == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        2.enableRequirementsWatcherIfNeeded(facet);
                    }

                    public void facetConfigurationChanged(@NotNull Facet facet) {
                        if (facet == null) {
                            2.$$$reportNull$$$0(2);
                        }
                        2.enableRequirementsWatcherIfNeeded(facet);
                    }

                    private static void enableRequirementsWatcherIfNeeded(@NotNull Facet<?> facet) {
                        if (facet == null) {
                            2.$$$reportNull$$$0(3);
                        }
                        Module module = facet.getModule();
                        if (RModuleUtil.getInstance().hasRubySupport(module)) {
                            GemRequirementsChangeWatcher.getInstance(module).start();
                        } else {
                            GemRequirementsChangeWatcher.getInstance(module).stop();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "facet";
                        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkPatcher$1$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "facetRemoved";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "facetAdded";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "facetConfigurationChanged";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "enableRequirementsWatcherIfNeeded";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkPatcher$1", "run"));
            }
        }.queue();
    }

    public static void prepareGemRootsAndRefresh(@NotNull Sdk rubySdk, @Nullable Runnable callback) {
        if (rubySdk == null) {
            RubySdkPatcher.$$$reportNull$$$0(1);
        }
        RubySdkPatcher.prepareGemRootsAndRefresh(null, Collections.singleton(rubySdk), callback);
    }

    public static Future<?> prepareGemRootsAndRefreshOnPooledThread(@NotNull Sdk rubySdk, @Nullable Runnable callback) {
        if (rubySdk == null) {
            RubySdkPatcher.$$$reportNull$$$0(2);
        }
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        return ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> RubySdkPatcher.prepareGemRootsAndRefresh(rubySdk, callback), (ProgressIndicator)indicator));
    }

    private static Collection<Sdk> prepareFirstOrderSdks(@NotNull Project project) {
        if (project == null) {
            RubySdkPatcher.$$$reportNull$$$0(3);
        }
        HashSet<Sdk> sdks = new HashSet<Sdk>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            if (sdk == null) continue;
            sdks.add(sdk);
        }
        return sdks;
    }

    private static void prepareGemRootsAndRefresh(@Nullable Project project, @NotNull Collection<Sdk> rubySdks, @Nullable Runnable callback) {
        if (rubySdks == null) {
            RubySdkPatcher.$$$reportNull$$$0(4);
        }
        HashMap<String, Set<String>> urlsMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> loadpathMap = new HashMap<String, Set<String>>();
        int i = 0;
        List uncachedSdks = ContainerUtil.filter(rubySdks, sdk -> sdk != null && !RubySdkPatcher.alreadyCached(sdk));
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setIndeterminate(false);
        }
        int size = uncachedSdks.size();
        for (Sdk rubySdk : uncachedSdks) {
            RbConfig.initIfNecessary(rubySdk);
            rubySdk.getVersionString();
            urlsMap.put(rubySdk.getName(), GemUtil.determineGemUrlsForSDK(rubySdk));
            loadpathMap.put(rubySdk.getName(), RubySdkPatcher.buildLoadpath(rubySdk));
            if (indicator == null) continue;
            indicator.setFraction(1.0 * (double)(++i) / (double)size);
        }
        Runnable runnable = () -> {
            ApplicationManager.getApplication().runWriteAction(() -> {
                Runnable refresher = () -> {
                    for (Sdk rubySdk : uncachedSdks) {
                        RubySdkPatcher.doRefresh(rubySdk, (Set)urlsMap.get(rubySdk.getName()), (Set)loadpathMap.get(rubySdk.getName()));
                    }
                };
                if (project == null || project.isDisposed()) {
                    refresher.run();
                } else {
                    ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(refresher);
                }
            });
            for (Sdk rubySdk : uncachedSdks) {
                ourPatchedSdks.put(rubySdk.getName(), (Pair<LanguageLevel, Boolean>)Pair.create((Object)RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)rubySdk), (Object)RVMSupportUtil.isGlobalGempathIgnored(rubySdk)));
            }
            if (callback != null) {
                callback.run();
            }
        };
        ApplicationManager.getApplication().invokeLater(runnable);
    }

    private static void revalidateRubyStubs(@NotNull Sdk sdk, @Nullable Set<String> loadpath, @NotNull SdkModificator modificator) {
        if (sdk == null) {
            RubySdkPatcher.$$$reportNull$$$0(5);
        }
        if (modificator == null) {
            RubySdkPatcher.$$$reportNull$$$0(6);
        }
        boolean canChangeLanguageLevel = loadpath != null;
        modificator.setVersionString(sdk.getVersionString());
        String correctStubsFolder = RubySdkUtil.getStubsFolderName(sdk);
        boolean foundAppropriateStubs = false;
        if (canChangeLanguageLevel) {
            modificator.removeAllRoots();
        } else {
            for (VirtualFile root : modificator.getRoots(OrderRootType.CLASSES)) {
                String fileName = root.getName();
                if (fileName.equals(correctStubsFolder)) {
                    foundAppropriateStubs = true;
                    continue;
                }
                if (!fileName.startsWith("rubystubs")) continue;
                modificator.removeRoot(root, OrderRootType.CLASSES);
            }
        }
        if (!foundAppropriateStubs) {
            VirtualFile file;
            HashSet<String> stubsUrls = new HashSet<String>();
            RubySdkType.addRubyStubsUrls(stubsUrls, sdk);
            for (String url : stubsUrls) {
                file = VirtualFileManager.getInstance().findFileByUrl(url);
                if (file == null || !file.isValid() || !file.isDirectory()) continue;
                modificator.addRoot(file, OrderRootType.CLASSES);
            }
            if (loadpath != null) {
                for (String url : loadpath) {
                    file = VirtualFileManager.getInstance().findFileByUrl(url);
                    if (file == null || !file.isValid() || !file.isDirectory()) continue;
                    modificator.addRoot(file, OrderRootType.CLASSES);
                }
            }
        }
    }

    @Nullable
    private static Set<String> buildLoadpath(Sdk rubySdk) {
        if (RubySdkUtil.canChangeLanguageLevel(rubySdk)) {
            Pair<LanguageLevel, Boolean> levelAndIgnore = ourPatchedSdks.get(rubySdk.getName());
            LanguageLevel languageLevel = RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)rubySdk);
            if (levelAndIgnore == null || languageLevel != levelAndIgnore.first) {
                return RubySdkType.buildSdkLoadpath(rubySdk);
            }
        }
        return null;
    }

    private static boolean alreadyCached(@NotNull Sdk rubySdk) {
        Pair<LanguageLevel, Boolean> levelAndIgnore;
        if (rubySdk == null) {
            RubySdkPatcher.$$$reportNull$$$0(7);
        }
        return (levelAndIgnore = ourPatchedSdks.get(rubySdk.getName())) != null && RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)rubySdk) == levelAndIgnore.first && RVMSupportUtil.isGlobalGempathIgnored(rubySdk) == (Boolean)levelAndIgnore.second;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubySdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubySdks";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modificator";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkPatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareGemRootsAndRefresh";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareGemRootsAndRefreshOnPooledThread";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareFirstOrderSdks";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "revalidateRubyStubs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "alreadyCached";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

