/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.filters;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;

public final class FileLinksFilterUtil {
    @NonNls
    private static final String EXE_FILE_EXTENSION = "exe";
    public static final int LENGTH_THRESHOLD = 255;
    private static final String rubyExt = "." + RubyFileType.RUBY.getDefaultExtension();
    private static final Map<String, File> resolvedFile = ContainerUtil.createConcurrentSoftValueMap();
    private static final File NOT_FOUND = new File("");

    private FileLinksFilterUtil() {
    }

    @Nullable
    public static File getFileByRubyLink(@NotNull String filePath) {
        if (filePath == null) {
            FileLinksFilterUtil.$$$reportNull$$$0(0);
        }
        return (File)ContainerUtil.getFirstItem(FileLinksFilterUtil.getFileByRubyLink(filePath, Collections.emptyList()));
    }

    @NotNull
    public static List<File> getFileByRubyLink(@NotNull String filePath, @NotNull List<String> workingDirs) {
        if (filePath == null) {
            FileLinksFilterUtil.$$$reportNull$$$0(1);
        }
        if (workingDirs == null) {
            FileLinksFilterUtil.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)filePath)) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                FileLinksFilterUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        File fileForAbsolutePath = FileLinksFilterUtil.searchPath(filePath);
        if (fileForAbsolutePath != null) {
            List<File> list = List.of(fileForAbsolutePath);
            if (list == null) {
                FileLinksFilterUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<File> srcFiles = new ArrayList<File>();
        for (String workingDir : workingDirs) {
            File file;
            if (workingDir == null || (file = FileLinksFilterUtil.searchPath(workingDir + String.valueOf(filePath.charAt(0) == '/' || filePath.charAt(0) == '\\' ? "" : Character.valueOf('/')) + filePath)) == null) continue;
            srcFiles.add(file);
        }
        ContainerUtil.removeDuplicates(srcFiles);
        ArrayList<File> arrayList = srcFiles;
        if (arrayList == null) {
            FileLinksFilterUtil.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public static void clearFileCache() {
        resolvedFile.clear();
    }

    private static File searchPath(String file_path) {
        String normalizedPath = FileUtil.toSystemDependentName((String)file_path);
        File cached = resolvedFile.get(normalizedPath);
        if (cached != null) {
            return cached == NOT_FOUND ? null : cached;
        }
        File srcFile = new File(normalizedPath);
        try {
            boolean isDirectory;
            boolean exists = srcFile.exists();
            boolean bl = isDirectory = exists && srcFile.isDirectory();
            if (!(exists && !isDirectory || StringUtil.endsWithIgnoreCase((String)normalizedPath, (String)rubyExt))) {
                File srcRBFile = new File(normalizedPath + rubyExt);
                exists = srcRBFile.exists();
                isDirectory = srcRBFile.isDirectory();
                srcFile = srcRBFile;
            }
            File result = exists && !isDirectory ? srcFile : null;
            resolvedFile.put(normalizedPath, result == null ? NOT_FOUND : result);
            return result;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static boolean hasExeExtension(@NotNull File srcFile) {
        if (srcFile == null) {
            FileLinksFilterUtil.$$$reportNull$$$0(6);
        }
        return FileUtilRt.extensionEquals((String)srcFile.getName(), (String)EXE_FILE_EXTENSION);
    }

    public static String cutLineIfLong(String line) {
        if (line.length() <= 255) {
            return line;
        }
        return line.substring(0, 256);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirs";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/filters/FileLinksFilterUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/filters/FileLinksFilterUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileByRubyLink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileByRubyLink";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasExeExtension";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

