/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.context;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyAbstractExecutionContext;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyNoSdkInContextException;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;

public abstract class RubySdkAwareExecutionContext<T extends RubySdkAwareExecutionContext>
extends RubyAbstractExecutionContext<T> {
    @NotNull
    private List<String> myArguments;
    @NotNull
    private List<String> myInterpreterArguments;

    public RubySdkAwareExecutionContext(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubySdkAwareExecutionContext.$$$reportNull$$$0(0);
        }
        super(sdk);
        this.myArguments = Collections.emptyList();
        this.myInterpreterArguments = Collections.emptyList();
        this.assertSdkAvailable();
    }

    public RubySdkAwareExecutionContext(@NotNull Module module) {
        if (module == null) {
            RubySdkAwareExecutionContext.$$$reportNull$$$0(1);
        }
        super(module);
        this.myArguments = Collections.emptyList();
        this.myInterpreterArguments = Collections.emptyList();
    }

    public RubySdkAwareExecutionContext(@NotNull RubySdkAwareExecutionContext source) {
        if (source == null) {
            RubySdkAwareExecutionContext.$$$reportNull$$$0(2);
        }
        super(source);
        this.myArguments = Collections.emptyList();
        this.myInterpreterArguments = Collections.emptyList();
        this.withArguments(source.myArguments);
        this.assertSdkAvailable();
    }

    @Override
    @NotNull
    public T withModule(@Nullable Module module) {
        super.withModule(module);
        this.assertSdkAvailable();
        RubySdkAwareExecutionContext rubySdkAwareExecutionContext = (RubySdkAwareExecutionContext)this.self();
        if (rubySdkAwareExecutionContext == null) {
            RubySdkAwareExecutionContext.$$$reportNull$$$0(3);
        }
        return (T)rubySdkAwareExecutionContext;
    }

    @Override
    @NotNull
    public T withProject(@Nullable Project project) {
        super.withProject(project);
        this.assertSdkAvailable();
        RubySdkAwareExecutionContext rubySdkAwareExecutionContext = (RubySdkAwareExecutionContext)this.self();
        if (rubySdkAwareExecutionContext == null) {
            RubySdkAwareExecutionContext.$$$reportNull$$$0(4);
        }
        return (T)rubySdkAwareExecutionContext;
    }

    private void assertSdkAvailable() {
        if (this.calcRubySdk() == null) {
            throw new RubyNoSdkInContextException(this);
        }
    }

    @NotNull
    public List<String> getArguments() {
        List<String> list = this.myArguments;
        if (list == null) {
            RubySdkAwareExecutionContext.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public T withArguments(String ... args) {
        this.myArguments = args.length == 0 ? Collections.emptyList() : Arrays.asList(args);
        RubySdkAwareExecutionContext rubySdkAwareExecutionContext = (RubySdkAwareExecutionContext)this.self();
        if (rubySdkAwareExecutionContext == null) {
            RubySdkAwareExecutionContext.$$$reportNull$$$0(6);
        }
        return (T)rubySdkAwareExecutionContext;
    }

    @NotNull
    public T withArguments(@Nullable Collection<String> args) {
        this.myArguments = args == null || args.isEmpty() ? Collections.emptyList() : new ArrayList<String>(args);
        RubySdkAwareExecutionContext rubySdkAwareExecutionContext = (RubySdkAwareExecutionContext)this.self();
        if (rubySdkAwareExecutionContext == null) {
            RubySdkAwareExecutionContext.$$$reportNull$$$0(7);
        }
        return (T)rubySdkAwareExecutionContext;
    }

    @Override
    @NotNull
    public Sdk getRubySdk() {
        Sdk sdk = this.calcRubySdk();
        assert (sdk != null);
        Sdk sdk2 = sdk;
        if (sdk2 == null) {
            RubySdkAwareExecutionContext.$$$reportNull$$$0(8);
        }
        return sdk2;
    }

    @Nullable
    public Sdk getExplicitSdk() {
        return super.getRubySdk();
    }

    @NotNull
    public List<String> getInterpreterArguments() {
        return new ArrayList<String>(this.myInterpreterArguments);
    }

    @NotNull
    public T withInterpreterArguments(String ... opts) {
        this.myInterpreterArguments = opts.length == 0 ? Collections.emptyList() : Arrays.asList(opts);
        RubySdkAwareExecutionContext rubySdkAwareExecutionContext = (RubySdkAwareExecutionContext)this.self();
        if (rubySdkAwareExecutionContext == null) {
            RubySdkAwareExecutionContext.$$$reportNull$$$0(9);
        }
        return (T)rubySdkAwareExecutionContext;
    }

    @NotNull
    public T withInterpreterArguments(@NotNull Collection<String> opts) {
        if (opts == null) {
            RubySdkAwareExecutionContext.$$$reportNull$$$0(10);
        }
        this.myInterpreterArguments = opts.isEmpty() ? Collections.emptyList() : new ArrayList<String>(opts);
        RubySdkAwareExecutionContext rubySdkAwareExecutionContext = (RubySdkAwareExecutionContext)this.self();
        if (rubySdkAwareExecutionContext == null) {
            RubySdkAwareExecutionContext.$$$reportNull$$$0(11);
        }
        return (T)rubySdkAwareExecutionContext;
    }

    @Nullable
    protected Sdk calcRubySdk() {
        Sdk projectSdk;
        Sdk moduleSdk;
        Sdk explicitSdk = super.getRubySdk();
        if (explicitSdk != null) {
            return explicitSdk;
        }
        if (this.getModule() != null && (moduleSdk = RModuleUtil.getInstance().findRubySdkForModule(this.getModule())) != null) {
            return moduleSdk;
        }
        if (this.getProject() != null && (projectSdk = ProjectRootManager.getInstance((Project)this.getProject()).getProjectSdk()) != null && projectSdk.getSdkType() instanceof RubySdkType) {
            return projectSdk;
        }
        return null;
    }

    @Override
    public T copy() {
        return ((RubySdkAwareExecutionContext)((RubySdkAwareExecutionContext)super.copy()).withArguments(this.myArguments)).withInterpreterArguments(this.myInterpreterArguments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/context/RubySdkAwareExecutionContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/context/RubySdkAwareExecutionContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withModule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withArguments";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubySdk";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "withInterpreterArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "withInterpreterArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9, 11 -> new IllegalStateException(string);
        };
    }
}

