/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.context;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.run.ProjectAwareRubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.run.context.RubySdkAwareExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.ShimsBasedVersionManagerHandler;

public final class RubyScriptExecutionContext
extends RubySdkAwareExecutionContext<RubyScriptExecutionContext> {
    private static final Logger LOG = Logger.getInstance(RubyScriptExecutionContext.class);
    private static final ProcessOutput EMPTY_OUTPUT = new ProcessOutput();
    @NotNull
    private final String myScriptPath;
    private final boolean isGemScript;

    private RubyScriptExecutionContext(@NotNull String scriptPath, @NotNull Sdk sdk) {
        if (scriptPath == null) {
            RubyScriptExecutionContext.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            RubyScriptExecutionContext.$$$reportNull$$$0(1);
        }
        super(sdk);
        this.myScriptPath = scriptPath;
        this.isGemScript = false;
    }

    private RubyScriptExecutionContext(@NotNull String scriptPath, @NotNull RubyGemExecutionContext gemExecutionContext) {
        if (scriptPath == null) {
            RubyScriptExecutionContext.$$$reportNull$$$0(2);
        }
        if (gemExecutionContext == null) {
            RubyScriptExecutionContext.$$$reportNull$$$0(3);
        }
        super(gemExecutionContext);
        this.myScriptPath = scriptPath;
        this.isGemScript = true;
    }

    @NotNull
    public String getScriptPath() {
        String string = this.myScriptPath;
        if (string == null) {
            RubyScriptExecutionContext.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public ProcessOutput executeScript() throws ExecutionException {
        Sdk sdk = this.getRubySdk();
        if (!RunnerUtil.validateSdkWithDialog(sdk)) {
            return EMPTY_OUTPUT;
        }
        return this.getRunner().execute(new RubyRunnerExecutionContext(this, this.getCommandsToRun()));
    }

    @Nullable
    public ProcessHandler createProcessHandler() throws ExecutionException {
        Sdk sdk = this.getRubySdk();
        if (!RunnerUtil.validateSdkWithDialog(sdk)) {
            return null;
        }
        return this.getRunner().createProcessHandler(new RubyRunnerExecutionContext(this, this.getCommandsToRun()), null);
    }

    @NotNull
    private List<String> getCommandsToRun() {
        Sdk sdk = this.getRubySdk();
        ArrayList<String> commands = new ArrayList<String>();
        RubySdkAdditionalData data = this.getSdkAdditionalData();
        RubyVersionManagerHandler versionManagerHandler = RubyVersionManagerHandler.notNullFrom(sdk);
        String interpreterPath = data.getInterpreterPath(sdk);
        if (!ShimsBasedVersionManagerHandler.is(versionManagerHandler)) {
            commands.add(interpreterPath);
            commands.addAll(this.getInterpreterArguments());
        } else if (!this.isGemScript) {
            commands.add(versionManagerHandler.getAdjustedGemScriptPathForExecution(interpreterPath));
            commands.addAll(this.getInterpreterArguments());
        }
        Module module = this.getModule();
        RubyRunner runner = this.getRunner();
        if (module == null && runner instanceof ProjectAwareRubyRunner && this.getProject() != null) {
            ((ProjectAwareRubyRunner)runner).setProject(this.getProject());
        }
        String normalizedScriptPath = this.isGemScript ? versionManagerHandler.getAdjustedGemScriptPathForExecution(this.getScriptPath()) : this.getScriptPath();
        commands.add(RubySdkUtil.convertToRemote(sdk, module, normalizedScriptPath));
        commands.addAll(this.getArguments());
        if (StringUtil.isNotEmpty((String)this.getWorkingDirPath())) {
            this.withWorkingDirPath(RubySdkUtil.convertToRemote(sdk, module, this.getWorkingDirPath()));
        }
        ArrayList<String> arrayList = commands;
        if (arrayList == null) {
            RubyScriptExecutionContext.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private RubyRunner getRunner() {
        RubyRunner rubyRunner = this.getSdkAdditionalData().getRunner(this.getModule());
        if (rubyRunner == null) {
            RubyScriptExecutionContext.$$$reportNull$$$0(6);
        }
        return rubyRunner;
    }

    @NotNull
    private RubySdkAdditionalData getSdkAdditionalData() {
        SdkAdditionalData data = this.getRubySdk().getSdkAdditionalData();
        if (!(data instanceof RubySdkAdditionalData)) {
            throw new IllegalArgumentException("Unexpected type of sdk addition data " + String.valueOf(data));
        }
        RubySdkAdditionalData rubySdkAdditionalData = (RubySdkAdditionalData)data;
        if (rubySdkAdditionalData == null) {
            RubyScriptExecutionContext.$$$reportNull$$$0(7);
        }
        return rubySdkAdditionalData;
    }

    @NotNull
    public static RubyScriptExecutionContext create(@NotNull String scriptPath, @NotNull Sdk sdk) {
        if (scriptPath == null) {
            RubyScriptExecutionContext.$$$reportNull$$$0(8);
        }
        if (sdk == null) {
            RubyScriptExecutionContext.$$$reportNull$$$0(9);
        }
        return new RubyScriptExecutionContext(scriptPath, sdk);
    }

    @Nullable
    public static RubyScriptExecutionContext create(@NotNull RubyGemExecutionContext gemExecutionContext) {
        String scriptPath;
        if (gemExecutionContext == null) {
            RubyScriptExecutionContext.$$$reportNull$$$0(10);
        }
        if ((scriptPath = gemExecutionContext.getScriptPath()) == null) {
            LOG.warn(RBundle.message((String)"execution.error.no.executable.cmd.for.gem.name", (Object[])new Object[]{gemExecutionContext.getGemName(), gemExecutionContext.getGemScriptName()}));
            return null;
        }
        return new RubyScriptExecutionContext(scriptPath, gemExecutionContext);
    }

    @Override
    @NotNull
    protected RubyScriptExecutionContext self() {
        RubyScriptExecutionContext rubyScriptExecutionContext = this;
        if (rubyScriptExecutionContext == null) {
            RubyScriptExecutionContext.$$$reportNull$$$0(11);
        }
        return rubyScriptExecutionContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemExecutionContext";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/context/RubyScriptExecutionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/context/RubyScriptExecutionContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandsToRun";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkAdditionalData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "self";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 11 -> new IllegalStateException(string);
        };
    }
}

