/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.context;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.projectRoots.Sdk;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyAbstractExecutionContext;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyAbstractRunnerExecutionContext;

public class RubyRunnerExecutionContext
extends RubyAbstractRunnerExecutionContext<RubyRunnerExecutionContext> {
    @Nullable
    private String myExecPath;
    @NotNull
    private ParametersList myParams;
    private boolean myPatchWithVersionManager;

    public RubyRunnerExecutionContext() {
        this.myParams = new ParametersList();
        this.myPatchWithVersionManager = true;
    }

    public RubyRunnerExecutionContext(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(0);
        }
        super(sdk);
        this.myParams = new ParametersList();
        this.myPatchWithVersionManager = true;
    }

    public RubyRunnerExecutionContext(@NotNull RubyAbstractExecutionContext source, @NotNull List<String> commands) {
        if (source == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(1);
        }
        if (commands == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(2);
        }
        super(source);
        this.myParams = new ParametersList();
        this.myPatchWithVersionManager = true;
        this.withCommands(commands);
        this.withSdk(source.getRubySdk());
    }

    @NotNull
    public String getExecutablePath() {
        String string = Objects.requireNonNull(this.myExecPath);
        if (string == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public ParametersList getExecutableArguments() {
        ParametersList parametersList = this.myParams;
        if (parametersList == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(4);
        }
        return parametersList;
    }

    @NotNull
    public RubyRunnerExecutionContext withExecutablePath(@NotNull String execPath) {
        if (execPath == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(5);
        }
        this.myExecPath = execPath;
        RubyRunnerExecutionContext rubyRunnerExecutionContext = this;
        if (rubyRunnerExecutionContext == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(6);
        }
        return rubyRunnerExecutionContext;
    }

    @NotNull
    public RubyRunnerExecutionContext withArguments(@NotNull ParametersList params) {
        if (params == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(7);
        }
        this.myParams = params.clone();
        RubyRunnerExecutionContext rubyRunnerExecutionContext = this;
        if (rubyRunnerExecutionContext == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(8);
        }
        return rubyRunnerExecutionContext;
    }

    @NotNull
    public RubyRunnerExecutionContext withArguments(@NotNull List<String> params) {
        if (params == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(9);
        }
        this.myParams = new ParametersList();
        this.myParams.addAll(params);
        RubyRunnerExecutionContext rubyRunnerExecutionContext = this;
        if (rubyRunnerExecutionContext == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(10);
        }
        return rubyRunnerExecutionContext;
    }

    @NotNull
    public RubyRunnerExecutionContext withCommands(@NotNull @NotNull List<@NotNull String> commands) {
        if (commands == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(11);
        }
        if ((commands = new ArrayList<String>(commands)).isEmpty()) {
            throw new IllegalArgumentException("Unable to set empty commands to the context");
        }
        RubyRunnerExecutionContext rubyRunnerExecutionContext = this.withExecutablePath(commands.remove(0)).withArguments(commands);
        if (rubyRunnerExecutionContext == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(12);
        }
        return rubyRunnerExecutionContext;
    }

    @NotNull
    public RubyRunnerExecutionContext withCommands(String ... commands) {
        if (commands == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(13);
        }
        RubyRunnerExecutionContext rubyRunnerExecutionContext = this.withCommands(List.of(commands));
        if (rubyRunnerExecutionContext == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(14);
        }
        return rubyRunnerExecutionContext;
    }

    @NotNull
    public static RubyRunnerExecutionContext create(String ... commands) {
        if (commands == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(15);
        }
        RubyRunnerExecutionContext rubyRunnerExecutionContext = new RubyRunnerExecutionContext().withCommands(commands);
        if (rubyRunnerExecutionContext == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(16);
        }
        return rubyRunnerExecutionContext;
    }

    @NotNull
    public static RubyRunnerExecutionContext create(@NotNull Sdk sdk, String ... commands) {
        if (sdk == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(17);
        }
        if (commands == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(18);
        }
        RubyRunnerExecutionContext rubyRunnerExecutionContext = new RubyRunnerExecutionContext(sdk).withCommands(commands);
        if (rubyRunnerExecutionContext == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(19);
        }
        return rubyRunnerExecutionContext;
    }

    @NotNull
    public static RubyRunnerExecutionContext create(@NotNull List<String> commands) {
        if (commands == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(20);
        }
        RubyRunnerExecutionContext rubyRunnerExecutionContext = new RubyRunnerExecutionContext().withCommands(commands);
        if (rubyRunnerExecutionContext == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(21);
        }
        return rubyRunnerExecutionContext;
    }

    @NotNull
    public static RubyRunnerExecutionContext create(@NotNull Sdk sdk, @NotNull List<String> commands) {
        if (sdk == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(22);
        }
        if (commands == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(23);
        }
        RubyRunnerExecutionContext rubyRunnerExecutionContext = new RubyRunnerExecutionContext(sdk).withCommands(commands);
        if (rubyRunnerExecutionContext == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(24);
        }
        return rubyRunnerExecutionContext;
    }

    @NotNull
    public static RubyRunnerExecutionContext create(@NotNull String execPath, @NotNull ParametersList params) {
        if (execPath == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(25);
        }
        if (params == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(26);
        }
        RubyRunnerExecutionContext rubyRunnerExecutionContext = new RubyRunnerExecutionContext().withExecutablePath(execPath).withArguments(params);
        if (rubyRunnerExecutionContext == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(27);
        }
        return rubyRunnerExecutionContext;
    }

    @NotNull
    public static RubyRunnerExecutionContext create(@NotNull String executablePath, @NotNull List<String> arguments) {
        if (executablePath == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(28);
        }
        if (arguments == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(29);
        }
        RubyRunnerExecutionContext rubyRunnerExecutionContext = new RubyRunnerExecutionContext().withExecutablePath(executablePath).withArguments(arguments);
        if (rubyRunnerExecutionContext == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(30);
        }
        return rubyRunnerExecutionContext;
    }

    public boolean isPatchWithVersionManager() {
        return this.myPatchWithVersionManager;
    }

    public RubyRunnerExecutionContext withPatchWithVersionManager(boolean patchWithVersionManager) {
        this.myPatchWithVersionManager = patchWithVersionManager;
        return this;
    }

    @Override
    @NotNull
    protected RubyRunnerExecutionContext self() {
        RubyRunnerExecutionContext rubyRunnerExecutionContext = this;
        if (rubyRunnerExecutionContext == null) {
            RubyRunnerExecutionContext.$$$reportNull$$$0(31);
        }
        return rubyRunnerExecutionContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 8, 10, 12, 14, 16, 19, 21, 24, 27, 30, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/context/RubyRunnerExecutionContext";
                break;
            }
            case 5: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execPath";
                break;
            }
            case 7: 
            case 9: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/context/RubyRunnerExecutionContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutablePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutableArguments";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withExecutablePath";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "withArguments";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "withCommands";
                break;
            }
            case 16: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "self";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 24: 
            case 27: 
            case 30: 
            case 31: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withExecutablePath";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "withArguments";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "withCommands";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 8, 10, 12, 14, 16, 19, 21, 24, 27, 30, 31 -> new IllegalStateException(string);
        };
    }
}

