/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration.rubyScript;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VfsUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.run.configuration.rubyScript.RubyRunConfiguration;

public class RubyRunCommandLineState
extends RubyAbstractCommandLineState {
    private static final Logger LOG = Logger.getInstance(RubyRunCommandLineState.class);
    @NonNls
    private static final String RUBY_SCRIPT_PARAMS_GROUP_ID = "ruby.run.script";

    public RubyRunCommandLineState(@NotNull RubyRunConfiguration config, @NotNull ExecutionEnvironment env) {
        if (config == null) {
            RubyRunCommandLineState.$$$reportNull$$$0(0);
        }
        if (env == null) {
            RubyRunCommandLineState.$$$reportNull$$$0(1);
        }
        super(config, env, false);
    }

    public RubyRunConfiguration getConfig() {
        return (RubyRunConfiguration)super.getConfig();
    }

    @Override
    protected RubyCommandLineData createRunCommandLine() throws ExecutionException {
        RubyRunConfiguration config = this.getConfig();
        RubyCommandLineData data = RubyRunCommandLineState.createDefaultCommandLine(config, this.getRunnerId());
        RubyCommandLine commandLine = data.getCommandLine();
        RubyRunner runner = (RubyRunner)data.getUserData(RubyCommandLineData.RUNNER_KEY);
        LOG.assertTrue(runner != null);
        ParamsGroup scriptParamsGroup = this.addExecutionScriptGroup(RUBY_SCRIPT_PARAMS_GROUP_ID, data, commandLine, config.getScriptPath());
        RubyRunCommandLineState.addParams(scriptParamsGroup, config.getScriptArgs());
        return data;
    }

    @Override
    public List<Filter> createConsoleMessageFilters() {
        List<Filter> filters = super.createConsoleMessageFilters();
        RubyRunConfiguration config = this.getConfig();
        Project project = config.getProject();
        String workingDir = VfsUtil.getParentDir((String)config.getScriptPath());
        Sdk sdk = config.getSdk();
        RubyRunCommandLineState.addConsoleFilters(filters, project, sdk, workingDir);
        return filters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "config";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "env";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/rubyScript/RubyRunCommandLineState";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

