/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration.remote;

import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.remote.RubyRemoteDebugConfiguration;
import org.jetbrains.plugins.ruby.settings.SettingsExternalizer;

public class RubyRemoteDebugConfigurationExternalizer
extends SettingsExternalizer {
    private static final RubyRemoteDebugConfigurationExternalizer outInstance = new RubyRemoteDebugConfigurationExternalizer();
    @NonNls
    private static final String REMOTE_HOST = "REMOTE_HOST";
    @NonNls
    private static final String PORT = "PORT";
    @NonNls
    private static final String DISPATCHER_PORT = "DISPATCHER_PORT";
    @NonNls
    private static final String REMOTE_ROOT = "REMOTE_ROOT";
    @NonNls
    private static final String LOCAL_ROOT = "LOCAL_ROOT";
    @NonNls
    public static final String RUBY_REMOTE_DEBUG_CONFIG_SETTINGS_ID = "RUBY_REMOTE_DEBUG_CONFIG";

    public void writeExternal(RubyRemoteDebugConfiguration config, Element elem) {
        this.writeOption(REMOTE_HOST, config.getRemoteHost(), elem);
        this.writeOption(PORT, String.valueOf(config.getPort()), elem);
        this.writeOption(DISPATCHER_PORT, String.valueOf(config.getDispatcherPort()), elem);
        this.writeOption(REMOTE_ROOT, config.getRemoteRoot(), elem);
        this.writeOption(LOCAL_ROOT, config.getLocalRoot(), elem);
    }

    public void readExternal(RubyRemoteDebugConfiguration config, Element elem) {
        Map<String, String> optionsByName = this.buildOptionsByElement(elem);
        config.setRemoteHost(optionsByName.get(REMOTE_HOST));
        config.setPort(RunConfigurationUtil.getIntByString(optionsByName.get(PORT), -1));
        String port = optionsByName.get(DISPATCHER_PORT);
        config.setDispatcherPort(port != null ? RunConfigurationUtil.getIntByString(port, -1) : 26162);
        config.setRemoteRoot(optionsByName.get(REMOTE_ROOT));
        config.setLocalRoot(optionsByName.get(LOCAL_ROOT));
    }

    public static RubyRemoteDebugConfigurationExternalizer getInstance() {
        return outInstance;
    }

    @Override
    @NotNull
    public String getID() {
        return RUBY_REMOTE_DEBUG_CONFIG_SETTINGS_ID;
    }
}

