/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyDebuggerSettings;
import org.jetbrains.plugins.ruby.ruby.run.configuration.remote.RubyRemoteDebugConfigurationEditor;
import org.jetbrains.plugins.ruby.ruby.run.configuration.remote.RubyRemoteDebugConfigurationExternalizer;
import org.jetbrains.plugins.ruby.ruby.run.configuration.remote.RubyRemoteDebugConfigurationParams;

public class RubyRemoteDebugConfiguration
extends ModuleBasedConfiguration<RunConfigurationModule, Element>
implements RubyRemoteDebugConfigurationParams,
RunConfigurationWithSuppressedDefaultRunAction {
    private static final Logger LOG = Logger.getInstance(RubyRemoteDebugConfiguration.class);
    private String myRemoteHost;
    private int myPort;
    private int myDispatcherPort;
    private String myRemoteRoot;
    private String myLocalRoot;

    public RubyRemoteDebugConfiguration(Project project, ConfigurationFactory factory) {
        super(new RunConfigurationModule(project), factory);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new RubyRemoteDebugConfigurationEditor(this.getProject(), this);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            RubyRemoteDebugConfiguration.$$$reportNull$$$0(0);
        }
        if (env == null) {
            RubyRemoteDebugConfiguration.$$$reportNull$$$0(1);
        }
        try {
            this.validateConfiguration();
        }
        catch (RuntimeConfigurationWarning e) {
            LOG.warn(e.getMessage());
        }
        catch (RuntimeConfigurationException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        return EmptyRunProfileState.INSTANCE;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.validateConfiguration();
    }

    protected void validateConfiguration() throws RuntimeConfigurationException {
        File localRootFile;
        if (this.getRemoteHost().trim().isEmpty()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.remote.debug.remote.host.not.specified"));
        }
        if (this.getPort() == -1) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.remote.debug.remote.port.not.specified"));
        }
        if (this.getDispatcherPort() == -1 && RubyDebuggerSettings.getInstance().getState().isMultiprocess()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.remote.debug.remote.port.not.specified"));
        }
        if (this.getRemoteRoot().trim().isEmpty()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.remote.debug.remote.root.not.specified"));
        }
        String localRoot = this.getLocalRoot().trim();
        if (localRoot.isEmpty() || !(localRootFile = new File(localRoot)).exists() || !localRootFile.isDirectory()) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.remote.debug.local.root.not.specified"));
        }
    }

    @NotNull
    public List<Module> getValidModules() {
        List<Module> list = Arrays.asList(RModuleUtil.getInstance().getAllModulesWithRubySupport(this.getProject()));
        if (list == null) {
            RubyRemoteDebugConfiguration.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            RubyRemoteDebugConfiguration.$$$reportNull$$$0(3);
        }
        RubyRemoteDebugConfigurationExternalizer.getInstance().readExternal(this, element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            RubyRemoteDebugConfiguration.$$$reportNull$$$0(4);
        }
        RubyRemoteDebugConfigurationExternalizer.getInstance().writeExternal(this, element);
    }

    public static void copyParams(RubyRemoteDebugConfigurationParams fromParams, RubyRemoteDebugConfigurationParams toParams) {
        toParams.setRemoteHost(fromParams.getRemoteHost());
        toParams.setPort(fromParams.getPort());
        toParams.setRemoteRoot(fromParams.getRemoteRoot());
        toParams.setDispatcherPort(fromParams.getDispatcherPort());
        toParams.setLocalRoot(fromParams.getLocalRoot());
    }

    @Override
    public String getRemoteHost() {
        return this.myRemoteHost;
    }

    @Override
    public void setRemoteHost(String remoteHost) {
        this.myRemoteHost = remoteHost;
    }

    @Override
    public int getPort() {
        return this.myPort;
    }

    @Override
    public void setPort(int port) {
        this.myPort = port;
    }

    @Override
    public int getDispatcherPort() {
        return this.myDispatcherPort;
    }

    @Override
    public void setDispatcherPort(int dispatcherPort) {
        this.myDispatcherPort = dispatcherPort;
    }

    @Override
    public String getRemoteRoot() {
        return this.myRemoteRoot;
    }

    @Override
    public void setRemoteRoot(String remoteRoot) {
        this.myRemoteRoot = remoteRoot;
    }

    @Override
    public String getLocalRoot() {
        return this.myLocalRoot;
    }

    @Override
    public void setLocalRoot(String localRoot) {
        this.myLocalRoot = localRoot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/remote/RubyRemoteDebugConfiguration";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/remote/RubyRemoteDebugConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

