/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration.beforeRun;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.Semaphore;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.run.configuration.beforeRun.RakeBeforeRunSettingsDialog;
import org.jetbrains.plugins.ruby.ruby.run.configuration.beforeRun.RakeBeforeRunTask;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyCommandLineExecutionContext;
import org.jetbrains.plugins.ruby.tasks.rake.RakeIcons;
import org.jetbrains.plugins.ruby.tasks.rake.RakeUtil;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunCommandLineState;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfiguration;
import org.jetbrains.plugins.ruby.tasks.rake.runConfigurations.RakeRunConfigurationType;

public final class RakeBeforeRunTaskProvider
extends BeforeRunTaskProvider<RakeBeforeRunTask> {
    public static final Key<RakeBeforeRunTask> ID = Key.create((String)"RakeTask");
    private static final Logger LOG = Logger.getInstance(RakeBeforeRunTaskProvider.class);
    @NonNls
    private static final String RAKE_BEFORE_RUN_NOTIFICATION_GROUP_ID = "rake.before.run";

    public Key<RakeBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return RBundle.message((String)"run.configuration.before.run.rake.description.empty");
    }

    public Icon getIcon() {
        return RakeIcons.RAKE_RUN_CONFIGURATION_ICON;
    }

    public Icon getTaskIcon(RakeBeforeRunTask task) {
        return RakeIcons.RAKE_RUN_CONFIGURATION_ICON;
    }

    public String getDescription(@NotNull RakeBeforeRunTask task) {
        if (task == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        String taskFullCmd = task.getFullCmd();
        return RBundle.message((String)"run.configuration.before.run.rake.description", (Object[])new Object[]{taskFullCmd != null ? taskFullCmd : "<not selected>"});
    }

    public boolean isConfigurable() {
        return true;
    }

    public RakeBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        return new RakeBeforeRunTask();
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull RakeBeforeRunTask task) {
        String fullCmd;
        if (runConfiguration == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        if (task == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(fullCmd = RakeBeforeRunSettingsDialog.showDialog(runConfiguration.getProject(), RakeBeforeRunTaskProvider.getModule(runConfiguration), task.getFullCmd())))) {
            task.setFullCmd(null);
            return false;
        }
        task.setFullCmd(fullCmd);
        return true;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull RakeBeforeRunTask task) {
        if (configuration == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        if (task == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(5);
        }
        String taskFullCmd = task.getFullCmd();
        Module module = RakeBeforeRunTaskProvider.getModule(configuration);
        return taskFullCmd != null && module != null;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull RakeBeforeRunTask task) {
        String taskFullCmd;
        if (context == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(6);
        }
        if (configuration == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(7);
        }
        if (env == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(8);
        }
        if (task == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(9);
        }
        if ((taskFullCmd = task.getFullCmd()) == null) {
            return true;
        }
        Module module = RakeBeforeRunTaskProvider.getModule(configuration);
        if (module == null) {
            Notifications.Bus.notify((Notification)new Notification(RAKE_BEFORE_RUN_NOTIFICATION_GROUP_ID, RBundle.message((String)"run.configuration.before.run.rake.error.dialog.title"), RBundle.message((String)"run.configuration.before.run.rake.error.dialog.module.not.specified"), NotificationType.ERROR));
            return false;
        }
        RunnerAndConfigurationSettings rakeConfSettings = RakeUtil.findExistingRakeRunConfFor(module, taskFullCmd);
        if (rakeConfSettings == null) {
            RunManager runManager = RunManager.getInstance((Project)module.getProject());
            Ref settingsRef = new Ref();
            ApplicationManager.getApplication().runReadAction(() -> {
                RunnerAndConfigurationSettings settings = RakeRunConfigurationType.getInstance().getRakeFactory().createConfigurationSettings(module, taskFullCmd, ArrayUtilRt.EMPTY_STRING_ARRAY, Collections.emptyMap());
                runManager.setTemporaryConfiguration(settings);
                settingsRef.set((Object)settings);
            });
            rakeConfSettings = (RunnerAndConfigurationSettings)settingsRef.get();
        }
        if (rakeConfSettings != null) {
            return RakeBeforeRunTaskProvider.runRakeTask(module, taskFullCmd, rakeConfSettings, configuration.getName());
        }
        return false;
    }

    @Nullable
    private static Module getModule(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(10);
        }
        RunConfigurationModule runConfigurationModule = runConfiguration instanceof ModuleBasedConfiguration ? ((ModuleBasedConfiguration)runConfiguration).getConfigurationModule() : null;
        return runConfigurationModule != null ? runConfigurationModule.getModule() : null;
    }

    private static boolean runRakeTask(@NotNull Module module, @NotNull String taskFullCmd, @NotNull RunnerAndConfigurationSettings rakeRunnerAndConfSettings, @NotNull String mainRunConfigurationName) {
        if (module == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(11);
        }
        if (taskFullCmd == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(12);
        }
        if (rakeRunnerAndConfSettings == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(13);
        }
        if (mainRunConfigurationName == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(14);
        }
        try {
            RakeRunConfiguration rakeConf = (RakeRunConfiguration)rakeRunnerAndConfSettings.getConfiguration();
            RubyCommandLineData data = RakeRunCommandLineState.createCommandLine(rakeConf, "RubyProgramRunner", false);
            RubyCommandLine cmdLine = data.getCommandLine();
            Sdk sdk = rakeConf.getSdk();
            assert (sdk != null);
            return RakeBeforeRunTaskProvider.runTaskInBGSynchronously(module, taskFullCmd, cmdLine, mainRunConfigurationName, sdk);
        }
        catch (ExecutionException e) {
            RakeBeforeRunTaskProvider.executionError(module, e);
            return false;
        }
    }

    private static boolean runTaskInBGSynchronously(final @NotNull Module module, final String taskFullCmd, final RubyCommandLine cmdLine, @NotNull String mainRunConfigName, final @NotNull Sdk sdk) {
        if (module == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(15);
        }
        if (mainRunConfigName == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(16);
        }
        if (sdk == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(17);
        }
        final Semaphore targetDone = new Semaphore();
        final Ref result = new Ref((Object)false);
        try {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (module.isDisposed()) {
                    result.set((Object)false);
                    return;
                }
                FileDocumentManager.getInstance().saveAllDocuments();
                targetDone.down();
                String title = RBundle.message((String)"run.configuration.before.run.rake.execution.bg.title.main", (Object[])new Object[]{mainRunConfigName});
                new Task.Backgroundable(module.getProject(), title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        try {
                            String title2 = RBundle.message((String)"run.configuration.before.run.rake.execution.bg.title.second", (Object[])new Object[]{taskFullCmd});
                            ExecutionModes.SameThreadMode mode = new ExecutionModes.SameThreadMode(false, title2, -1);
                            mode.addProcessListener(new ProcessListener(){

                                public void processTerminated(@NotNull ProcessEvent event) {
                                    if (event == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    targetDone.up();
                                    result.set((Object)true);
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/run/configuration/beforeRun/RakeBeforeRunTaskProvider$1$1", "processTerminated"));
                                }
                            });
                            ProcessOutput output2 = RunnerUtil.getRunner(sdk, module).execute(RubyCommandLineExecutionContext.create(cmdLine, module.getProject(), (ExecutionMode)mode));
                            String tabName = RBundle.message((String)"run.configuration.before.run.rake.messages.tab.title", (Object[])new Object[]{taskFullCmd});
                            assert (output2 != null);
                            ExecutionHelper.showOutput((Project)module.getProject(), (ProcessOutput)output2, (String)tabName, null, (boolean)false);
                        }
                        catch (ExecutionException e) {
                            ApplicationManager.getApplication().invokeLater(() -> RakeBeforeRunTaskProvider.executionError(module, e));
                            result.set((Object)false);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/ruby/run/configuration/beforeRun/RakeBeforeRunTaskProvider$1", "run"));
                    }
                }.queue();
            }, ModalityState.nonModal());
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return true;
        }
        targetDone.waitFor();
        return (Boolean)result.get();
    }

    private static void executionError(@NotNull Module module, ExecutionException e) {
        if (module == null) {
            RakeBeforeRunTaskProvider.$$$reportNull$$$0(18);
        }
        Messages.showErrorDialog((Project)module.getProject(), (String)e.getMessage(), (String)RBundle.message((String)"run.configuration.before.run.rake.error.dialog.title"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskFullCmd";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rakeRunnerAndConfSettings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainRunConfigurationName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainRunConfigName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/beforeRun/RakeBeforeRunTaskProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createTask";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "configureTask";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "canExecuteTask";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTask";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getModule";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "runRakeTask";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "runTaskInBGSynchronously";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "executionError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

