/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.Platform;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.settings.RSupportPerModuleSettings;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public final class RunConfigurationUtil {
    private static final Logger LOG = Logger.getInstance(RunConfigurationUtil.class);
    @NotNull
    @NonNls
    public static final String LOAD_PATH_ROOTS_PARAMS_GROUP_ID = "ruby.load.path.roots";

    private RunConfigurationUtil() {
    }

    public static RunnerAndConfigurationSettings createSettings(Project project, ConfigurationFactory factory, String name) {
        return RunManager.getInstance((Project)project).createConfiguration(name, factory);
    }

    public static String collectArguments(String[] args) {
        return StringUtil.join((String[])args, (String)" ");
    }

    public static void inspectWorkingDirectory(boolean allowEmptyWorkDir, AbstractRubyRunConfigurationParams conf) throws RuntimeConfigurationError {
        RunConfigurationUtil.inspectWorkingDirectory(allowEmptyWorkDir, conf.getWorkingDirectory());
    }

    private static void inspectWorkingDirectory(boolean allowEmptyWorkDir, @Nullable String workingDirectory) throws RuntimeConfigurationError {
        if (workingDirectory != null && !workingDirectory.trim().isEmpty()) {
            File workDir = new File(workingDirectory);
            if (!workDir.exists()) {
                throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.working.directory.not.exists"));
            }
            if (!workDir.isDirectory()) {
                throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.working.directory.error"));
            }
        } else if (allowEmptyWorkDir) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.working.directory.not.specified"));
        }
    }

    public static void inspectSDK(AbstractRubyRunConfiguration conf) throws RuntimeConfigurationError {
        Sdk sdk = conf.getSdk();
        if (sdk == null) {
            throw new RuntimeConfigurationError(RBundle.message((String)"jdk.no.specified"));
        }
        if (!RubySdkUtil.isRubySDK(sdk)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"jdk.type.incorrect"));
        }
        if (!RubySdkUtil.isRubyInterpreterExist(sdk)) {
            throw new RuntimeConfigurationError(RBundle.message((String)"sdk.error.home.path.doesnt.exists", (Object[])new Object[]{sdk.getHomePath(), sdk}));
        }
    }

    public static void setRailsDefaultTestEnvironment(@NotNull AbstractRubyRunConfiguration conf, @Nullable Module module) {
        if (conf == null) {
            RunConfigurationUtil.$$$reportNull$$$0(0);
        }
        RunConfigurationUtil.setRailsTestEnvironment(conf, module, "test");
    }

    public static void setRailsTestEnvironment(@NotNull AbstractRubyRunConfigurationParams conf, @Nullable Module module, @NotNull String envName) {
        if (conf == null) {
            RunConfigurationUtil.$$$reportNull$$$0(1);
        }
        if (envName == null) {
            RunConfigurationUtil.$$$reportNull$$$0(2);
        }
        if (module != null && RailsFacetUtil.hasRailsSupport(module)) {
            Map<String, String> envs = conf.getEnvs();
            envs.putIfAbsent("RAILS_ENV", envName);
        }
    }

    public static int getIntByString(String value, int errorValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return errorValue;
        }
    }

    public static String getStringByInt(int value, int errorValue, String errorString) {
        return value != errorValue ? String.valueOf(value) : errorString;
    }

    public static void executeConfiguration(@NotNull RunManager runManager, @NotNull RunnerAndConfigurationSettings confSettings, @Nullable ProgramRunner.Callback executionCallback) {
        ExecutionEnvironment environment;
        if (runManager == null) {
            RunConfigurationUtil.$$$reportNull$$$0(3);
        }
        if (confSettings == null) {
            RunConfigurationUtil.$$$reportNull$$$0(4);
        }
        runManager.setSelectedConfiguration(confSettings);
        try {
            environment = ExecutionEnvironmentBuilder.create((Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunnerAndConfigurationSettings)confSettings).build(executionCallback);
        }
        catch (ExecutionException ignored) {
            return;
        }
        try {
            environment.getRunner().execute(environment);
        }
        catch (ExecutionException e) {
            Messages.showErrorDialog((Project)confSettings.getConfiguration().getProject(), (String)e.getMessage(), (String)ExecutionBundle.message((String)"error.common.title", (Object[])new Object[0]));
        }
    }

    @NotNull
    public static String argsToString(String @NotNull [] args) {
        if (args == null) {
            RunConfigurationUtil.$$$reportNull$$$0(5);
        }
        String string = ParametersList.join((String[])args);
        if (string == null) {
            RunConfigurationUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static void writeLauncherArgsToEnv(@NotNull RubySdkSystemAccessor accessor, @NotNull Map<String, String> envMap, @NotNull GeneralCommandLine commandLine) {
        if (accessor == null) {
            RunConfigurationUtil.$$$reportNull$$$0(7);
        }
        if (envMap == null) {
            RunConfigurationUtil.$$$reportNull$$$0(8);
        }
        if (commandLine == null) {
            RunConfigurationUtil.$$$reportNull$$$0(9);
        }
        Platform platform = accessor.isWindows() ? Platform.WINDOWS : Platform.UNIX;
        envMap.put("INTELLIJ_IDEA_RUN_CONF_LAUNCHER_CMDLINE", commandLine.getPreparedCommandLine(platform));
    }

    public static void addPortForwarding(@NotNull RubyCommandLineData data, @NotNull PortForwarding forwarding) {
        ArrayList<PortForwarding> portForwardings;
        if (data == null) {
            RunConfigurationUtil.$$$reportNull$$$0(10);
        }
        if (forwarding == null) {
            RunConfigurationUtil.$$$reportNull$$$0(11);
        }
        if ((portForwardings = (ArrayList<PortForwarding>)data.getUserData(RubyCommandLineData.PORT_FORWARDING_KEY)) == null) {
            portForwardings = new ArrayList<PortForwarding>();
        }
        portForwardings.add(forwarding);
        data.putUserData(RubyCommandLineData.PORT_FORWARDING_KEY, portForwardings);
    }

    static void includeUserDefinedLoadPathRoots(@NotNull RubyCommandLine cmdLine, @Nullable Module module) {
        RSupportPerModuleSettings moduleSettings;
        block5: {
            block4: {
                if (cmdLine == null) {
                    RunConfigurationUtil.$$$reportNull$$$0(12);
                }
                if (!Experiments.getInstance().isFeatureEnabled("ruby.include.user.defined.loadpath.roots")) break block4;
                moduleSettings = (RSupportPerModuleSettings)ObjectUtils.doIfNotNull((Object)module, RModuleUtil.getInstance()::getRubyModuleSettings);
                if (moduleSettings != null) break block5;
            }
            return;
        }
        cmdLine.getParametersList().addParamsGroupAt(0, LOAD_PATH_ROOTS_PARAMS_GROUP_ID).addParameters(ContainerUtil.map(moduleSettings.getLoadPaths(), "-I"::concat));
    }

    public static void setRailsWorkingDirectoryIfNecessary(@NotNull AbstractRubyRunConfigurationParams runConfig, @NotNull VirtualFile file, @NotNull Project project, @Nullable Module module) {
        if (runConfig == null) {
            RunConfigurationUtil.$$$reportNull$$$0(13);
        }
        if (file == null) {
            RunConfigurationUtil.$$$reportNull$$$0(14);
        }
        if (project == null) {
            RunConfigurationUtil.$$$reportNull$$$0(15);
        }
        RunConfigurationUtil.setWorkingDirectoryIfNecessary(runConfig, file, project, module, null);
    }

    public static void setRspecWorkingDirectoryIfNecessary(@NotNull AbstractRubyRunConfigurationParams runConfig, @NotNull VirtualFile file, @NotNull Project project, @Nullable Module module) {
        if (runConfig == null) {
            RunConfigurationUtil.$$$reportNull$$$0(16);
        }
        if (file == null) {
            RunConfigurationUtil.$$$reportNull$$$0(17);
        }
        if (project == null) {
            RunConfigurationUtil.$$$reportNull$$$0(18);
        }
        RunConfigurationUtil.setWorkingDirectoryIfNecessary(runConfig, file, project, module, "spec");
    }

    public static void setCucumberWorkingDirectoryIfNecessary(@NotNull AbstractRubyRunConfigurationParams runConfig, @NotNull VirtualFile file, @NotNull Project project, @Nullable Module module) {
        if (runConfig == null) {
            RunConfigurationUtil.$$$reportNull$$$0(19);
        }
        if (file == null) {
            RunConfigurationUtil.$$$reportNull$$$0(20);
        }
        if (project == null) {
            RunConfigurationUtil.$$$reportNull$$$0(21);
        }
        RunConfigurationUtil.setWorkingDirectoryIfNecessary(runConfig, file, project, module, "features");
    }

    private static void setWorkingDirectoryIfNecessary(@NotNull AbstractRubyRunConfigurationParams runConfig, @NotNull VirtualFile file, @NotNull Project project, @Nullable Module module, @Nullable String baseDirName) {
        if (runConfig == null) {
            RunConfigurationUtil.$$$reportNull$$$0(22);
        }
        if (file == null) {
            RunConfigurationUtil.$$$reportNull$$$0(23);
        }
        if (project == null) {
            RunConfigurationUtil.$$$reportNull$$$0(24);
        }
        if (StringUtil.isEmptyOrSpaces((String)runConfig.getWorkingDirectory())) {
            String workDir = RunConfigurationUtil.suggestWorkingDirectory(file, project, module, baseDirName);
            LOG.debug("Default working directory for running a file '", new Object[]{file.getPresentableUrl(), "' is set to: ", workDir});
            runConfig.setWorkingDirectory(workDir);
        }
    }

    @Nullable
    private static String suggestWorkingDirectory(@NotNull VirtualFile file, @NotNull Project project, @Nullable Module module, @Nullable String baseDirName) {
        if (file == null) {
            RunConfigurationUtil.$$$reportNull$$$0(25);
        }
        if (project == null) {
            RunConfigurationUtil.$$$reportNull$$$0(26);
        }
        if (module == null || ScratchUtil.isScratch((VirtualFile)file)) {
            return RunConfigurationUtil.suggestWorkingDirectoryForProject(project);
        }
        if (RailsFacetUtil.hasRailsSupport(module)) {
            return RunConfigurationUtil.suggestWorkingDirectoryForRailsApp(module);
        }
        if (baseDirName == null) {
            return RunConfigurationUtil.suggestWorkingDirectoryForFileAndModule(file, module);
        }
        String workDir = RunConfigurationUtil.suggestWorkingDirectoryFromBaseDirectory(file, project, baseDirName);
        return workDir != null ? workDir : RunConfigurationUtil.suggestWorkingDirectoryForFileAndModule(file, module);
    }

    @Nullable
    private static String suggestWorkingDirectoryForProject(@NotNull Project project) {
        if (project == null) {
            RunConfigurationUtil.$$$reportNull$$$0(27);
        }
        LOG.debug("Suggesting a working directory for ", new Object[]{project});
        Module rubyModule = (Module)ArrayUtil.getFirstElement((Object[])RModuleUtil.getInstance().getAllModulesWithRubySupport(project));
        VirtualFile root = RModuleUtil.getInstance().getFirstContentRoot(rubyModule);
        return root != null ? root.getPath() : project.getBasePath();
    }

    @Nullable
    private static String suggestWorkingDirectoryForRailsApp(@NotNull Module module) {
        if (module == null) {
            RunConfigurationUtil.$$$reportNull$$$0(28);
        }
        LOG.debug("Suggesting a working directory for Rails app in ", new Object[]{module});
        return RailsFacetUtil.getRailsAppHomeDirPath(module);
    }

    @Nullable
    private static String suggestWorkingDirectoryFromBaseDirectory(@NotNull VirtualFile file, @NotNull Project project, @NotNull String baseDirName) {
        if (file == null) {
            RunConfigurationUtil.$$$reportNull$$$0(29);
        }
        if (project == null) {
            RunConfigurationUtil.$$$reportNull$$$0(30);
        }
        if (baseDirName == null) {
            RunConfigurationUtil.$$$reportNull$$$0(31);
        }
        LOG.debug("Suggesting a working directory for ", new Object[]{file, " based on directory '", baseDirName, "'"});
        VirtualFile baseDir = VirtualFileUtil.findAncestorByName(file, baseDirName, project);
        VirtualFile baseDirParent = VirtualFileUtil.getDirectAncestor(baseDir, project);
        return baseDirParent != null ? baseDirParent.getPath() : null;
    }

    @Nullable
    private static String suggestWorkingDirectoryForFileAndModule(@NotNull VirtualFile file, @NotNull Module module) {
        if (file == null) {
            RunConfigurationUtil.$$$reportNull$$$0(32);
        }
        if (module == null) {
            RunConfigurationUtil.$$$reportNull$$$0(33);
        }
        LOG.debug("Suggesting a working directory for ", new Object[]{file, " inside ", module});
        VirtualFile contentRoot = ProjectFileIndex.getInstance((Project)module.getProject()).getContentRootForFile(file);
        return contentRoot != null ? contentRoot.getPath() : module.getProject().getBasePath();
    }

    public static void validateIpAddress(@NotNull String ip_str) throws RuntimeConfigurationError {
        if (ip_str == null) {
            RunConfigurationUtil.$$$reportNull$$$0(34);
        }
        String msgKey = "run.configuration.script.ip.bad.format";
        StringTokenizer st = new StringTokenizer(ip_str, ".", true);
        if (st.countTokens() != 7) {
            throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.script.ip.bad.format"));
        }
        RunConfigurationUtil.checkNumberFormat(st.nextToken(), true, "run.configuration.script.ip.bad.format");
        RunConfigurationUtil.checkPoint(st.nextToken());
        RunConfigurationUtil.checkNumberFormat(st.nextToken(), true, "run.configuration.script.ip.bad.format");
        RunConfigurationUtil.checkPoint(st.nextToken());
        RunConfigurationUtil.checkNumberFormat(st.nextToken(), true, "run.configuration.script.ip.bad.format");
        RunConfigurationUtil.checkPoint(st.nextToken());
        RunConfigurationUtil.checkNumberFormat(st.nextToken(), true, "run.configuration.script.ip.bad.format");
    }

    public static void validatePort(@NotNull String port) throws RuntimeConfigurationError {
        if (port == null) {
            RunConfigurationUtil.$$$reportNull$$$0(35);
        }
        RunConfigurationUtil.checkNumberFormat(port, false, "run.configuration.script.port.bad.format");
    }

    private static void checkNumberFormat(@NotNull String port_str, boolean isByte, String msgKey) throws RuntimeConfigurationError {
        int port;
        if (port_str == null) {
            RunConfigurationUtil.$$$reportNull$$$0(36);
        }
        try {
            port = Integer.parseInt(port_str);
        }
        catch (NumberFormatException e) {
            throw new RuntimeConfigurationError(RBundle.message((String)msgKey));
        }
        if (port < 0 || port > (isByte ? 255 : 65535)) {
            throw new RuntimeConfigurationError(RBundle.message((String)msgKey));
        }
    }

    private static void checkPoint(String port_str) throws RuntimeConfigurationError {
        if (port_str.equals(".")) {
            return;
        }
        throw new RuntimeConfigurationError(RBundle.message((String)"run.configuration.script.ip.bad.format"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "confSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RunConfigurationUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envMap";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwarding";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 13: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfig";
                break;
            }
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 25: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ip_str";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "port";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "port_str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RunConfigurationUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "argsToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setRailsDefaultTestEnvironment";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setRailsTestEnvironment";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "argsToString";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeLauncherArgsToEnv";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addPortForwarding";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "includeUserDefinedLoadPathRoots";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setRailsWorkingDirectoryIfNecessary";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setRspecWorkingDirectoryIfNecessary";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setCucumberWorkingDirectoryIfNecessary";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setWorkingDirectoryIfNecessary";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "suggestWorkingDirectory";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "suggestWorkingDirectoryForProject";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "suggestWorkingDirectoryForRailsApp";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "suggestWorkingDirectoryFromBaseDirectory";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "suggestWorkingDirectoryForFileAndModule";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "validateIpAddress";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "validatePort";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkNumberFormat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

