/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RFileImpl;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtensionsManager;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationType;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunnableScriptFilter;
import org.jetbrains.plugins.ruby.ruby.run.configuration.rubyScript.RubyRunConfiguration;

public final class RubyRunConfigurationProducer
extends LazyRunConfigurationProducer<RubyRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        RubyRunConfigurationType.RubyRunConfigurationFactory rubyRunConfigurationFactory = RubyRunConfigurationType.getInstance().getRubyScriptFactory();
        if (rubyRunConfigurationFactory == null) {
            RubyRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return rubyRunConfigurationFactory;
    }

    public boolean isConfigurationFromContext(@NotNull RubyRunConfiguration configuration, @NotNull ConfigurationContext context) {
        VirtualFile virtualFile;
        if (configuration == null) {
            RubyRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            RubyRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)context.getPsiLocation())) == null || !configuration.getScriptPath().trim().equals(virtualFile.getPath().trim())) {
            return false;
        }
        return configuration.getScriptArgs().trim().isEmpty();
    }

    protected boolean setupConfigurationFromContext(@NotNull RubyRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiFile psiFile;
        if (configuration == null) {
            RubyRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            RubyRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (sourceElement == null) {
            RubyRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (!((psiFile = ((PsiElement)sourceElement.get()).getContainingFile()) instanceof RFileImpl)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module != null && RModuleUtil.getInstance().hasRubySupport(module) && RunnableScriptFilter.EP_NAME.findFirstSafe(filter -> !filter.isRunnableScript(psiFile, module)) != null) {
            return false;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        configuration.setName(virtualFile.getNameWithoutExtension());
        configuration.setModule(module);
        configuration.setScriptPath(virtualFile.getPath());
        RunConfigurationUtil.setRailsWorkingDirectoryIfNecessary(configuration, virtualFile, psiFile.getProject(), module);
        Location location = context.getLocation();
        if (location != null) {
            RubyRunConfigurationExtensionsManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration, location);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RubyRunConfigurationProducer";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/RubyRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

