/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration;

import com.intellij.DynamicBundle;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.util.PathMappingsComponent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.run.RailsRunConfigurationExtension;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUIUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.ui.RubySdkRenderer;
import org.jetbrains.plugins.ruby.utils.RubyUIUtil;

public class RubyCommonRunParamsEditor
implements PanelWithAnchor {
    private JRadioButton myUseModuleSdkRB;
    private JRadioButton myUseAlternativeSdkGemRB;
    private JComboBox myAlternativeSdksComboBox;
    private ModulesComboBox myModulesComboBox;
    private JPanel myMainPanel;
    private LabeledComponent myRubyArgsComponent;
    private RawCommandLineEditor myRubyArgsEditor;
    private JComponent myAnchor;
    private EnvironmentVariablesComponent myEnvVariablesComponent;
    private JBLabel myWorkDirLabel;
    private TextFieldWithBrowseButton myWorkDirTextField;
    private JBLabel myRubySDKJBLabel;
    private JLabel myProjectSdkLabel;
    private PathMappingsComponent myPathMappings;
    private JBCheckBox myUseRailsRunner;
    private final List<ChangeListener> myModuleChangeListeners;
    private final List<ChangeListener> mySDKChangeListeners;
    private final Project myProject;

    public RubyCommonRunParamsEditor(AbstractRubyRunConfiguration configuration) {
        this.$$$setupUI$$$();
        this.myModuleChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.mySDKChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = configuration.getProject();
        Collection validModules = configuration.getValidModules();
        Module selection = !validModules.isEmpty() ? (Module)validModules.get(0) : null;
        this.myModulesComboBox.setModules(validModules);
        this.myModulesComboBox.setSelectedModule(selection);
        this.myAlternativeSdksComboBox.setModel(RubyUIUtil.createSdkComboBoxModel(RubySdkType.getAllValidRubySdks(), null));
        this.myUseAlternativeSdkGemRB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean useAlternativeSDK = RubyCommonRunParamsEditor.this.shouldUseAlternativeSdk();
                RubyCommonRunParamsEditor.this.myAlternativeSdksComboBox.setEnabled(useAlternativeSDK);
                RubyCommonRunParamsEditor.this.myModulesComboBox.setEnabled(!useAlternativeSDK);
                RubyCommonRunParamsEditor.this.fireSdkChanged(RubyCommonRunParamsEditor.this.myUseAlternativeSdkGemRB);
            }
        });
        this.setShouldUseAlternativeSdk(false);
        boolean inRubyMine = PlatformUtils.isRubyMine();
        boolean isMultiProject = ProjectAttachProcessor.canAttachToProject();
        this.myModulesComboBox.setVisible(!inRubyMine || isMultiProject);
        this.myProjectSdkLabel.setVisible(inRubyMine && !isMultiProject);
        if (inRubyMine) {
            Sdk sdk = configuration.getModuleSdk();
            this.myUseModuleSdkRB.setText(RBundle.message((String)"run.configuration.messages.select.module.rubymine"));
            this.myProjectSdkLabel.setText(RubySdkRenderer.getSdkText(sdk, false, true));
            this.myUseModuleSdkRB.setToolTipText(RubySdkRenderer.getSdkText(sdk));
            this.myProjectSdkLabel.setBorder(new EmptyBorder(0, 5, 0, 0));
        }
        boolean enabled = inRubyMine && RailsRunConfigurationExtension.canEnableRailsRunner(configuration);
        this.myUseRailsRunner.setVisible(enabled);
        this.myUseRailsRunner.setEnabled(enabled);
        this.myUseRailsRunner.addChangeListener(e -> {
            Object source = e.getSource();
            if (source instanceof JBCheckBox) {
                this.myWorkDirTextField.setEnabled(!((JBCheckBox)source).isSelected());
            }
        });
        String title = RBundle.message((String)"run.configuration.messages.select.working.dir");
        RunConfigurationUIUtil.addFolderChooser(title, this.myWorkDirTextField, configuration.getProject());
        this.myModulesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RubyCommonRunParamsEditor.this.fireModuleChanged(RubyCommonRunParamsEditor.this.myModulesComboBox);
                RubyCommonRunParamsEditor.this.fireSdkChanged(RubyCommonRunParamsEditor.this.myModulesComboBox);
            }
        });
        this.myAlternativeSdksComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RubyCommonRunParamsEditor.this.fireSdkChanged(RubyCommonRunParamsEditor.this.myAlternativeSdksComboBox);
            }
        });
        this.setAnchor(this.getMaxWidthLabel());
        this.updatePathMappingsVisibility();
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void resetEditorFrom(AbstractRubyRunConfiguration config) {
        this.myWorkDirTextField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)config.getWorkingDirectory())));
        this.myEnvVariablesComponent.setEnvs(config.getEnvs());
        this.myEnvVariablesComponent.setPassParentEnvs(config.isPassParentEnvs());
        this.myRubyArgsEditor.setText(config.getRubyArgs().getParametersString());
        this.setModule(config.getModule());
        this.myAlternativeSdksComboBox.setSelectedItem(config.getAlternativeSdk());
        this.setShouldUseAlternativeSdk(config.shouldUseAlternativeSdk());
        this.myPathMappings.setMappingSettings(config.getMappingSettings());
        Boolean useRailsRunner = (Boolean)config.getCopyableUserData(RailsRunConfigurationExtension.KEY);
        if (useRailsRunner != null) {
            this.myUseRailsRunner.setSelected(useRailsRunner.booleanValue());
        }
    }

    private void setModule(Module module) {
        this.myModulesComboBox.setSelectedModule(module);
        this.fireModuleChanged(this);
        this.fireSdkChanged(this);
    }

    private void fireModuleChanged(Object source) {
        for (ChangeListener listener : this.myModuleChangeListeners) {
            listener.stateChanged(new ChangeEvent(source));
        }
    }

    private void fireSdkChanged(Object source) {
        this.updatePathMappingsVisibility();
        for (ChangeListener listener : this.mySDKChangeListeners) {
            listener.stateChanged(new ChangeEvent(source));
        }
    }

    private void updatePathMappingsVisibility() {
        this.myPathMappings.setVisible(Registry.is((String)"ruby.run.configuration.path.mappings.enabled") && RubyRemoteInterpreterManager.isRemoteSdk(this.getSdk()));
    }

    public void applyEditorTo(AbstractRubyRunConfiguration config) {
        config.setWorkingDirectory(FileUtil.toSystemIndependentName((String)this.myWorkDirTextField.getText().trim()));
        config.setEnvs(this.myEnvVariablesComponent.getEnvs());
        config.setPassParentEnvs(this.myEnvVariablesComponent.isPassParentEnvs());
        config.setRubyArgs(this.myRubyArgsEditor.getText().trim());
        config.setModule(this.getModule());
        config.setAlternativeSdk(this.getAlternativeSdk());
        config.setShouldUseAlternativeSdk(this.shouldUseAlternativeSdk());
        config.setMappingSettings(this.myPathMappings.getMappingSettings());
        config.putCopyableUserData(RailsRunConfigurationExtension.KEY, this.myUseRailsRunner.isSelected());
    }

    private boolean shouldUseAlternativeSdk() {
        return this.myUseAlternativeSdkGemRB.isSelected();
    }

    @Nullable
    private Sdk getAlternativeSdk() {
        Object selectedSdk = this.myAlternativeSdksComboBox.getSelectedItem();
        return selectedSdk instanceof Sdk ? (Sdk)selectedSdk : null;
    }

    private void createUIComponents() {
        Ref rubyArgsEditorWrapper = new Ref();
        String text = RBundle.message((String)"run.configuration.messages.ruby.args");
        this.myRubyArgsComponent = RunConfigurationUIUtil.createRawEditorComponent((Ref<? super RawCommandLineEditor>)rubyArgsEditorWrapper, text);
        this.myRubyArgsEditor = (RawCommandLineEditor)rubyArgsEditorWrapper.get();
        this.myRubyArgsEditor.setName("RubyArgumentsEditor");
        this.myModulesComboBox = new ModulesComboBox();
        this.myAlternativeSdksComboBox = new ComboBox(150);
        this.myAlternativeSdksComboBox.setRenderer(new RubySdkRenderer(true, true));
    }

    public void setUseAlternativeSdkLabel(@NlsSafe String gemName) {
        if (StringUtil.isEmptyOrSpaces((String)gemName)) {
            this.myUseAlternativeSdkGemRB.setText(RBundle.message((String)"run.configuration.tests.use.alternative.sdk.checkbox"));
        } else {
            this.myUseAlternativeSdkGemRB.setText(RBundle.message((String)"run.configuration.tests.use.gem.from.sdk.checkbox", (Object[])new Object[]{gemName}));
        }
    }

    public void setWorkDir(@NlsSafe String workDir) {
        this.myWorkDirTextField.setText(workDir);
    }

    @Nullable
    public Module getModule() {
        return this.myModulesComboBox.getSelectedModule();
    }

    @Nullable
    public Sdk getSdk() {
        if (this.shouldUseAlternativeSdk()) {
            return this.getAlternativeSdk();
        }
        return (Sdk)ReadAction.compute(() -> RubySdkUtil.findRubySdk(this.getModule(), this.myProject));
    }

    public void setWorkDirVisible(boolean visible) {
        this.myWorkDirLabel.setVisible(visible);
        this.myWorkDirTextField.setVisible(visible);
    }

    public void addModuleChangedListener(ChangeListener listener) {
        this.myModuleChangeListeners.add(listener);
    }

    public void addSDKChangedListener(ChangeListener listener) {
        this.mySDKChangeListeners.add(listener);
    }

    private void setShouldUseAlternativeSdk(boolean shouldUse) {
        this.myUseModuleSdkRB.setSelected(!shouldUse);
        this.myUseAlternativeSdkGemRB.setSelected(shouldUse);
        this.myModulesComboBox.setEnabled(!shouldUse);
        this.myAlternativeSdksComboBox.setEnabled(shouldUse);
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myWorkDirLabel.setAnchor(anchor);
        this.myRubyArgsComponent.setAnchor(anchor);
        this.myRubySDKJBLabel.setAnchor(anchor);
        this.myEnvVariablesComponent.setAnchor(anchor);
    }

    @NotNull
    private JComponent getMaxWidthLabel() {
        JComponent jComponent = (JComponent)Collections.max(Arrays.asList(this.myEnvVariablesComponent.getLabel(), this.myRubyArgsComponent.getLabel(), this.myWorkDirLabel, this.myRubySDKJBLabel), Comparator.comparing(label -> label.getMinimumSize().getWidth()));
        if (jComponent == null) {
            RubyCommonRunParamsEditor.$$$reportNull$$$0(0);
        }
        return jComponent;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        PathMappingsComponent pathMappingsComponent;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        EnvironmentVariablesComponent environmentVariablesComponent;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setName("RubyCommonRunParamsEditor");
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        LabeledComponent labeledComponent = this.myRubyArgsComponent;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/RBundle", RubyCommonRunParamsEditor.class).getString("run.configuration.messages.ruby.args"));
        jPanel.add((Component)labeledComponent, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myEnvVariablesComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        jPanel.add((Component)environmentVariablesComponent, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setName("ChooseRubySdkPanel");
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseModuleSdkRB = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/RBundle", RubyCommonRunParamsEditor.class).getString("run.configuration.messages.select.module"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUseAlternativeSdkGemRB = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/RBundle", RubyCommonRunParamsEditor.class).getString("run.configuration.tests.use.alternative.sdk.checkbox"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JComboBox jComboBox = this.myAlternativeSdksComboBox;
        jPanel2.add((Component)jComboBox, new GridConstraints(1, 2, 1, 1, 0, 1, 7, 3, new Dimension(100, -1), null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        ModulesComboBox modulesComboBox = this.myModulesComboBox;
        jPanel3.add((Component)modulesComboBox, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myProjectSdkLabel = jLabel = new JLabel();
        jLabel.setAlignmentX(0.0f);
        jLabel.setAutoscrolls(false);
        jLabel.setText("[RubyMine] Sdk name");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRubySDKJBLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/RBundle", RubyCommonRunParamsEditor.class).getString("run.configuration.messages.select.sdk.bound"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setName("WorkingDirectoryPanel");
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myWorkDirLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/RBundle", RubyCommonRunParamsEditor.class).getString("run.configuration.messages.working.dir"));
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWorkDirTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myPathMappings = pathMappingsComponent = new PathMappingsComponent();
        jPanel.add((Component)pathMappingsComponent, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseRailsRunner = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", RubyCommonRunParamsEditor.class).getString("run.configuration.messages.use.rails.runner"));
        jPanel5.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/run/configuration/RubyCommonRunParamsEditor", "getMaxWidthLabel"));
    }
}

