/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.RegistryUi;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtension;
import org.jetbrains.plugins.ruby.ruby.run.configuration.beforeRun.jrubyc.JRubyCompileBeforeRunTask;
import org.jetbrains.plugins.ruby.ruby.run.configuration.beforeRun.jrubyc.JRubyCompileBeforeRunTaskProvider;
import org.jetbrains.plugins.ruby.ruby.run.configuration.nailgun.JRubyNailgunConfigurable;
import org.jetbrains.plugins.ruby.ruby.run.configuration.nailgun.JRubyNailgunUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.nailgun.NailgunExecSettings;
import org.jetbrains.plugins.ruby.ruby.run.configuration.rubyScript.RubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.statistic.RubyRunConfigurationSettingChangesCollector;
import org.jetbrains.plugins.ruby.statistic.RubyRunConfigurationSettingProjectCollector;

public final class JRubyRunConfigurationExtension
extends RubyRunConfigurationExtension {
    @NotNull
    protected String getSerializationId() {
        return "JRubyRunConfigurationExtension";
    }

    protected void readExternal(@NotNull AbstractRubyRunConfiguration runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(1);
        }
        NailgunExecSettings.putTo(runConfiguration, NailgunExecSettings.readExternal(element));
    }

    protected void writeExternal(@NotNull AbstractRubyRunConfiguration runConfiguration, @NotNull Element element) {
        if (runConfiguration == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(3);
        }
        NailgunExecSettings.getFrom(runConfiguration).writeExternal(element);
    }

    @NotNull
    protected <P extends AbstractRubyRunConfiguration<?>> SettingsEditor<P> createEditor(@NotNull P configuration) {
        if (configuration == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(4);
        }
        return new JRubyNailgunConfigurable();
    }

    @Nullable
    protected String getEditorTitle() {
        return RBundle.message((String)"nailgun.server");
    }

    public boolean isApplicableFor(@NotNull AbstractRubyRunConfiguration configuration) {
        if (configuration == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(5);
        }
        return configuration.getModule() != null && JRubySdkUtil.isJRubySDK(configuration.getSdk());
    }

    public boolean isEnabledFor(@NotNull AbstractRubyRunConfiguration configuration, RunnerSettings runnerSettings) {
        if (configuration == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(6);
        }
        Sdk sdk = configuration.getSdk();
        return configuration.getModule() != null && JRubySdkUtil.isJRubySDK(sdk);
    }

    protected void patchCommandLine(@NotNull AbstractRubyRunConfiguration configuration, RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) {
        if (configuration == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(7);
        }
        if (cmdLine == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(8);
        }
        if (runnerId == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(9);
        }
        if (!JRubyNailgunUtil.isNailgunSupportEnabled()) {
            return;
        }
        Module module = configuration.getModule();
        assert (module != null);
        if (SystemInfo.isWindows) {
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (JRubyRunConfigurationExtension.isJavaSdk(sdk)) {
                JRubyRunConfigurationExtension.addJavaPath(cmdLine, sdk);
            } else {
                Project project = module.getProject();
                sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
                if (JRubyRunConfigurationExtension.isJavaSdk(sdk)) {
                    JRubyRunConfigurationExtension.addJavaPath(cmdLine, sdk);
                }
            }
        }
        JRubyRunConfigurationExtension.patchForCompiledScripts(configuration, cmdLine);
        NailgunExecSettings settings = NailgunExecSettings.getFrom(configuration);
        if (settings.isNailgunServerEnabled) {
            JRubyNailgunUtil.patchCmdLineForNailGunServer(configuration, runnerId, cmdLine);
        }
    }

    @Override
    public void logConfigurationSettingsChange(@NotNull AbstractRubyRunConfiguration<?> oldRunConfiguration, @NotNull AbstractRubyRunConfiguration<?> newRunConfiguration) {
        if (oldRunConfiguration == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(10);
        }
        if (newRunConfiguration == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(11);
        }
        if (oldRunConfiguration.getClass() == newRunConfiguration.getClass() && this.isApplicableFor(oldRunConfiguration) && this.isApplicableFor(newRunConfiguration)) {
            NailgunExecSettings oldNailgunSettings = NailgunExecSettings.getFrom(oldRunConfiguration);
            NailgunExecSettings newNailgunSettings = NailgunExecSettings.getFrom(newRunConfiguration);
            boolean newNailgunServerEnabled = newNailgunSettings.isNailgunServerEnabled;
            boolean oldNailgunServerEnabled = oldNailgunSettings.isNailgunServerEnabled;
            if (newNailgunServerEnabled != oldNailgunServerEnabled) {
                RubyRunConfigurationSettingChangesCollector.logNailgunServerEnabledChange(oldRunConfiguration.getType(), oldNailgunServerEnabled, newNailgunServerEnabled);
            }
        }
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull MetricEvent> logConfigurationSettings(@NotNull @NotNull List<@NotNull AbstractRubyRunConfiguration<?>> runConfigurationList) {
        if (runConfigurationList == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(12);
        }
        ArrayList<Pair> configuredNailgunServerEnabledData = new ArrayList<Pair>();
        for (AbstractRubyRunConfiguration<?> configuration : runConfigurationList) {
            if (!this.isApplicableFor(configuration)) continue;
            configuredNailgunServerEnabledData.add(new Pair(configuration.getType().getClass(), (Object)NailgunExecSettings.getFrom(configuration).isNailgunServerEnabled));
        }
        Set<MetricEvent> set = configuredNailgunServerEnabledData.stream().collect(Collectors.groupingBy(data -> data, Collectors.counting())).entrySet().stream().map(entry -> RubyRunConfigurationSettingProjectCollector.CONFIGURED_NAILGUN_SERVER_ENABLED.metric((Object)((Long)entry.getValue()).intValue(), (Object)((Class)((Pair)entry.getKey()).getFirst()), (Object)((Boolean)((Pair)entry.getKey()).getSecond()))).collect(Collectors.toSet());
        if (set == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(13);
        }
        return set;
    }

    private static void patchForCompiledScripts(AbstractRubyRunConfiguration configuration, GeneralCommandLine cmdLine) {
        List tasks;
        if (configuration instanceof RubyRunConfiguration && !(tasks = RunManagerEx.getInstanceEx((Project)configuration.getProject()).getBeforeRunTasks((RunConfiguration)configuration, JRubyCompileBeforeRunTaskProvider.ID)).isEmpty()) {
            boolean added = false;
            for (JRubyCompileBeforeRunTask task : tasks) {
                String targetPath = task.getTargetPath();
                File file = new File(targetPath);
                if (StringUtil.isEmpty((String)targetPath) || !file.exists() || !file.isDirectory()) continue;
                cmdLine.addParameters(new String[]{"-I", PathUtil.getLocalPath((String)targetPath)});
                added = true;
            }
            if (added) {
                ParametersList list = cmdLine.getParametersList();
                if (list.getParamsGroupsCount() == 0) {
                    return;
                }
                ParametersList parameters = list.getParamsGroupAt(0).getParametersList();
                if (parameters.getParameters().isEmpty()) {
                    return;
                }
                String newPath = FileUtil.getRelativePath((String)configuration.getWorkingDirectory(), (String)parameters.get(0), (char)'/');
                if (newPath != null) {
                    parameters.set(0, PathUtil.getLocalPath((String)newPath));
                }
            }
        }
    }

    private static void addJavaPath(GeneralCommandLine cmdLine, Sdk sdk) {
        Map env = cmdLine.getEnvironment();
        env.put("rubymine.jruby.java.home", sdk.getHomePath());
    }

    private static boolean isJavaSdk(Sdk sdk) {
        return sdk != null && sdk.getSdkType() instanceof JavaSdkType;
    }

    protected void validateConfiguration(@NotNull AbstractRubyRunConfiguration configuration, boolean isExecution) throws RuntimeConfigurationWarning {
        if (configuration == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(14);
        }
        if (NailgunExecSettings.getFrom((AbstractRubyRunConfiguration)configuration).isNailgunServerEnabled && !JRubyNailgunUtil.isNailgunSupportEnabled()) {
            throw new RuntimeConfigurationWarning(RBundle.message((String)"nailgun.server.support.retirement.warning"), () -> new RegistryUi().show());
        }
    }

    protected void extendTemplateConfiguration(@NotNull AbstractRubyRunConfiguration<?> configuration) {
        if (configuration == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(15);
        }
        super.extendTemplateConfiguration(configuration);
    }

    protected void attachToProcess(@NotNull AbstractRubyRunConfiguration configuration, @NotNull ProcessHandler handler, RunnerSettings runnerSettings) {
        if (configuration == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(16);
        }
        if (handler == null) {
            JRubyRunConfigurationExtension.$$$reportNull$$$0(17);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRunConfiguration";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRunConfiguration";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigurationList";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/configuration/JRubyRunConfigurationExtension";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/JRubyRunConfigurationExtension";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "logConfigurationSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledFor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logConfigurationSettingsChange";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "logConfigurationSettings";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "validateConfiguration";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extendTemplateConfiguration";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }
}

