/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.actions.ConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.config.AbstractProperty;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.preload.PreLoadUtil;
import org.jetbrains.plugins.ruby.rails.preload.zeus.ZeusUtil;
import org.jetbrains.plugins.ruby.rails.run.filters.RStackTraceFilter;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfigurationParams;
import org.jetbrains.plugins.ruby.testing.RubyRerunFailedTestsProvider;
import org.jetbrains.plugins.ruby.testing.SupportedTestFramework;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RubySmtRunnerConsoleProperties;

public abstract class AbstractTestRunConfiguration<T extends AbstractTestRunConfiguration>
extends AbstractRubyRunConfiguration<T>
implements AbstractRubyRunConfigurationParams,
ConsolePropertiesProvider {
    private String myRunnerGemVersion = "";

    protected AbstractTestRunConfiguration(String name, RunConfigurationModule configurationModule, ConfigurationFactory factory) {
        super(name, configurationModule, factory);
    }

    protected AbstractTestRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
    }

    protected String getLogTitle() {
        throw new IllegalStateException("getLogTitle not implemented when log is registered");
    }

    @Override
    protected final LogFileOptions getOptionsForPredefinedLogFile() {
        RailsApp app = RailsApp.fromModule(this.getModule());
        if (app != null) {
            String logsRoot = app.getLogsPath();
            return new LogFileOptions(this.getLogTitle(), new File(logsRoot, this.getDefaultLogFileName()).getPath(), EncodingProjectManager.getInstance((Project)this.getProject()).getDefaultCharset());
        }
        return null;
    }

    public String getRunnerGemVersion() {
        return StringUtil.notNullize((String)this.myRunnerGemVersion);
    }

    public void setRunnerGemVersion(String versionRequirement) {
        this.myRunnerGemVersion = StringUtil.notNullize((String)versionRequirement);
    }

    @NotNull
    protected String getDefaultLogFileName() {
        return "test.log";
    }

    protected static boolean isBundlerContextAllowed(@NotNull PreLoadUtil.PreLoadServer server, @Nullable Module module) {
        if (server == null) {
            AbstractTestRunConfiguration.$$$reportNull$$$0(0);
        }
        return server != PreLoadUtil.PreLoadServer.Zeus || ZeusUtil.isZeusAttached(module);
    }

    @NotNull
    public abstract SupportedTestFramework getTestFramework();

    public boolean shouldAttachTestRunnerConsole() {
        return true;
    }

    protected static boolean containsOptionKey(String data, String optionNameKey) {
        return data.contains(" " + optionNameKey + " ") || data.startsWith(optionNameKey + " ") || data.endsWith(optionNameKey) || optionNameKey.startsWith("--") && (data.contains(" " + optionNameKey + "=") || data.startsWith(optionNameKey + "="));
    }

    @Nullable
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        if (executor == null) {
            AbstractTestRunConfiguration.$$$reportNull$$$0(1);
        }
        final SupportedTestFramework framework = this.getTestFramework();
        RubySmtRunnerConsoleProperties consoleProperties = new RubySmtRunnerConsoleProperties((RunConfiguration)this, framework.getFrameworkName(), executor){

            @Nullable
            public AbstractRerunFailedTestsAction createRerunFailedTestsAction(ConsoleView consoleView) {
                return RubyRerunFailedTestsProvider.createAction((ExecutionConsole)consoleView, framework);
            }
        };
        consoleProperties.setIdBasedTestTree(framework.isIdBasedTestTree());
        consoleProperties.addStackTraceFilter(new RStackTraceFilter(this.getProject(), this.getWorkingDirectory()));
        consoleProperties.setIfUndefined((AbstractProperty)TestConsoleProperties.OPEN_FAILURE_LINE, false);
        return consoleProperties;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/AbstractTestRunConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isBundlerContextAllowed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createTestConsoleProperties";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

