/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run.configuration;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyTestsRunConfigurationParams;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationExtensionsManager;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyRunConfigurationWithTestPath;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public abstract class AbstractAllInFolderRunConfigurationProducer<T extends RubyRunConfigurationWithTestPath>
extends LazyRunConfigurationProducer<T> {
    @Nullable
    public PsiDirectory getTestDirectoryFromContext(@NotNull ConfigurationContext context) {
        Location location;
        if (context == null) {
            AbstractAllInFolderRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if ((location = context.getLocation()) == null) {
            return null;
        }
        PsiElement element = location.getPsiElement();
        if (element instanceof PsiDirectory) {
            return (PsiDirectory)element;
        }
        return null;
    }

    public boolean isConfigurationFromContext(@NotNull T configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            AbstractAllInFolderRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            AbstractAllInFolderRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (configuration.getTestType() != AbstractRubyTestsRunConfigurationParams.TestType.ALL_IN_FOLDER) {
            return false;
        }
        PsiDirectory directory = this.getTestDirectoryFromContext(context);
        return directory != null && directory.getVirtualFile().getPath().equals(configuration.getTestsFolderPath());
    }

    protected boolean isApplicable(@NotNull PsiElement element, @Nullable Module module) {
        if (element == null) {
            AbstractAllInFolderRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (module == null || !RModuleUtil.getInstance().hasRubySupport(module)) {
            return false;
        }
        return element instanceof PsiDirectory;
    }

    protected boolean setupConfigurationForAllFilesInFolder(@NotNull T configuration, @NotNull ConfigurationContext context) {
        PsiDirectory psiDirectory;
        if (configuration == null) {
            AbstractAllInFolderRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            AbstractAllInFolderRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((psiDirectory = this.getTestDirectoryFromContext(context)) == null) {
            return false;
        }
        VirtualFile folder = psiDirectory.getVirtualFile();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiDirectory);
        if (!RModuleUtil.getInstance().hasRubySupport(module)) {
            return false;
        }
        configuration.setTestType(AbstractRubyTestsRunConfigurationParams.TestType.ALL_IN_FOLDER);
        configuration.setTestsFolderPath(folder.getPath());
        if (configuration instanceof AbstractRubyRunConfiguration) {
            AbstractRubyRunConfiguration rubyRunConfiguration = (AbstractRubyRunConfiguration)configuration;
            rubyRunConfiguration.setModule(module);
            RunConfigurationUtil.setRailsDefaultTestEnvironment(rubyRunConfiguration, module);
            RubyRunConfigurationExtensionsManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)rubyRunConfiguration, context.getLocation());
            JRubySdkUtil.enableObjectSpaceIfNotOverriddenByUser(rubyRunConfiguration);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/configuration/AbstractAllInFolderRunConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestDirectoryFromContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationFromContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationForAllFilesInFolder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

