/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public final class RunnerUtil {
    private static final Logger LOG = Logger.getInstance(RubyUtil.class);

    private RunnerUtil() {
    }

    public static void reportErrorsIfNeeded(@NotNull Project project, @NotNull String title, @NotNull String executablePath, @Nullable String stderr) {
        if (project == null) {
            RunnerUtil.$$$reportNull$$$0(0);
        }
        if (title == null) {
            RunnerUtil.$$$reportNull$$$0(1);
        }
        if (executablePath == null) {
            RunnerUtil.$$$reportNull$$$0(2);
        }
        if (!StringUtil.isEmpty((String)stderr) && !RunnerUtil.isJRubyOpenSSLWarning(stderr)) {
            VirtualFile executableFile = LocalFileSystem.getInstance().findFileByPath(executablePath);
            ExecutionHelper.showErrors((Project)project, Collections.singletonList(new Exception(stderr)), (String)title, (VirtualFile)executableFile);
        }
    }

    public static boolean isJRubyOpenSSLWarning(@Nullable String stderr) {
        if (stderr == null) {
            return false;
        }
        String[] lines = stderr.split("\\n");
        return lines.length == 2 && RunnerUtil.isJRubyOpenSSLFirstLine(lines[0]) && RunnerUtil.isJRubyOpenSSLSecondLine(lines[1]);
    }

    public static boolean isSpring(@NotNull String stderr) {
        if (stderr == null) {
            RunnerUtil.$$$reportNull$$$0(3);
        }
        return stderr.startsWith("Running via Spring preloader");
    }

    public static boolean isJRubyOpenSSLSecondLine(@NotNull String line) {
        if (line == null) {
            RunnerUtil.$$$reportNull$$$0(4);
        }
        return line.contains("JRuby_Builtin_OpenSSL") || line.contains("gem install jruby-openssl");
    }

    public static boolean isJRubyOpenSSLFirstLine(@NotNull String line) {
        if (line == null) {
            RunnerUtil.$$$reportNull$$$0(5);
        }
        return line.contains("JRuby limited openssl");
    }

    public static void showExecutionErrorDialog(ExecutionException e) {
        Runnable reporter = () -> Messages.showErrorDialog((String)e.getMessage(), (String)RBundle.message((String)"execution.error.title"));
        LOG.warn((Throwable)e);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            reporter.run();
        } else {
            ApplicationManager.getApplication().invokeLater(reporter);
        }
    }

    public static void validateSDK(@Nullable Sdk sdk) throws ExecutionException {
        if (sdk == null) {
            throw new ExecutionException(RBundle.message((String)"sdk.no.specified"));
        }
        if (!RubySdkUtil.isRubySDK(sdk)) {
            throw new ExecutionException(RBundle.message((String)"sdk.error.isnt.valid", (Object[])new Object[]{sdk.getName()}));
        }
        if (!RubySdkUtil.isRubyInterpreterExist(sdk)) {
            throw new ExecutionException(RBundle.message((String)"sdk.error.home.path.doesnt.exists", (Object[])new Object[]{sdk.getHomePath(), sdk.getName()}));
        }
    }

    public static void showErrorMessage(Project project, @NlsContexts.DialogTitle String errorTitle, Exception exp) {
        String errorMessage = RunnerUtil.filterIoExceptionMessage(exp.getMessage());
        if (errorMessage == null || errorMessage.isEmpty()) {
            errorMessage = exp.toString();
        }
        LOG.warn(errorTitle, (Throwable)exp);
        Messages.showErrorDialog((Project)project, (String)errorMessage, (String)errorTitle);
    }

    @NlsContexts.DialogMessage
    @Nullable
    public static String filterIoExceptionMessage(@Nullable @NlsSafe String message) {
        if (message == null) {
            return null;
        }
        @NonNls String ioExceptionPrefix = "java.io.IOException:";
        if (message.startsWith("java.io.IOException:")) {
            return message.substring("java.io.IOException:".length());
        }
        return message;
    }

    public static List<String> collectCommands(@NotNull String rubyExe, @NotNull String script) {
        if (rubyExe == null) {
            RunnerUtil.$$$reportNull$$$0(6);
        }
        if (script == null) {
            RunnerUtil.$$$reportNull$$$0(7);
        }
        LinkedList<String> commands = new LinkedList<String>();
        commands.add(rubyExe);
        commands.add("-e");
        commands.add(script);
        return ContainerUtil.filter(commands, item -> !StringUtil.isEmptyOrSpaces((String)item));
    }

    @NotNull
    public static PathMappingSettings getRunnerDefaultMappings(@NotNull Sdk sdk, @Nullable Module module) {
        if (sdk == null) {
            RunnerUtil.$$$reportNull$$$0(8);
        }
        PathMappingSettings pathMappingSettings = RunnerUtil.getRunner(sdk, module).addDefaultMappings(null);
        if (pathMappingSettings == null) {
            RunnerUtil.$$$reportNull$$$0(9);
        }
        return pathMappingSettings;
    }

    @NotNull
    public static RubyRunner getRunner(@NotNull Sdk sdk, @Nullable Module module) {
        if (sdk == null) {
            RunnerUtil.$$$reportNull$$$0(10);
        }
        SdkTypeId sdkType = sdk.getSdkType();
        assert (sdkType instanceof RubySdkType) : "Unexpected sdk type - " + String.valueOf(sdkType);
        RubyRunner rubyRunner = RubySdkAdditionalData.notNullFrom(sdk).getRunner(module);
        if (rubyRunner == null) {
            RunnerUtil.$$$reportNull$$$0(11);
        }
        return rubyRunner;
    }

    public static boolean validateSdkWithDialog(@Nullable Sdk sdk) {
        try {
            RunnerUtil.validateSDK(sdk);
        }
        catch (ExecutionException e) {
            RunnerUtil.showExecutionErrorDialog(e);
            return false;
        }
        return true;
    }

    @Deprecated
    @NotNull
    public static String clarifyExePath(@NotNull String exePath) {
        File exeFile;
        String shellPath;
        String systemPath;
        if (exePath == null) {
            RunnerUtil.$$$reportNull$$$0(12);
        }
        if (SystemInfoRt.isMac && exePath.indexOf(File.separatorChar) == -1 && !Objects.equals(systemPath = System.getenv("PATH"), shellPath = EnvironmentUtil.getValue((String)"PATH")) && (exeFile = PathEnvironmentVariableUtil.findInPath((String)exePath, (String)shellPath, null)) != null) {
            String string = exeFile.getPath();
            if (string == null) {
                RunnerUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = exePath;
        if (string == null) {
            RunnerUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stderr";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyExe";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/RunnerUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/RunnerUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerDefaultMappings";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "clarifyExePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reportErrorsIfNeeded";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSpring";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isJRubyOpenSSLSecondLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isJRubyOpenSSLFirstLine";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectCommands";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerDefaultMappings";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRunner";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "clarifyExePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 11, 13, 14 -> new IllegalStateException(string);
        };
    }
}

