/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PathMappingSettings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyCommandLineExecutionContext;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurator;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;

public interface RubyRunner {
    public static final int DEFAULT_EXECUTION_TIMEOUT;
    public static final ProcessListener CLOSE_INPUT_ADAPTER;

    @NotNull
    default public ProcessOutput executeInSameThread(@NotNull RubyRunnerExecutionContext context) throws ExecutionException {
        if (context == null) {
            RubyRunner.$$$reportNull$$$0(0);
        }
        ProcessOutput output2 = this.execute((RubyRunnerExecutionContext)context.inSameThread(DEFAULT_EXECUTION_TIMEOUT));
        if (!2.$assertionsDisabled && output2 == null) {
            throw new AssertionError();
        }
        ProcessOutput processOutput = output2;
        if (processOutput == null) {
            RubyRunner.$$$reportNull$$$0(1);
        }
        return processOutput;
    }

    @Nullable
    default public ProcessOutput execute(@NotNull RubyRunnerExecutionContext context) throws ExecutionException {
        if (context == null) {
            RubyRunner.$$$reportNull$$$0(2);
        }
        return this.execute(RubyCommandLineExecutionContext.create(context, this.createCommandLine(context)));
    }

    @Nullable
    public ProcessOutput execute(@NotNull RubyCommandLineExecutionContext var1) throws ExecutionException;

    @NotNull
    public RubyCommandLine createCommandLine(@NotNull RubyRunnerExecutionContext var1);

    @NotNull
    public PathMappingSettings addDefaultMappings(@Nullable PathMappingSettings var1);

    @NotNull
    public ProcessHandler createProcessHandler(@NotNull RubyCommandLine var1, @Nullable String var2) throws ExecutionException;

    @NotNull
    default public ProcessHandler createProcessHandler(@NotNull RubyRunnerExecutionContext executionContext, @Nullable String runnerId) throws ExecutionException {
        if (executionContext == null) {
            RubyRunner.$$$reportNull$$$0(3);
        }
        ProcessHandler processHandler = this.createProcessHandler(this.createCommandLine(executionContext), runnerId);
        if (processHandler == null) {
            RubyRunner.$$$reportNull$$$0(4);
        }
        return processHandler;
    }

    @NotNull
    public Map<String, String> getParentEnv();

    @NotNull
    public ProcessHandler createConsoleProcessHandler(@NotNull RubyCommandLine var1) throws ExecutionException;

    @NotNull
    public Pair<PortForwarding, PortForwarding> getDebuggerForwardings() throws ExecutionException;

    default public void configureExtraPortsForMultiProcess(@NotNull RubyCommandLineData data, @NotNull Map<String, String> environment) {
        if (data == null) {
            RubyRunner.$$$reportNull$$$0(5);
        }
        if (environment == null) {
            RubyRunner.$$$reportNull$$$0(6);
        }
    }

    @NotNull
    public RubySdkSystemAccessor getSystemAccessor();

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    default public PathMappingSettings customizePathMappings(@Nullable PathMappingSettings mappings) {
        return mappings;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    default public List<String> customizeGemsRootUrls(@Nullable List<String> gemUrls) {
        return gemUrls;
    }

    @ApiStatus.Experimental
    @NotNull
    public List<String> wrapWithShell(boolean var1, boolean var2, @NotNull String var3);

    @ApiStatus.Experimental
    @NotNull
    public List<String> getCommandsSequence(List<String> ... var1);

    @NotNull
    public static RubyRunner notNullFrom(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyRunner.$$$reportNull$$$0(7);
        }
        RubyRunner rubyRunner = Objects.requireNonNull(RubyRunner.from(sdk, null));
        if (rubyRunner == null) {
            RubyRunner.$$$reportNull$$$0(8);
        }
        return rubyRunner;
    }

    @Contract(value="null->null")
    @Nullable
    public static RubyRunner from(@Nullable Sdk sdk) {
        return RubyRunner.from(sdk, null);
    }

    @Contract(value="null, _ ->null")
    @Nullable
    public static RubyRunner from(@Nullable Sdk sdk, @Nullable Module module) {
        RubySdkAdditionalData obj = RubySdkAdditionalData.from(sdk);
        return obj == null ? null : RubySdkConfigurator.from(obj).buildRunner(obj, module);
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        DEFAULT_EXECUTION_TIMEOUT = SystemInfo.isLinux ? 30 : 60;
        CLOSE_INPUT_ADAPTER = new ProcessListener(){

            public void startNotified(@NotNull ProcessEvent event) {
                OutputStream processInput;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((processInput = event.getProcessHandler().getProcessInput()) == null) {
                    return;
                }
                try {
                    processInput.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/run/RubyRunner$1", "startNotified"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/RubyRunner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/RubyRunner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "executeInSameThread";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeInSameThread";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureExtraPortsForMultiProcess";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notNullFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 8 -> new IllegalStateException(string);
        };
    }
}

