/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.TestFrameworkConfigurator;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyCommandLineExecutionContext;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.rubyforge.debugcommons.Util;

public abstract class RubyAbstractRunner
implements RubyRunner {
    private static final Logger LOG = Logger.getInstance(RubyAbstractRunner.class);
    private static final Key<ThrowableRunnable<ExecutionException>> VERSION_MANAGER_PATCH_KEY = Key.create((String)"ruby.version.manager.patch");
    @NonNls
    private static final String RUBINIUS_19_PARAM = "-X19";
    @NonNls
    private static final String RUBYMINE_VERSION_KEY = "RM_INFO";
    private static final List<Character> SHELL_WHITELIST_CHARACTERS = Arrays.asList(Character.valueOf('$'), Character.valueOf(':'), Character.valueOf('='));
    @Nullable
    protected final Module myModule;
    @NotNull
    private final RubySdkSystemAccessor mySystemAccessor;

    protected RubyAbstractRunner(@Nullable Module module, @NotNull RubySdkSystemAccessor systemAccessor) {
        if (systemAccessor == null) {
            RubyAbstractRunner.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.mySystemAccessor = systemAccessor;
    }

    @Override
    @NotNull
    public final RubySdkSystemAccessor getSystemAccessor() {
        RubySdkSystemAccessor rubySdkSystemAccessor = this.mySystemAccessor;
        if (rubySdkSystemAccessor == null) {
            RubyAbstractRunner.$$$reportNull$$$0(1);
        }
        return rubySdkSystemAccessor;
    }

    private void configureTestFrameworkSupport(@NotNull Sdk sdk, @NotNull Map<String, String> envMap) {
        TestFrameworkConfigurator[] extensions;
        if (sdk == null) {
            RubyAbstractRunner.$$$reportNull$$$0(2);
        }
        if (envMap == null) {
            RubyAbstractRunner.$$$reportNull$$$0(3);
        }
        if ((extensions = (TestFrameworkConfigurator[])TestFrameworkConfigurator.EP_NAME.getExtensions()).length > 0) {
            try {
                extensions[0].configureTestFrameworkSupport(sdk, envMap, this.myModule);
            }
            catch (ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    @Override
    @NotNull
    public RubyCommandLine createCommandLine(@NotNull RubyRunnerExecutionContext context) {
        if (context == null) {
            RubyAbstractRunner.$$$reportNull$$$0(4);
        }
        RubyCommandLine cmdLine = new RubyCommandLine(this, context.isAskForSudo());
        cmdLine.withPty(context.isAllocatePty());
        cmdLine.withAddBundleExec(context.isAddBundleExec());
        Sdk sdk = context.getRubySdk();
        PathMappingSettings pathMappings = this.addDefaultMappings(context.getPathMappings());
        String workingDir = context.getWorkingDirPath();
        String executablePath = context.getExecutablePath();
        cmdLine.setExePath(this.toSystemDependentName(executablePath, pathMappings));
        if (workingDir != null) {
            cmdLine.withWorkDirectory(this.toSystemDependentName(workingDir, pathMappings));
        }
        if (JRubySdkType.isJRubyExecutable(executablePath)) {
            JRubySdkUtil.addJRubyClassPath(cmdLine, RubyAbstractRunner.getAdditionalClassPath(context.getAdditionalEnvs()));
        }
        if (JRubySdkUtil.isJRubySDK(sdk)) {
            JRubySdkUtil.specifyLanguageLevel(cmdLine, sdk);
        } else if (RubySdkUtil.isRubinius(sdk) && RubySdkUtil.isRuby19(sdk)) {
            cmdLine.addParameter(RUBINIUS_19_PARAM);
        }
        context.getExecutableArguments().copyTo(cmdLine.getParametersList());
        Map<String, String> customEnvVariables = RubyAbstractRunner.addRMEnvironment(context.getAdditionalEnvs());
        EnvironmentUtil.inlineParentOccurrences(customEnvVariables, this.getParentEnv());
        this.passParentEnv(context.isWithParentEnv(), cmdLine);
        Map envParams = cmdLine.getEnvironment();
        if (!context.isSpringPreloaderEnabled()) {
            SpringUtil.disableSpring(envParams);
        }
        envParams.putAll(customEnvVariables);
        if (!envParams.containsKey("ANSICON")) {
            envParams.put("ANSICON", "");
        }
        if (SystemInfo.isMac && !envParams.containsKey("LANG")) {
            envParams.put("LANG", Locale.getDefault().toString() + ".UTF-8");
        }
        if (sdk != null) {
            this.configureTestFrameworkSupport(sdk, envParams);
            if (context.isPatchWithVersionManager()) {
                VERSION_MANAGER_PATCH_KEY.set((UserDataHolder)cmdLine, () -> RubyVersionManagerHandler.patchCommandLine(this, cmdLine, envParams, customEnvVariables, sdk, pathMappings));
            }
        }
        RubyCommandLine rubyCommandLine = context.preprocessCommandLine(cmdLine);
        if (rubyCommandLine == null) {
            RubyAbstractRunner.$$$reportNull$$$0(5);
        }
        return rubyCommandLine;
    }

    protected void passParentEnv(boolean passParentEnvs, @NotNull GeneralCommandLine cmdLine) {
        if (cmdLine == null) {
            RubyAbstractRunner.$$$reportNull$$$0(6);
        }
        cmdLine.withParentEnvironmentType(passParentEnvs ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
    }

    @NotNull
    public abstract String toSystemDependentName(@NotNull String var1, @NotNull PathMappingSettings var2);

    @Override
    @Nullable
    public ProcessOutput execute(@NotNull RubyCommandLineExecutionContext context) throws ExecutionException {
        if (context == null) {
            RubyAbstractRunner.$$$reportNull$$$0(7);
        }
        ProgressManager.checkCanceled();
        RubyCommandLine commandLine = context.getCommandLine();
        ExecutionMode mode = context.getExecutionMode();
        String executionID = context.getExecutionID();
        ProcessHandler osProcessHandler = this.createProcessHandler(commandLine, null, executionID);
        CapturingProcessAdapter capturingProcessAdapter = new CapturingProcessAdapter();
        if (!mode.inBackGround()) {
            osProcessHandler.addProcessListener((ProcessListener)capturingProcessAdapter);
        }
        for (ProcessListener listener : mode.getProcessListeners()) {
            osProcessHandler.addProcessListener(listener);
        }
        osProcessHandler.startNotify();
        ExecutionHelper.executeExternalProcess((Project)context.getProject(), (ProcessHandler)osProcessHandler, (ExecutionMode)mode, (GeneralCommandLine)commandLine);
        if (mode.inBackGround()) {
            return null;
        }
        return capturingProcessAdapter.getOutput();
    }

    @NotNull
    protected abstract ProcessHandler createProcessHandlerInner(@NotNull RubyCommandLine var1, @Nullable String var2) throws ExecutionException;

    @NotNull
    protected ProcessHandler processProcessHandler(@NotNull ProcessHandler processHandler, @Nullable String executionID) {
        if (processHandler == null) {
            RubyAbstractRunner.$$$reportNull$$$0(8);
        }
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 == null) {
            RubyAbstractRunner.$$$reportNull$$$0(9);
        }
        return processHandler2;
    }

    @Override
    @NotNull
    public final ProcessHandler createProcessHandler(@NotNull RubyCommandLine commandLine, @Nullable String runnerId) throws ExecutionException {
        if (commandLine == null) {
            RubyAbstractRunner.$$$reportNull$$$0(10);
        }
        return this.createProcessHandler(commandLine, runnerId, null);
    }

    @NotNull
    private static RubyCommandLine applyVersionManagerPatch(@NotNull RubyCommandLine commandLine) throws ExecutionException {
        ThrowableRunnable versionManagerPatch;
        if (commandLine == null) {
            RubyAbstractRunner.$$$reportNull$$$0(11);
        }
        if ((versionManagerPatch = (ThrowableRunnable)VERSION_MANAGER_PATCH_KEY.get((UserDataHolder)commandLine)) != null) {
            versionManagerPatch.run();
        }
        RubyCommandLine rubyCommandLine = commandLine;
        if (rubyCommandLine == null) {
            RubyAbstractRunner.$$$reportNull$$$0(12);
        }
        return rubyCommandLine;
    }

    @NotNull
    private ProcessHandler createProcessHandler(@NotNull RubyCommandLine commandLine, @Nullable String runnerId, @Nullable String executionID) throws ExecutionException {
        Application application;
        if (commandLine == null) {
            RubyAbstractRunner.$$$reportNull$$$0(13);
        }
        if (Registry.is((String)"ruby.execution.lock.control") && (application = ApplicationManager.getApplication()).isReadAccessAllowed() && !application.isUnitTestMode()) {
            LOG.warn("Ruby command should not be executed under lock. [Read lock: " + application.isReadAccessAllowed() + "; Write lock: " + application.isWriteAccessAllowed() + "; EDT: " + application.isDispatchThread() + "]", new Throwable());
        }
        ProcessHandler processHandler = this.processProcessHandler(this.createProcessHandlerInner(RubyAbstractRunner.applyVersionManagerPatch(commandLine), runnerId), executionID);
        if (processHandler == null) {
            RubyAbstractRunner.$$$reportNull$$$0(14);
        }
        return processHandler;
    }

    @Override
    @NotNull
    public Pair<PortForwarding, PortForwarding> getDebuggerForwardings() throws ExecutionException {
        Pair pair;
        try {
            int[] localPorts = NetUtils.findAvailableSocketPorts((int)2);
            int[] remotePorts = this.findAvailableRemotePorts(localPorts);
            pair = Pair.create((Object)PortForwarding.remoteToLocal(Util.DEBUGGER_SERVER_LOCALHOST, remotePorts[0], localPorts[0]), (Object)PortForwarding.localToRemote(Util.DEBUGGER_SERVER_LOCALHOST, localPorts[1], remotePorts[1]));
        }
        catch (IOException e) {
            throw new ExecutionException(RBundle.message((String)"ruby.debugger.cannot.find.free.port"));
        }
        if (pair == null) {
            RubyAbstractRunner.$$$reportNull$$$0(15);
        }
        return pair;
    }

    protected abstract int @NotNull [] findAvailableRemotePorts(int @NotNull [] var1) throws ExecutionException;

    @Nullable
    private static String getAdditionalClassPath(@Nullable Map<String, String> userDefinedEnvs) {
        return userDefinedEnvs == null ? null : userDefinedEnvs.get("CLASSPATH");
    }

    @NotNull
    public static Map<String, String> addRMEnvironment(@Nullable Map<String, String> environment) {
        HashMap<String, String> env = environment != null ? new HashMap<String, String>(environment) : new HashMap();
        env.put(RUBYMINE_VERSION_KEY, ApplicationInfo.getInstance().getBuild().asString());
        HashMap<String, String> hashMap = env;
        if (hashMap == null) {
            RubyAbstractRunner.$$$reportNull$$$0(16);
        }
        return hashMap;
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    @Override
    @NotNull
    public final ProcessHandler createConsoleProcessHandler(@NotNull RubyCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            RubyAbstractRunner.$$$reportNull$$$0(17);
        }
        ProcessHandler processHandler = this.createConsoleProcessHandlerInner(RubyAbstractRunner.applyVersionManagerPatch(commandLine));
        if (processHandler == null) {
            RubyAbstractRunner.$$$reportNull$$$0(18);
        }
        return processHandler;
    }

    @NotNull
    protected abstract ProcessHandler createConsoleProcessHandlerInner(@NotNull RubyCommandLine var1) throws ExecutionException;

    @Override
    @NotNull
    public final List<String> getCommandsSequence(List<String> ... commands) {
        if (commands == null) {
            RubyAbstractRunner.$$$reportNull$$$0(19);
        }
        String compoundCommand = Stream.of(commands).map(c -> ParametersListUtil.join((List)c, command -> CommandLineUtil.posixQuote((String)command, SHELL_WHITELIST_CHARACTERS))).collect(Collectors.joining(" && "));
        List list = new GeneralCommandLine(this.wrapWithShell(false, false, compoundCommand)).getCommandLineList(null);
        if (list == null) {
            RubyAbstractRunner.$$$reportNull$$$0(20);
        }
        return list;
    }

    @Override
    @NotNull
    public final List<String> wrapWithShell(boolean isLogin, boolean isInteractive, @NotNull String command) {
        if (command == null) {
            RubyAbstractRunner.$$$reportNull$$$0(21);
        }
        if (this.getSystemAccessor().isWindows()) {
            throw new RuntimeException("Not supposed to be invoked on Windows");
        }
        String linuxShellCommand = this.getLinuxShellCommand();
        if (!"bash".equals(PathUtil.getFileName((String)linuxShellCommand))) {
            command = StringUtil.join(Arrays.asList("bash", "-c", CommandLineUtil.posixQuote((String)command)), (String)" ");
        }
        List shellCommand = EnvironmentUtil.buildShellProcessCommand((String)linuxShellCommand, (boolean)isLogin, (boolean)isInteractive, (boolean)true);
        shellCommand.add(command);
        List list = shellCommand;
        if (list == null) {
            RubyAbstractRunner.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    protected abstract String getLinuxShellCommand();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 9, 12, 14, 15, 16, 18, 20, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemAccessor";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/RubyAbstractRunner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envMap";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/RubyAbstractRunner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemAccessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "processProcessHandler";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "applyVersionManagerPatch";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerForwardings";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addRMEnvironment";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleProcessHandler";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandsSequence";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithShell";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configureTestFrameworkSupport";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "passParentEnv";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processProcessHandler";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyVersionManagerPatch";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleProcessHandler";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCommandsSequence";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithShell";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 9, 12, 14, 15, 16, 18, 20, 22 -> new IllegalStateException(string);
        };
    }
}

