/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.run;

import org.jetbrains.annotations.NotNull;

public final class PortForwarding {
    public static final String LOCALHOST_STRING = "localhost";
    @NotNull
    private final String myLocalHostName;
    private final int myLocalPort;
    @NotNull
    private final String myRemoteHostName;
    private final int myRemotePort;
    private final Direction myDirection;

    @NotNull
    public static PortForwarding localToRemote(@NotNull String localHostName, int localPort, int remotePort) {
        if (localHostName == null) {
            PortForwarding.$$$reportNull$$$0(0);
        }
        return new PortForwarding(Direction.LOCAL_TO_REMOTE, localHostName, localPort, LOCALHOST_STRING, remotePort);
    }

    @NotNull
    public static PortForwarding remoteToLocal(@NotNull String remoteHostName, int remotePort, int localPort) {
        if (remoteHostName == null) {
            PortForwarding.$$$reportNull$$$0(1);
        }
        return new PortForwarding(Direction.REMOTE_TO_LOCAL, LOCALHOST_STRING, localPort, remoteHostName, remotePort);
    }

    private PortForwarding(@NotNull Direction direction, @NotNull String localHostName, int localPort, @NotNull String remoteHostName, int remotePort) {
        if (direction == null) {
            PortForwarding.$$$reportNull$$$0(2);
        }
        if (localHostName == null) {
            PortForwarding.$$$reportNull$$$0(3);
        }
        if (remoteHostName == null) {
            PortForwarding.$$$reportNull$$$0(4);
        }
        this.myDirection = direction;
        this.myLocalHostName = localHostName;
        this.myLocalPort = localPort;
        this.myRemoteHostName = remoteHostName;
        this.myRemotePort = remotePort;
    }

    @NotNull
    public String getLocalHostName() {
        String string = this.myLocalHostName;
        if (string == null) {
            PortForwarding.$$$reportNull$$$0(5);
        }
        return string;
    }

    public int getLocalPort() {
        return this.myLocalPort;
    }

    @NotNull
    public String getRemoteHostName() {
        String string = this.myRemoteHostName;
        if (string == null) {
            PortForwarding.$$$reportNull$$$0(6);
        }
        return string;
    }

    public int getRemotePort() {
        return this.myRemotePort;
    }

    public Direction getDirection() {
        return this.myDirection;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Port forwarding[");
        switch (this.myDirection) {
            case LOCAL_TO_REMOTE: {
                sb.append("from local server ").append(this.myLocalHostName).append(':').append(this.myLocalPort).append(" to remote ").append(this.myRemoteHostName).append(':').append(this.myRemotePort);
                break;
            }
            case REMOTE_TO_LOCAL: {
                sb.append("from remote server ").append(this.myRemoteHostName).append(':').append(this.myRemotePort).append(" to local ").append(this.myLocalHostName).append(':').append(this.myLocalPort);
                break;
            }
            default: {
                assert (false) : "Unexpected port forwarding direction " + String.valueOf((Object)this.myDirection);
                break;
            }
        }
        return sb.append(']').toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localHostName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteHostName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/run/PortForwarding";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/run/PortForwarding";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalHostName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteHostName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "localToRemote";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "remoteToLocal";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }

    public static enum Direction {
        LOCAL_TO_REMOTE,
        REMOTE_TO_LOCAL;

    }
}

