/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.regexp;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.intellij.lang.regexp.RegExpMatch;
import org.intellij.lang.regexp.RegExpMatchResult;
import org.intellij.lang.regexp.RegExpMatcherProvider;
import org.intellij.lang.regexp.intention.CheckRegExpForm;
import org.jcodings.specific.UTF8Encoding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;

public final class RubyRegExpMatcherProvider
implements RegExpMatcherProvider {
    @NotNull
    public RegExpMatchResult matches(String regExp, PsiFile regExpFile, PsiElement elementInHost, String sampleText, long timeoutMillis) {
        RegExpMatchResult regExpMatchResult;
        int match;
        Matcher matcher;
        byte[] str;
        block11: {
            String modifiers = RubyRegExpMatcherProvider.getModifiers(elementInHost);
            int flags = 0;
            if (modifiers != null) {
                if (modifiers.contains("i")) {
                    flags |= 1;
                }
                if (modifiers.contains("m")) {
                    flags |= 4;
                }
            }
            byte[] pattern = regExp.getBytes(StandardCharsets.UTF_8);
            str = sampleText.getBytes(StandardCharsets.UTF_8);
            Regex regex = new Regex(pattern, 0, pattern.length, flags, UTF8Encoding.INSTANCE);
            matcher = regex.matcher(str);
            match = matcher.search(0, str.length, 0);
            if (match >= 0) break block11;
            RegExpMatchResult regExpMatchResult2 = RegExpMatchResult.NO_MATCH;
            if (regExpMatchResult2 == null) {
                RubyRegExpMatcherProvider.$$$reportNull$$$0(0);
            }
            return regExpMatchResult2;
        }
        try {
            SmartList matches = new SmartList();
            while (match >= 0) {
                Region region = matcher.getEagerRegion();
                RegExpMatch m = new RegExpMatch();
                for (int i = 0; i < region.getNumRegs(); ++i) {
                    int start = region.getBeg(i);
                    int end = region.getEnd(i);
                    m.add(start, end);
                }
                matches.add(m);
                int start = m.end(0);
                match = matcher.search(start == match ? match + 1 : start, str.length, 0);
            }
            CheckRegExpForm.setMatches((PsiFile)regExpFile, (List)matches);
            regExpMatchResult = RegExpMatchResult.FOUND;
        }
        catch (RuntimeException e) {
            RegExpMatchResult regExpMatchResult3 = RegExpMatchResult.BAD_REGEXP;
            if (regExpMatchResult3 == null) {
                RubyRegExpMatcherProvider.$$$reportNull$$$0(2);
            }
            return regExpMatchResult3;
        }
        if (regExpMatchResult == null) {
            RubyRegExpMatcherProvider.$$$reportNull$$$0(1);
        }
        return regExpMatchResult;
    }

    @Nullable
    private static String getModifiers(PsiElement elementInHost) {
        PsiElement regexpEnd = elementInHost.getLastChild();
        String endText = regexpEnd.getText();
        if (endText.matches("^/(\\w)+")) {
            return endText.substring(1);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/regexp/RubyRegExpMatcherProvider", "matches"));
    }
}

