/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.replacement;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.replacement.RubyReplacementBase;

public class RubyReplacementSubstringElement
extends RubyReplacementBase {
    @NotNull
    private final String myText;
    @NotNull
    private final TextRange myRange;
    @NotNull
    private final List<PsiElement> myOccurrences;
    @NotNull
    private final Map<PsiElement, TextRange> myRangeMap;

    public RubyReplacementSubstringElement(@NotNull PsiElement element, @NotNull RPsiElement parent, @Nullable RPsiElement context, @NotNull String substring, @NotNull TextRange textRange) {
        if (element == null) {
            RubyReplacementSubstringElement.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            RubyReplacementSubstringElement.$$$reportNull$$$0(1);
        }
        if (substring == null) {
            RubyReplacementSubstringElement.$$$reportNull$$$0(2);
        }
        if (textRange == null) {
            RubyReplacementSubstringElement.$$$reportNull$$$0(3);
        }
        super(element, parent);
        this.myText = substring.replace("\"", "\\\"");
        this.myRange = textRange;
        this.myRangeMap = RubyRefactoringUtil.getSubstringOccurrences(this.myText, context);
        this.myRangeMap.put((PsiElement)this.getExpression(), this.myRange);
        this.myOccurrences = new ArrayList<PsiElement>(this.myRangeMap.keySet());
    }

    @Override
    @NotNull
    public List<PsiElement> getOccurrences() {
        List<PsiElement> list = this.myOccurrences;
        if (list == null) {
            RubyReplacementSubstringElement.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public void replaceOccurrences(@NotNull Project project, @NotNull String replacement, boolean replaceAll) {
        if (project == null) {
            RubyReplacementSubstringElement.$$$reportNull$$$0(5);
        }
        if (replacement == null) {
            RubyReplacementSubstringElement.$$$reportNull$$$0(6);
        }
        Map<PsiElement, TextRange> replacements = this.myRangeMap;
        if (!replaceAll) {
            replacements = Collections.singletonMap(this.getExpression(), this.myRange);
        }
        for (Map.Entry<PsiElement, TextRange> entry : replacements.entrySet()) {
            RExpression newExpression = RubyElementFactory.createExpressionWithSubstitution((RPsiElement)entry.getKey(), entry.getValue(), replacement);
            RefactoringPsiHelper.replaceExpression(project, (PsiElement)((RPsiElement)entry.getKey()), (PsiElement)newExpression);
        }
    }

    @Override
    public boolean isStatement() {
        return false;
    }

    @Override
    @NotNull
    public String getExtractedText(@NotNull String name, boolean isKeywordInitializer, boolean isListAllowed) {
        if (name == null) {
            RubyReplacementSubstringElement.$$$reportNull$$$0(7);
        }
        String symbol = isKeywordInitializer ? ": " : " = ";
        String string = name + symbol + "\"" + this.myText + "\"";
        if (string == null) {
            RubyReplacementSubstringElement.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substring";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/replacement/RubyReplacementSubstringElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/replacement/RubyReplacementSubstringElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrences";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceOccurrences";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExtractedText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8 -> new IllegalStateException(string);
        };
    }
}

