/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.pushDown;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.memberPushDown.PushDownUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyOverrideImplementUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.pushDown.RubyPushDownConflicts;

public final class RubyPushDownProcessor
extends BaseRefactoringProcessor {
    private RContainer myClazz;
    private Collection<RubyMemberInfo> myMembers;

    @ApiStatus.Internal
    public RubyPushDownProcessor(RContainer clazz) {
        super(clazz.getProject());
        this.myClazz = clazz;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            RubyPushDownProcessor.$$$reportNull$$$0(0);
        }
        return new PushDownUsageViewDescriptor((PsiElement)this.myClazz);
    }

    protected UsageInfo @NotNull [] findUsages() {
        HashSet classes = new HashSet();
        RubyOverrideImplementUtil.addDerivedClasses(this.myClazz, classes);
        HashMap<String, UsageInfo> result = new HashMap<String, UsageInfo>();
        for (RContainer subClass : classes) {
            FQN fqn = subClass.getFQNWithNesting();
            result.put(fqn.getFullPath(), new UsageInfo((PsiElement)subClass));
        }
        UsageInfo[] usageInfoArray = result.values().toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            RubyPushDownProcessor.$$$reportNull$$$0(1);
        }
        return usageInfoArray;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> ref) {
        if (ref == null) {
            RubyPushDownProcessor.$$$reportNull$$$0(2);
        }
        UsageInfo[] usages = (UsageInfo[])ref.get();
        RubyPushDownConflicts conflicts = new RubyPushDownConflicts(this.myClazz, this.myMembers);
        conflicts.checkSourceClassConflicts();
        if (usages.length == 0) {
            String message = RefactoringBundle.message((String)"class.0.does.not.have.inheritors", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myClazz)}) + "\n" + RefactoringBundle.message((String)"push.down.will.delete.members");
            if (!((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)this.getCommandName(), (String)message).icon(Messages.getWarningIcon())).ask(this.myProject)) {
                return false;
            }
        }
        for (UsageInfo usage : usages) {
            conflicts.checkTargetClassConflicts((RContainer)usage.getElement());
        }
        return this.showConflicts(conflicts.getConflicts(), usages);
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            RubyPushDownProcessor.$$$reportNull$$$0(3);
        }
        ArrayList pub = new ArrayList();
        ArrayList prot = new ArrayList();
        ArrayList priv = new ArrayList();
        RubyClassMembersPsiHelper.splitByAccess(this.myMembers, pub, prot, priv);
        for (UsageInfo usage : usages) {
            RContainer superClass = (RContainer)usage.getElement();
            RubyClassMembersPsiHelper.insertMethods(superClass, priv, "private", false);
            RubyClassMembersPsiHelper.insertMethods(superClass, prot, "protected", false);
            RubyClassMembersPsiHelper.insertMethods(superClass, pub, "public", false);
        }
        RubyClassMembersPsiHelper.removeMembers(this.myMembers);
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"push.members.down.title");
        if (string == null) {
            RubyPushDownProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void prepare(Collection<RubyMemberInfo> selectedMemberInfos) {
        this.myMembers = selectedMemberInfos;
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            RubyPushDownProcessor.$$$reportNull$$$0(5);
        }
        if (elements.length == 1 && elements[0] instanceof RClass) {
            this.myClazz = (RContainer)elements[0];
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/pushDown/RubyPushDownProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/pushDown/RubyPushDownProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

