/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.pushDown;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.classMembers.UsedByDependencyMemberInfoModel;
import com.intellij.refactoring.ui.RefactoringDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfoStorage;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberSelectionPanel;
import org.jetbrains.plugins.ruby.ruby.refactoring.pushDown.RubyPushDownProcessor;

public class RubyPushDownDialog
extends RefactoringDialog {
    private final List<RubyMemberInfo> myMemberInfos;
    private final RContainer myClass;
    private final RubyPushDownProcessor myProcessor;
    private MemberInfoModel<RPsiElement, RubyMemberInfo> myMemberInfoModel;

    public RubyPushDownDialog(Project project, RContainer aClass, RubyMemberInfoStorage memberInfos, RubyPushDownProcessor pushDownProcessor) {
        super(project, true);
        this.myMemberInfos = memberInfos.getClassMemberInfos((PsiElement)aClass);
        this.myClass = aClass;
        this.myProcessor = pushDownProcessor;
        this.setTitle(RefactoringBundle.message((String)"push.members.down.title"));
        this.init();
    }

    protected String getHelpId() {
        return "refactoring.pushMembersDown";
    }

    protected void doAction() {
        if (!this.isOKActionEnabled()) {
            return;
        }
        this.myProcessor.prepare(this.getSelectedMemberInfos());
        this.invokeRefactoring(this.myProcessor);
    }

    protected JComponent createNorthPanel() {
        GridBagConstraints gbConstraints = new GridBagConstraints();
        JPanel panel2 = new JPanel(new GridBagLayout());
        gbConstraints.insets = new Insets(4, 0, 4, 8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        String fqn = this.myClass instanceof RClass ? RubyClassResolveUtil.getQualifiedName((RClass)this.myClass) : ((RModule)this.myClass).getQualifiedName();
        panel2.add((Component)new JLabel(RefactoringBundle.message((String)"push.members.from.0.down.label", (Object[])new Object[]{fqn})), gbConstraints);
        return panel2;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        RubyMemberSelectionPanel memberSelectionPanel = new RubyMemberSelectionPanel(RefactoringBundle.message((String)"members.to.be.pushed.down.panel.title"), this.myMemberInfos, null);
        panel2.add((Component)memberSelectionPanel, "Center");
        this.myMemberInfoModel = new MyMemberInfoModel();
        this.myMemberInfoModel.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        memberSelectionPanel.getTable().setMemberInfoModel(this.myMemberInfoModel);
        memberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)this.myMemberInfoModel);
        return panel2;
    }

    public Collection<RubyMemberInfo> getSelectedMemberInfos() {
        ArrayList<RubyMemberInfo> list = new ArrayList<RubyMemberInfo>(this.myMemberInfos.size());
        for (RubyMemberInfo info : this.myMemberInfos) {
            if (!info.isChecked() || !this.myMemberInfoModel.isMemberEnabled((MemberInfoBase)info)) continue;
            list.add(info);
        }
        return list;
    }

    private class MyMemberInfoModel
    extends UsedByDependencyMemberInfoModel<RPsiElement, RContainer, RubyMemberInfo> {
        MyMemberInfoModel() {
            super((PsiElement)RubyPushDownDialog.this.myClass);
        }

        public boolean isMemberEnabled(RubyMemberInfo member) {
            return !(member.getMember() instanceof RConstant);
        }
    }
}

