/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.pushDown;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyOverrideImplementUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyRefactoringUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMemberCollector;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;

public class RubyPushDownConflicts {
    private final RContainer myClazz;
    private final Collection<? extends RubyMemberInfo> myMembers;
    private final MultiMap<PsiElement, String> myConflicts = new MultiMap();

    public RubyPushDownConflicts(RContainer clazz, Collection<? extends RubyMemberInfo> members) {
        this.myClazz = clazz;
        this.myMembers = members;
    }

    public void checkSourceClassConflicts() {
        List memberElements = ContainerUtil.map(this.myMembers, rubyMemberInfo -> (RPsiElement)rubyMemberInfo.getMember());
        for (RPsiElement statement : this.myClazz.getStatements()) {
            HashSet<RPsiElement> collection = new HashSet<RPsiElement>();
            statement.accept((PsiElementVisitor)new NonMovedMembersCollector(collection, memberElements));
            for (RPsiElement element : collection) {
                if (memberElements.contains(statement)) continue;
                String message = RefactoringBundle.message((String)"0.uses.1.which.is.pushed.down", (Object[])new Object[]{StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)statement, (boolean)false)), RefactoringUIUtil.getDescription((PsiElement)element, (boolean)false)});
                this.myConflicts.putValue((Object)statement, (Object)message);
            }
        }
    }

    public void checkTargetClassConflicts(RContainer subClass) {
        this.checkPlacementConflicts(subClass);
        HashSet<RContainer> classes = new HashSet<RContainer>();
        RubyOverrideImplementUtil.addDerivedClasses(this.myClazz, classes);
        classes.add(subClass);
        for (RubyMemberInfo rubyMemberInfo : this.myMembers) {
            RPsiElement memberElement = (RPsiElement)rubyMemberInfo.getMember();
            Query refs = ReferencesSearch.search((PsiElement)memberElement);
            for (PsiReference ref : refs.asIterable()) {
                RContainer clazz;
                PsiElement element = ref.getElement();
                RPsiElement receiver = element instanceof RReference ? ((RReference)element).getReceiver() : null;
                if (receiver == null || classes.contains(clazz = RubyPushDownConflicts.resolveToClass(receiver))) continue;
                String message = RefactoringBundle.message((String)"pushed.members.will.not.be.visible.from.certain.call.sites");
                this.myConflicts.putValue((Object)clazz, (Object)message);
            }
        }
    }

    @Nullable
    private static RContainer resolveToClass(RPsiElement receiver) {
        for (PsiReference ref : receiver.getReferences()) {
            RContainer clazz;
            PsiElement target = ref.resolve();
            RContainer rContainer = clazz = target != null ? RubyPsiUtilCore.getContainingRClassOrModule((PsiElement)target) : null;
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    private void checkPlacementConflicts(RContainer subClass) {
        for (RubyMemberInfo rubyMemberInfo : this.myMembers) {
            RPsiElement element = (RPsiElement)rubyMemberInfo.getMember();
            RMethod subClassMethod = element instanceof RMethod ? RubyRefactoringUtil.findMethodBySignature(subClass, (RMethod)element, false) : null;
            if (subClassMethod == null) continue;
            String message = RefactoringBundle.message((String)"0.already.contains.a.1", (Object[])new Object[]{StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)subClass, (boolean)false)), RefactoringUIUtil.getDescription((PsiElement)element, (boolean)false)});
            this.myConflicts.putValue((Object)subClassMethod, (Object)message);
        }
    }

    public MultiMap<PsiElement, String> getConflicts() {
        return this.myConflicts;
    }

    private static class NonMovedMembersCollector
    extends RubyClassMemberCollector {
        private final List<RPsiElement> myMemberElements;

        protected NonMovedMembersCollector(Set<RPsiElement> collection, List<RPsiElement> memberElements) {
            super(collection);
            this.myMemberElements = memberElements;
        }

        @Override
        protected boolean shouldCollect(RPsiElement element) {
            return element instanceof RMethod && this.myMemberElements.contains(element);
        }
    }
}

