/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.pullUp;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersRefactoringSupport;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassRefactoringHandlerBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfoStorage;
import org.jetbrains.plugins.ruby.ruby.refactoring.pullUp.RubyPullUpDialog;

public final class RubyPullUpHandler
extends RubyClassRefactoringHandlerBase {
    public void showDialog(Project project, PsiElement element, Editor editor, PsiFile file, DataContext dataContext) {
        CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file);
        RContainer clazz = RubyPsiUtilCore.getContainingRClassOrModule((PsiElement)element);
        assert (clazz != null);
        RubyMemberInfoStorage infoStorage = RubyClassMembersRefactoringSupport.getSelectedMemberInfos(clazz, element);
        if (infoStorage.getClassMemberInfos((PsiElement)clazz).isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)RBundle.message((String)"error.hint.no.members.to.pull.up.found")), (String)RefactoringBundle.message((String)"pull.members.up.title"), (String)"members.pull.up");
            return;
        }
        Set<RContainer> classes = infoStorage.getInstanceClasses();
        Set<RContainer> staticModules = infoStorage.getStaticClasses();
        if (classes.isEmpty() && staticModules.isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RBundle.message((String)"pull.up.handler.no.base.classes.in.project", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)clazz)}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RefactoringBundle.message((String)"pull.members.up.title"), (String)"members.pull.up");
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        RubyPullUpDialog dialog = new RubyPullUpDialog(project, clazz, classes, staticModules, infoStorage);
        if (dialog.showAndGet()) {
            RubyPullUpHandler.pullUp(clazz, dialog.getSelectedMemberInfos(), dialog.getSuperClass(), dialog.isStatic());
        }
    }

    protected String getInvalidPositionMessage() {
        return RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.pull.members.from");
    }

    @ApiStatus.Internal
    public static void pullUp(RContainer clazz, Collection<RubyMemberInfo> selectedMemberInfos, RContainer superClass, boolean isStatic) {
        Project project = clazz.getProject();
        CommandProcessor.getInstance().executeCommand(project, () -> PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> WriteAction.run(() -> RubyPullUpHandler.navigate((PsiElement)RubyPullUpHandler.doPullUp(selectedMemberInfos, superClass, isStatic)))), RefactoringBundle.message((String)"pullUp.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)clazz)}), null);
    }

    @Nullable
    private static PsiElement doPullUp(Collection<RubyMemberInfo> selectedMemberInfos, RContainer superClass, boolean isStatic) {
        ArrayList pub = new ArrayList();
        ArrayList prot = new ArrayList();
        ArrayList priv = new ArrayList();
        RubyClassMembersPsiHelper.splitByAccess(selectedMemberInfos, pub, prot, priv);
        PsiElement anchorPrivate = RubyClassMembersPsiHelper.insertMethods(superClass, priv, "private", isStatic);
        PsiElement anchorProtected = RubyClassMembersPsiHelper.insertMethods(superClass, prot, "protected", isStatic);
        PsiElement anchorPublic = RubyClassMembersPsiHelper.insertMethods(superClass, pub, "public", isStatic);
        RubyClassMembersPsiHelper.removeMembers(selectedMemberInfos);
        return anchorPublic != null ? anchorPublic : (anchorProtected != null ? anchorProtected : anchorPrivate);
    }

    protected String getHelpId() {
        return "members.pull.up";
    }

    protected String getTitle() {
        return RefactoringBundle.message((String)"pull.members.up.title");
    }
}

