/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.moveInner;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBBox;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.ruby.refactoring.moveInner.RubyMoveClassModuleImpl;
import org.jetbrains.plugins.ruby.ruby.refactoring.moveInner.RubyMoveClassModuleProcessor;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class RubyMoveClassModuleDialog
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance(RubyMoveClassModuleDialog.class);
    protected JTextField myExtractedContainerNameField;
    protected JTextField myExtractedFileNameField;
    protected TextFieldWithBrowseButton myTargetDirField;
    protected RContainer myContainer;
    private final Type myType;

    public RubyMoveClassModuleDialog(Project project, RContainer container) {
        super(project, true);
        LOG.assertTrue(container instanceof RClass || container instanceof RModule, (Object)("Expected only class of module, but got '" + container.getText() + "'"));
        this.myContainer = container;
        this.myType = this.myContainer.getSymbolType();
        this.myTargetDirField = new TextFieldWithBrowseButton();
        String presentableName = this.myType.getPresentableName();
        this.setTitle(RBundle.message((String)"refactoring.move.class.module.header", (Object[])new Object[]{presentableName != null ? StringUtil.capitalize((String)presentableName) : "Container"}));
        this.initExtractedContainerField();
        this.initExtractedFilePathField();
        this.initTargetDirectoryField();
        this.validateButtons();
        this.setAutoAdjustable(true);
        this.init();
    }

    protected void initExtractedContainerField() {
        this.myExtractedContainerNameField = new JTextField();
        this.myExtractedContainerNameField.setEditable(true);
        this.myExtractedContainerNameField.setText(this.myContainer.getName());
    }

    protected void initExtractedFilePathField() {
        this.myExtractedFileNameField = new JTextField();
        this.myExtractedFileNameField.setEditable(true);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myContainer);
        this.myExtractedFileNameField.setText(NamingConventions.toUnderscoreCase((String)(RubyMoveClassModuleImpl.getClassModuleQualifiedName(this.myContainer) + ".rb"), (Module)module));
        this.myExtractedFileNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                RubyMoveClassModuleDialog.this.validateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/refactoring/moveInner/RubyMoveClassModuleDialog$1", "textChanged"));
            }
        });
    }

    private void initTargetDirectoryField() {
        VirtualFile root = this.getRoot();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(this.getFileBrowserTitle()).withRoots(new VirtualFile[]{root}).withTreeRootVisible(true);
        this.myTargetDirField.setText(FileUtil.toSystemDependentName((String)(root != null ? root.getPath() : "")));
        this.myTargetDirField.addBrowseFolderListener(this.myContainer.getProject(), descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        ((JTextField)this.myTargetDirField.getChildComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                RubyMoveClassModuleDialog.this.validateButtons();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/refactoring/moveInner/RubyMoveClassModuleDialog$2", "textChanged"));
            }
        });
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExtractedContainerNameField;
    }

    protected JComponent createCenterPanel() {
        Box box = this.createBox();
        box.add(Box.createVerticalStrut(10));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)box, "Center");
        return panel2;
    }

    protected Box createBox() {
        JBBox box = JBBox.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        String fromContainerText = this.getContainerQualifiedName();
        JLabel moveContainerLabel = new JLabel(RBundle.message((String)"refactoring.move.class.module.type", (Object[])new Object[]{this.myType.getPresentableName(), fromContainerText}));
        moveContainerLabel.setFont(moveContainerLabel.getFont().deriveFont(1));
        _panel.add((Component)moveContainerLabel, "Center");
        box.add((Component)_panel);
        box.add(Box.createVerticalStrut(10));
        RubyMoveClassModuleDialog.addLabeledField((Box)box, RBundle.message((String)"refactoring.move.class.module.name.prompt", (Object[])new Object[]{this.myType.getPresentableName()}), this.myExtractedContainerNameField, 8);
        RubyMoveClassModuleDialog.addLabeledField((Box)box, RBundle.message((String)"refactoring.move.class.module.to.file.name.prompt"), this.myExtractedFileNameField, 5);
        _panel = new JPanel(new BorderLayout());
        _panel.add((Component)new JLabel(this.getFileBrowserTitle()), "North");
        _panel.add((Component)this.myTargetDirField, "Center");
        box.add((Component)_panel);
        return box;
    }

    @NotNull
    @NlsSafe
    private String getContainerQualifiedName() {
        String qualifiedName = null;
        if (this.myType == Type.CLASS) {
            qualifiedName = RubyClassResolveUtil.getQualifiedName((RClass)this.myContainer);
        } else if (this.myType == Type.MODULE) {
            qualifiedName = ((RModule)this.myContainer).getQualifiedName();
        }
        String string = qualifiedName == null ? "" : qualifiedName;
        if (string == null) {
            RubyMoveClassModuleDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static void addLabeledField(Box box, @NlsContexts.Label String labelText, JTextField field, int height) {
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)new JLabel(labelText), "North");
        _panel.add((Component)field, "Center");
        box.add(_panel);
        box.add(Box.createVerticalStrut(height));
    }

    @Nullable
    private PsiDirectory findPsiDirectory(String targetDirectory) {
        VirtualFile directory = LocalFileSystem.getInstance().findFileByPath(targetDirectory);
        if (directory == null) {
            return null;
        }
        PsiDirectory psiDirectory = this.myContainer.getManager().findDirectory(directory);
        if (psiDirectory == null) {
            return null;
        }
        return psiDirectory;
    }

    @Nullable
    protected VirtualFile getRoot() {
        return this.myContainer.getContainingFile().getVirtualFile().getParent();
    }

    @NlsContexts.DialogTitle
    @NotNull
    protected String getFileBrowserTitle() {
        String string = RBundle.message((String)"refactoring.move.class.module.directory", (Object[])new Object[]{this.myType.getPresentableName()});
        if (string == null) {
            RubyMoveClassModuleDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public PsiDirectory getTargetDirectory() {
        return this.findPsiDirectory(this.myTargetDirField.getText());
    }

    @NotNull
    public String getFilePath() {
        String string = this.myExtractedFileNameField.getText().trim();
        if (string == null) {
            RubyMoveClassModuleDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getNewContainerName() {
        String string = this.myExtractedContainerNameField.getText();
        if (string == null) {
            RubyMoveClassModuleDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected String getHelpId() {
        return "refactoring.move.module.dialog";
    }

    protected void doAction() {
        String newShortContainerName = this.getNewContainerName();
        String fileRelativePath = this.getFilePath();
        PsiDirectory directory = this.getTargetDirectory();
        if (directory == null) {
            LOG.error("Target directory must be specified.");
            return;
        }
        this.invokeRefactoring(new RubyMoveClassModuleProcessor(this.myProject, this.myContainer, newShortContainerName, fileRelativePath, directory));
    }

    protected void validateButtons() {
        super.validateButtons();
        this.setErrorText(this.getValidationError());
    }

    protected boolean areButtonsValid() {
        return this.getValidationError() == null;
    }

    @NlsContexts.DialogMessage
    @Nullable
    private String getValidationError() {
        PsiDirectory psiDirectory = this.getTargetDirectory();
        if (psiDirectory == null) {
            return RBundle.message((String)"refactoring.move.class.module.warning.directory");
        }
        return psiDirectory.getVirtualFile().findFileByRelativePath(this.getFilePath()) != null ? RBundle.message((String)"refactoring.move.class.module.warning.file.exists") : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/moveInner/RubyMoveClassModuleDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerQualifiedName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBrowserTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewContainerName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

